/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client.imploder;

import org.spoofax.interpreter.terms.ISimpleTerm;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.jsglr.client.imploder.IToken;
import org.spoofax.jsglr.client.imploder.ITokenizer;
import org.spoofax.jsglr.client.imploder.ListImploderAttachment;
import org.spoofax.jsglr.client.imploder.NullTokenizer;
import org.spoofax.jsglr.client.imploder.Token;
import org.spoofax.terms.Term;
import org.spoofax.terms.TermVisitor;
import org.spoofax.terms.attachments.AbstractTermAttachment;
import org.spoofax.terms.attachments.OriginAttachment;
import org.spoofax.terms.attachments.TermAttachmentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImploderAttachment
extends AbstractTermAttachment {
    private static final long serialVersionUID = -578795745164445689L;
    public static final TermAttachmentType<ImploderAttachment> TYPE = new TermAttachmentType<ImploderAttachment>(ImploderAttachment.class, "ImploderAttachment", 6){

        @Override
        protected IStrategoTerm[] toSubterms(ITermFactory f, ImploderAttachment attachment) {
            IToken left = attachment.getLeftToken();
            IToken right = attachment.getRightToken();
            String sortType = attachment.getSort() == null ? "" : attachment.getSort();
            String fileName = left.getTokenizer().getFilename() == null ? "" : left.getTokenizer().getFilename();
            return new IStrategoTerm[]{f.makeString(fileName), f.makeInt(left.getLine()), f.makeInt(left.getColumn()), f.makeInt(left.getStartOffset()), f.makeInt(right.getEndOffset()), f.makeString(sortType)};
        }

        @Override
        protected ImploderAttachment fromSubterms(IStrategoTerm[] subterms) {
            String fileName = Term.asJavaString(subterms[0]).equals("") ? null : Term.asJavaString(subterms[0]);
            String sortType = Term.asJavaString(subterms[0]).equals("") ? null : Term.asJavaString(subterms[5]);
            return ImploderAttachment.createCompactPositionAttachment(fileName, Term.asJavaInt(subterms[1]), Term.asJavaInt(subterms[2]), Term.asJavaInt(subterms[3]), Term.asJavaInt(subterms[4]), sortType);
        }
    };
    private final IToken leftToken;
    private final IToken rightToken;
    private final String sort;

    protected ImploderAttachment(String sort, IToken leftToken, IToken rightToken) {
        assert (leftToken != null && rightToken != null);
        this.sort = sort;
        this.leftToken = leftToken;
        this.rightToken = rightToken;
    }

    public TermAttachmentType<ImploderAttachment> getAttachmentType() {
        return TYPE;
    }

    public static ImploderAttachment get(ISimpleTerm term) {
        return term.getAttachment(TYPE);
    }

    public IToken getLeftToken() {
        return this.leftToken;
    }

    public IToken getRightToken() {
        return this.rightToken;
    }

    public String getSort() {
        return this.sort;
    }

    public boolean isSequenceAttachment() {
        return false;
    }

    public String getElementSort() {
        return this.getSort();
    }

    public static IToken getLeftToken(ISimpleTerm term) {
        ImploderAttachment attachment = term.getAttachment(TYPE);
        if (attachment == null) {
            assert (!ImploderAttachment.hasImploderOrigin(term)) : "Likely error: called getLeftToken() on term with imploder origin, instead of the origin itself";
            return null;
        }
        return attachment.getLeftToken();
    }

    public static IToken getRightToken(ISimpleTerm term) {
        ImploderAttachment attachment = term.getAttachment(TYPE);
        if (attachment == null) {
            assert (!ImploderAttachment.hasImploderOrigin(term)) : "Likely error: called getRightToken() on term with imploder origin, instead of the origin itself";
            return null;
        }
        return attachment.getRightToken();
    }

    public static String getSort(ISimpleTerm term) {
        ImploderAttachment attachment = term.getAttachment(TYPE);
        return attachment == null ? null : attachment.getSort();
    }

    public static String getElementSort(ISimpleTerm term) {
        ImploderAttachment attachment = term.getAttachment(TYPE);
        return attachment == null ? null : attachment.getElementSort();
    }

    public static String getFilename(ISimpleTerm term) {
        IToken token = ImploderAttachment.getLeftToken(term);
        return token == null ? null : token.getTokenizer().getFilename();
    }

    public static ITokenizer getTokenizer(ISimpleTerm term) {
        IToken token = ImploderAttachment.getLeftToken(term);
        assert (token == null || token.getTokenizer() == ImploderAttachment.getRightToken(term).getTokenizer()) : "Tokenizer of left and right token inconsistent";
        return token == null ? null : token.getTokenizer();
    }

    public static boolean hasImploderOrigin(ISimpleTerm term) {
        IStrategoTerm origin = OriginAttachment.getOrigin(term);
        if (origin != null) {
            term = origin;
        }
        return term.getAttachment(TYPE) != null;
    }

    public static IStrategoTerm getImploderOrigin(IStrategoTerm term) {
        IStrategoTerm origin = OriginAttachment.getOrigin(term);
        if (origin != null) {
            term = origin;
        }
        return term.getAttachment(TYPE) != null ? term : null;
    }

    public static ImploderAttachment getCompactPositionAttachment(IStrategoTerm term, boolean useOnlyFirstAttach) {
        if (useOnlyFirstAttach) {
            FirstAttachFetcher fetcher = new FirstAttachFetcher();
            fetcher.visit(term);
            return ImploderAttachment.getCompactPositionAttachment(fetcher.result, fetcher.result);
        }
        FirstLastAttachFetcher fetcher = new FirstLastAttachFetcher();
        fetcher.visit(term);
        return ImploderAttachment.getCompactPositionAttachment(fetcher.first, fetcher.last);
    }

    public static ImploderAttachment getCompactPositionAttachment(ImploderAttachment first, ImploderAttachment last) {
        if (first == null || last == null) {
            return null;
        }
        IToken left = first.getLeftToken();
        IToken right = last.getRightToken();
        String filename = left.getTokenizer().getFilename();
        return ImploderAttachment.createCompactPositionAttachment(filename, left.getLine(), left.getColumn(), left.getStartOffset(), right.getEndOffset());
    }

    public static ImploderAttachment createCompactPositionAttachment(String filename, int line, int column, int startOffset, int endOffset) {
        return ImploderAttachment.createCompactPositionAttachment(filename, line, column, startOffset, endOffset, null);
    }

    public static ImploderAttachment createCompactPositionAttachment(String filename, int line, int column, int startOffset, int endOffset, String sortType) {
        Token token = new Token(null, 0, line, column, startOffset, endOffset, 0);
        NullTokenizer newTokenizer = new NullTokenizer(sortType, filename, token);
        token.setTokenizer(newTokenizer);
        return new ImploderAttachment(null, token, token);
    }

    public static void putImploderAttachment(ISimpleTerm term, boolean isAnonymousSequence, String sort, IToken leftToken, IToken rightToken) {
        term.putAttachment(isAnonymousSequence ? new ListImploderAttachment(sort, leftToken, rightToken) : new ImploderAttachment(sort, leftToken, rightToken));
    }

    public String toString() {
        if (this.getLeftToken() != null) {
            return "(" + this.getSort() + ",\"" + this.getLeftToken().getTokenizer().toString(this.getLeftToken(), this.getRightToken()) + "\")";
        }
        return "(" + this.getSort() + ",null)";
    }

    static class FirstAttachFetcher
    extends TermVisitor {
        ImploderAttachment result;

        FirstAttachFetcher() {
        }

        public void preVisit(IStrategoTerm term) {
            ImploderAttachment attach;
            term = OriginAttachment.tryGetOrigin(term);
            this.result = attach = ImploderAttachment.get(term);
        }

        public boolean isDone(IStrategoTerm term) {
            return this.result != null;
        }
    }

    static class FirstLastAttachFetcher
    extends TermVisitor {
        ImploderAttachment first;
        ImploderAttachment last;

        FirstLastAttachFetcher() {
        }

        public void preVisit(IStrategoTerm term) {
            ImploderAttachment attach = (term = OriginAttachment.tryGetOrigin(term)).getAttachment(TYPE);
            if (attach == null) {
                return;
            }
            if (this.first == null) {
                this.first = attach;
            }
            this.last = attach;
        }
    }
}

