/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client.imploder;

import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.jsglr.client.imploder.ProductionAttributeReader;
import org.spoofax.terms.Term;

public class LabelInfo {
    private final IStrategoAppl production;
    private final String sort;
    private final String constructor;
    private final String deprecationMessage;
    private final IStrategoTerm astAttribute;
    private final boolean isNonContextFree;
    private final boolean isLexical;
    private final boolean isVar;
    private final boolean isList;
    private final boolean isIndentPaddingLexical;
    private final boolean isLexLayout;
    private final boolean isSortProduction;
    private final boolean isLayout;
    private final boolean isLiteral;
    private final boolean isOptional;
    private final boolean isRecover;
    private final boolean isCompletion;
    private final boolean isReject;
    private final String metaVarConstructor;

    public LabelInfo(ProductionAttributeReader reader, IStrategoAppl production) {
        this.production = production;
        IStrategoAppl rhs = this.getRHS();
        IStrategoAppl attrs = this.getAttrs();
        this.sort = reader.getSort(rhs);
        this.constructor = reader.getConsAttribute(attrs);
        this.astAttribute = reader.getAstAttribute(attrs);
        this.isNonContextFree = reader.isNonContextFree(rhs);
        this.isList = reader.isList(rhs);
        this.isVar = reader.isVariableNode(rhs);
        this.isIndentPaddingLexical = reader.isIndentPaddingLexical(attrs);
        this.isLexLayout = reader.isLexLayout(rhs);
        this.isLexical = reader.isLexical(rhs);
        this.isLayout = reader.isLayout(rhs);
        this.isLiteral = reader.isLiteral(rhs);
        this.isOptional = reader.isOptional(rhs);
        this.isRecover = reader.isRecoverProduction(attrs, this.constructor);
        this.isCompletion = reader.isCompletionProduction(attrs, production.getSubtermCount());
        this.isReject = reader.isRejectProduction(attrs);
        this.deprecationMessage = reader.getDeprecationMessage(attrs);
        this.isSortProduction = reader.sortFun == rhs.getConstructor() || reader.parameterizedSortFun == rhs.getConstructor();
        this.metaVarConstructor = reader.getMetaVarConstructor(rhs);
    }

    protected IStrategoList getLHS() {
        return (IStrategoList)Term.termAt(this.production, 0);
    }

    protected IStrategoAppl getRHS() {
        return (IStrategoAppl)Term.termAt(this.production, 1);
    }

    protected IStrategoAppl getAttrs() {
        return (IStrategoAppl)Term.termAt(this.production, 2);
    }

    public String getSort() {
        return this.sort;
    }

    public String getConstructor() {
        return this.constructor;
    }

    public IStrategoTerm getAstAttribute() {
        return this.astAttribute;
    }

    public boolean isNonContextFree() {
        return this.isNonContextFree;
    }

    public boolean isLexical() {
        return this.isLexical;
    }

    public boolean isList() {
        return this.isList;
    }

    public boolean isVar() {
        return this.isVar;
    }

    public boolean isIndentPaddingLexical() {
        return this.isIndentPaddingLexical;
    }

    public boolean isLexLayout() {
        return this.isLexLayout;
    }

    public boolean isLayout() {
        return this.isLayout;
    }

    public boolean isLiteral() {
        return this.isLiteral;
    }

    public boolean isRecover() {
        return this.isRecover;
    }

    public boolean isCompletion() {
        return this.isCompletion && !this.isLiteral;
    }

    public boolean isReject() {
        return this.isReject;
    }

    public String getDeprecationMessage() {
        return this.deprecationMessage;
    }

    public boolean isSortProduction() {
        return this.isSortProduction;
    }

    public String getMetaVarConstructor() {
        return this.metaVarConstructor;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public String toString() {
        return this.production.toString();
    }
}

