/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client.imploder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.spoofax.NotImplementedException;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoReal;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.jsglr.client.imploder.IToken;
import org.spoofax.jsglr.client.imploder.ITreeFactory;
import org.spoofax.jsglr.client.imploder.ImploderAttachment;
import org.spoofax.terms.StrategoListIterator;
import org.spoofax.terms.StrategoSubList;
import org.spoofax.terms.Term;
import org.spoofax.terms.TermFactory;
import org.spoofax.terms.attachments.ParentAttachment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TermTreeFactory
implements ITreeFactory<IStrategoTerm> {
    private final ITermFactory originalFactory;
    private ITermFactory factory;
    private boolean enableTokens;

    public TermTreeFactory() {
        this(new TermFactory());
    }

    public TermTreeFactory(ITermFactory factory) {
        this.originalFactory = factory;
        this.setEnableTokens(false);
    }

    @Override
    public void setEnableTokens(boolean enableTokens) {
        this.enableTokens = enableTokens;
        if (enableTokens) {
            this.factory = this.originalFactory.getFactoryWithStorageType(0);
            if (!TermFactory.checkStorageType(this.factory, 0)) {
                throw new IllegalStateException("Term factory does not support MUTABLE terms, required for creating terms with (token) attachments");
            }
        } else {
            this.factory = this.originalFactory;
        }
    }

    public ITermFactory getTermFactory() {
        return this.factory;
    }

    public ITermFactory getOriginalTermFactory() {
        return this.originalFactory;
    }

    public IStrategoConstructor createConstructor(String name, int childCount) {
        return this.factory.makeConstructor(name, childCount);
    }

    @Override
    public IStrategoTerm createNonTerminal(String sort, String constructor, IToken leftToken, IToken rightToken, List<IStrategoTerm> children) {
        IStrategoConstructor cons = this.factory.makeConstructor(constructor, children.size());
        IStrategoAppl result = this.factory.makeAppl(cons, children.toArray(new IStrategoTerm[children.size()]));
        this.configure(result, sort, leftToken, rightToken, false);
        return result;
    }

    @Override
    public IStrategoTerm createIntTerminal(String sort, IToken token, int value) {
        IStrategoInt result = this.factory.makeInt(value);
        this.configure(result, sort, token, token, false);
        return result;
    }

    @Override
    public IStrategoTerm createRealTerminal(String sort, IToken token, double value) {
        IStrategoReal result = this.factory.makeReal(value);
        this.configure(result, sort, token, token, false);
        return result;
    }

    @Override
    public IStrategoTerm createStringTerminal(String sort, IToken leftToken, IToken rightToken, String value) {
        IStrategoString result = this.factory.makeString(value);
        this.configure(result, sort, leftToken, rightToken, false);
        return result;
    }

    @Override
    public IStrategoTerm createTuple(String elementSort, IToken leftToken, IToken rightToken, List<IStrategoTerm> children) {
        IStrategoTuple result = this.factory.makeTuple(TermTreeFactory.toArray(children));
        this.configure(result, elementSort, leftToken, rightToken, true);
        return result;
    }

    @Override
    public IStrategoTerm createAmb(List<IStrategoTerm> alternatives, IToken leftToken, IToken rightToken) {
        ArrayList<Object> alternativesInList = new ArrayList<Object>();
        alternativesInList.add(this.createList((String)null, leftToken, rightToken, (List)alternatives));
        return this.createNonTerminal((String)null, "amb", leftToken, rightToken, alternativesInList);
    }

    @Override
    public IStrategoTerm createList(String elementSort, IToken leftToken, IToken rightToken, List<IStrategoTerm> children) {
        IStrategoList result = this.factory.makeList(TermTreeFactory.toArray(children));
        this.configure(result, elementSort, leftToken, rightToken, true);
        return result;
    }

    @Override
    public IStrategoTerm createSublist(IStrategoList list, IStrategoTerm firstChild, IStrategoTerm lastChild) {
        ArrayList<IStrategoTerm> children = new ArrayList<IStrategoTerm>();
        boolean isStartChildFound = false;
        int indexStart = -1;
        int indexEnd = -1;
        int i = 0;
        for (IStrategoTerm child : StrategoListIterator.iterable(list)) {
            if (child == firstChild) {
                indexStart = i;
                isStartChildFound = true;
            }
            if (isStartChildFound) {
                children.add(child);
                if (child == lastChild) {
                    indexEnd = i;
                    break;
                }
            }
            ++i;
        }
        assert (indexStart >= 0 && indexStart <= indexEnd);
        IStrategoList wrapped = this.factory.makeList(children);
        StrategoSubList result = new StrategoSubList(list, wrapped, indexStart, indexEnd);
        ParentAttachment.putParent(result, ParentAttachment.get(list));
        if (ImploderAttachment.get(firstChild) != null && ImploderAttachment.get(lastChild) != null) {
            ImploderAttachment.putImploderAttachment(result, true, ImploderAttachment.getElementSort(list), this.getLeftToken(firstChild), this.getRightToken(lastChild));
        }
        return result;
    }

    @Override
    public IStrategoTerm recreateNode(IStrategoTerm oldNode, IToken leftToken, IToken rightToken, List<IStrategoTerm> children) {
        switch (oldNode.getTermType()) {
            case 3: {
                return this.createIntTerminal(ImploderAttachment.getSort(oldNode), leftToken, ((IStrategoInt)oldNode).intValue());
            }
            case 1: {
                return this.createNonTerminal(ImploderAttachment.getSort(oldNode), ((IStrategoAppl)oldNode).getName(), leftToken, rightToken, (List)children);
            }
            case 2: {
                return this.createList(ImploderAttachment.getElementSort(oldNode), leftToken, rightToken, (List)children);
            }
            case 5: {
                return this.createStringTerminal(ImploderAttachment.getSort(oldNode), leftToken, rightToken, ((IStrategoString)oldNode).stringValue());
            }
            case 7: {
                return this.createTuple(ImploderAttachment.getElementSort(oldNode), leftToken, rightToken, (List)children);
            }
            case 4: {
                return this.createRealTerminal(ImploderAttachment.getElementSort(oldNode), leftToken, ((IStrategoReal)oldNode).realValue());
            }
        }
        throw new NotImplementedException("Recreating term of type " + oldNode.getTermType() + " (" + oldNode + ") not supported");
    }

    @Override
    public String tryGetStringValue(IStrategoTerm node) {
        return Term.isTermString(node) ? ((IStrategoString)node).stringValue() : null;
    }

    @Override
    public IStrategoTerm createInjection(String sort, List<IStrategoTerm> children) {
        if (children.size() == 1) {
            return children.get(0);
        }
        IStrategoTuple result = this.factory.makeTuple(TermTreeFactory.toArray(children));
        IToken left = this.getLeftToken(children.get(0));
        IToken right = this.getRightToken(children.get(children.size() - 1));
        this.configure(result, null, left, right, true);
        return result;
    }

    @Override
    public Iterable<IStrategoTerm> getChildren(IStrategoTerm node) {
        if (node instanceof Iterable) {
            Iterable result = (Iterable)((Object)node);
            return result;
        }
        if (node.getSubtermCount() == 0) {
            return Collections.emptyList();
        }
        ArrayList<IStrategoTerm> children = new ArrayList<IStrategoTerm>(node.getSubtermCount());
        int i = 0;
        int max2 = node.getSubtermCount();
        while (i < max2) {
            children.add(node.getSubterm(i));
            ++i;
        }
        return children;
    }

    private static IStrategoTerm[] toArray(List<IStrategoTerm> children) {
        return children.toArray(new IStrategoTerm[children.size()]);
    }

    @Override
    public final IToken getLeftToken(IStrategoTerm term) {
        return ImploderAttachment.getLeftToken(term);
    }

    @Override
    public final IToken getRightToken(IStrategoTerm term) {
        return ImploderAttachment.getRightToken(term);
    }

    @Override
    public Iterable<IStrategoTerm> tryGetAmbChildren(IStrategoTerm node) {
        if (Term.isTermAppl(node) && "amb".equals(((IStrategoAppl)node).getName())) {
            return StrategoListIterator.iterable((IStrategoList)node.getSubterm(0));
        }
        return null;
    }

    @Override
    public IStrategoTerm createTop(IStrategoTerm tree, String filename, int ambiguityCount) {
        return tree;
    }

    protected void configure(IStrategoTerm term, String sort, IToken leftToken, IToken rightToken, boolean isListOrTuple) {
        assert (isListOrTuple == (term.getTermType() == 7 || term.getTermType() == 2));
        if (this.enableTokens) {
            ImploderAttachment.putImploderAttachment(term, isListOrTuple, sort, leftToken, rightToken);
        }
    }
}

