/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client.imploder;

import java.util.HashMap;
import java.util.Map;
import org.spoofax.interpreter.terms.ISimpleTerm;
import org.spoofax.jsglr.client.imploder.IToken;
import org.spoofax.jsglr.client.imploder.ITokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Token
implements IToken,
Cloneable {
    private static final long serialVersionUID = -6972938219235720902L;
    private static transient Map<String, Integer> asyncAllTokenKinds;
    private transient ITokenizer tokenizer;
    private final int line;
    private final int column;
    private final int startOffset;
    private int endOffset;
    private int index;
    private int kind;
    private String errorMessage;
    private ISimpleTerm astNode;

    public Token(ITokenizer tokenizer, int index, int line, int column, int startOffset, int endOffset, int kind) {
        this(tokenizer, index, line, column, startOffset, endOffset, kind, null, null);
    }

    public Token(ITokenizer tokenizer, int index, int line, int column, int startOffset, int endOffset, int kind, String errorMessage, ISimpleTerm astNode) {
        this.tokenizer = tokenizer;
        this.index = index;
        this.line = line;
        this.column = column;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.kind = kind;
    }

    @Override
    public ITokenizer getTokenizer() {
        return this.tokenizer;
    }

    protected void setTokenizer(ITokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    @Override
    public int getKind() {
        return this.kind;
    }

    @Override
    public void setKind(int kind) {
        this.kind = kind;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    protected void setIndex(int index) {
        this.index = index;
    }

    @Override
    public final int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public final int getEndOffset() {
        return this.endOffset;
    }

    public void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getEndLine() {
        return this.line;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public int getEndColumn() {
        return this.column + this.getEndOffset() - this.getStartOffset();
    }

    @Override
    public int getLength() {
        return this.getEndOffset() - this.getStartOffset() + 1;
    }

    @Override
    public String getError() {
        return this.errorMessage;
    }

    public void setError(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setAstNode(ISimpleTerm astNode) {
        this.astNode = astNode;
    }

    @Override
    public ISimpleTerm getAstNode() {
        if (this.astNode == null) {
            this.getTokenizer().initAstNodeBinding();
        }
        return this.astNode;
    }

    public String toString() {
        return this.tokenizer.toString(this, this);
    }

    @Override
    public char charAt(int index) {
        return this.tokenizer.getInput().charAt(index + this.startOffset);
    }

    @Override
    public int compareTo(IToken other) {
        if (this.endOffset <= other.getEndOffset()) {
            return -1;
        }
        if (this.startOffset > other.getStartOffset()) {
            return 1;
        }
        return 0;
    }

    public static int indexOf(IToken token, char c) {
        String stream = token.getTokenizer().getInput();
        int i = token.getStartOffset();
        int last = token.getEndOffset();
        while (i <= last) {
            if (stream.charAt(i) == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean isWhiteSpace(IToken token) {
        String input = token.getTokenizer().getInput();
        int i = token.getStartOffset();
        int last = token.getEndOffset();
        while (i <= last) {
            switch (input.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static String tokenKindToString(int kind) {
        return "tokenKind#" + kind;
    }

    public static int valueOf(String tokenKind) {
        Integer result = Token.getTokenKindMap().get(tokenKind);
        return result == null ? 64 : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Integer> getTokenKindMap() {
        Class<Token> clazz = Token.class;
        synchronized (Token.class) {
            if (asyncAllTokenKinds != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return asyncAllTokenKinds;
            }
            asyncAllTokenKinds = new HashMap<String, Integer>();
            asyncAllTokenKinds.put("TK_UNKNOWN", 0);
            asyncAllTokenKinds.put("TK_IDENTIFIER", 1);
            asyncAllTokenKinds.put("TK_NUMBER", 2);
            asyncAllTokenKinds.put("TK_STRING", 3);
            asyncAllTokenKinds.put("TK_KEYWORD", 4);
            asyncAllTokenKinds.put("TK_OPERATOR", 5);
            asyncAllTokenKinds.put("TK_VAR", 6);
            asyncAllTokenKinds.put("TK_LAYOUT", 7);
            asyncAllTokenKinds.put("TK_EOF", 8);
            asyncAllTokenKinds.put("TK_ERROR", 9);
            asyncAllTokenKinds.put("TK_ERROR_KEYWORD", 10);
            asyncAllTokenKinds.put("TK_ERROR_EOF_UNEXPECTED", 12);
            asyncAllTokenKinds.put("TK_ERROR_LAYOUT", 11);
            asyncAllTokenKinds.put("TK_RESERVED", 63);
            asyncAllTokenKinds.put("TK_NO_TOKEN_KIND", 64);
            // ** MonitorExit[var0] (shouldn't be in output)
            return asyncAllTokenKinds;
        }
    }

    @Override
    public Token clone() {
        try {
            return (Token)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

