/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client.incremental;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.spoofax.interpreter.terms.ISimpleTerm;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.jsglr.client.Label;
import org.spoofax.jsglr.client.ParseTable;
import org.spoofax.jsglr.client.imploder.ImploderAttachment;
import org.spoofax.jsglr.client.imploder.ProductionAttributeReader;
import org.spoofax.terms.Term;
import org.spoofax.terms.attachments.ParentAttachment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncrementalSortSet {
    private final IStrategoConstructor sortFun;
    private final IStrategoConstructor cfFun;
    private final IStrategoConstructor lexFun;
    private final Set<String> incrementalSorts;
    private final Set<String> incrementalContainerSorts;

    public Set<String> getIncrementalSorts() {
        return Collections.unmodifiableSet(this.incrementalSorts);
    }

    private IncrementalSortSet(ParseTable table, boolean expand, boolean expandReverse, Set<String> sorts) {
        this.sortFun = table.getFactory().makeConstructor("sort", 1);
        this.cfFun = table.getFactory().makeConstructor("cf", 1);
        this.lexFun = table.getFactory().makeConstructor("lex", 1);
        this.incrementalSorts = expand ? this.getInjectionsTo(table, sorts, false) : sorts;
        this.incrementalContainerSorts = expandReverse ? this.getInjectionsTo(table, this.incrementalSorts, true) : this.incrementalSorts;
    }

    public static IncrementalSortSet create(ParseTable table, boolean expand, String ... sorts) {
        return new IncrementalSortSet(table, expand, true, IncrementalSortSet.asSet(sorts));
    }

    public static IncrementalSortSet create(ParseTable table, boolean expand, Set<String> sorts) {
        return new IncrementalSortSet(table, expand, true, sorts);
    }

    public static IncrementalSortSet create(ParseTable table, boolean expand, boolean expandReverse, String ... sorts) {
        return new IncrementalSortSet(table, expand, expandReverse, IncrementalSortSet.asSet(sorts));
    }

    public static IncrementalSortSet create(ParseTable table, boolean expand, boolean expandReverse, Set<String> sorts) {
        return new IncrementalSortSet(table, expand, expandReverse, sorts);
    }

    public static IncrementalSortSet read(ParseTable table) {
        IStrategoConstructor incrementalFun = table.getFactory().makeConstructor("incremental", 0);
        ProductionAttributeReader reader = new ProductionAttributeReader(table.getFactory());
        HashSet<String> sorts = new HashSet<String>();
        int i = 257;
        int max2 = table.getProductionCount();
        while (i < max2) {
            IStrategoTerm prod = table.getProduction(i);
            if (IncrementalSortSet.isIncrementalProduction(prod, incrementalFun)) {
                sorts.add(reader.getSort(Term.applAt(prod, 1)));
            }
            ++i;
        }
        return IncrementalSortSet.create(table, true, sorts);
    }

    private static boolean isIncrementalProduction(IStrategoTerm prod, IStrategoConstructor incrementalFun) {
        Object attrsContainer = Term.termAt(prod, 2);
        if (attrsContainer.getSubtermCount() > 0) {
            IStrategoList attrs = (IStrategoList)Term.termAt(attrsContainer, 0);
            while (!attrs.isEmpty()) {
                IStrategoTerm attr = attrs.head();
                if (attr.getSubtermCount() == 1) {
                    attr = attr.getSubterm(0);
                }
                if (Term.tryGetConstructor(attr) == incrementalFun) {
                    return true;
                }
                attrs = attrs.tail();
            }
        }
        return false;
    }

    public boolean isEmpty() {
        return this.incrementalSorts.size() == 0;
    }

    public boolean isIncrementalNode(ISimpleTerm term) {
        IStrategoTerm parent = ParentAttachment.getParent(term);
        return parent != null && parent.isList() && this.incrementalSorts.contains(ImploderAttachment.getSort(term));
    }

    public boolean isIncrementalContainerNode(ISimpleTerm list) {
        assert (list.isList());
        return this.incrementalContainerSorts.contains(ImploderAttachment.getElementSort(list));
    }

    private static <T> Set<T> asSet(T ... values) {
        HashSet<T> results = new HashSet<T>(values.length);
        T[] TArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            T value = TArray[n2];
            results.add(value);
            ++n2;
        }
        return results;
    }

    private Set<String> getInjectionsTo(ParseTable table, Collection<String> sorts, boolean reverse) {
        while (true) {
            int oldSize = sorts.size();
            HashSet<String> results = new HashSet<String>();
            for (String sort : sorts) {
                this.addInjectionsTo(table, sort, reverse, results);
            }
            if (oldSize == results.size()) {
                return results;
            }
            sorts = results;
        }
    }

    private void addInjectionsTo(ParseTable table, String sort, boolean reverse, Set<String> results) {
        ITermFactory factory = table.getFactory();
        IStrategoAppl sortTerm = factory.makeAppl(this.sortFun, factory.makeString(sort));
        for (Label l : table.getLabels()) {
            IStrategoTerm sort2;
            IStrategoTerm sort1;
            if (l == null) continue;
            IStrategoAppl production = l.getProduction();
            IStrategoTerm iStrategoTerm = sort1 = reverse ? this.getFromSort(production) : this.getToSort(production);
            if (!sortTerm.equals(sort1)) continue;
            IStrategoTerm iStrategoTerm2 = sort2 = reverse ? this.getToSort(production) : this.getFromSort(production);
            if (sort2 == null) continue;
            results.add(Term.asJavaString(Term.termAt(sort2, 0)));
        }
        results.add(sort);
    }

    private IStrategoTerm getToSort(IStrategoAppl production) {
        Object toSort = Term.termAt(production, 1);
        toSort = this.stripFun((IStrategoTerm)toSort, this.cfFun);
        if (((IStrategoAppl)(toSort = this.stripFun((IStrategoTerm)toSort, this.lexFun))).getConstructor() != this.sortFun) {
            return null;
        }
        return toSort;
    }

    private IStrategoTerm getFromSort(IStrategoAppl production) {
        IStrategoList lhs = (IStrategoList)Term.termAt(production, 0);
        if (lhs.getSubtermCount() != 1) {
            return null;
        }
        IStrategoTerm lhsFirst = lhs.head();
        lhsFirst = this.stripFun(lhsFirst, this.cfFun);
        if (((IStrategoAppl)(lhsFirst = this.stripFun(lhsFirst, this.lexFun))).getConstructor() != this.sortFun) {
            return null;
        }
        return lhsFirst;
    }

    public IStrategoTerm stripFun(IStrategoTerm appl, IStrategoConstructor fun) {
        if (Term.isTermAppl(appl) && ((IStrategoAppl)appl).getConstructor() == fun) {
            return Term.termAt(appl, 0);
        }
        return appl;
    }

    public String toString() {
        return "(" + this.incrementalSorts + ", " + this.incrementalContainerSorts + ")";
    }
}

