/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms;

import java.io.IOException;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.interpreter.terms.ITermPrinter;
import org.spoofax.terms.StrategoTerm;
import org.spoofax.terms.TermFactory;

public final class StrategoConstructor
extends StrategoTerm
implements IStrategoConstructor {
    private static final long serialVersionUID = -4477361122406081825L;
    private final String name;
    private final int arity;

    public StrategoConstructor(String name, int arity) {
        super(null, 2);
        this.name = name;
        this.arity = arity;
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
    }

    public int getArity() {
        return this.arity;
    }

    public String getName() {
        return this.name;
    }

    public IStrategoTerm[] getAllSubterms() {
        return TermFactory.EMPTY;
    }

    public IStrategoTerm getSubterm(int index) {
        throw new UnsupportedOperationException();
    }

    public int getSubtermCount() {
        return 0;
    }

    public final int getTermType() {
        return 6;
    }

    protected boolean doSlowMatch(IStrategoTerm second, int commonStorageType) {
        if (second == this) {
            return true;
        }
        if (second == null || second.getTermType() != 6) {
            return false;
        }
        IStrategoConstructor other = (IStrategoConstructor)second;
        return this.name.equals(other.getName()) && this.arity == other.getArity();
    }

    public void prettyPrint(ITermPrinter pp) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return String.valueOf(this.name) + "/" + this.arity;
    }

    public void writeAsString(Appendable output, int maxDepth) throws IOException {
        output.append(this.name);
        output.append('/');
        output.append(Integer.toString(this.arity));
    }

    public IStrategoConstructor getConstructor() {
        return this;
    }

    public int hashFunction() {
        return this.name.hashCode() + 5407 * this.arity;
    }

    @Deprecated
    public IStrategoAppl instantiate(ITermFactory factory, IStrategoTerm ... kids) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public IStrategoAppl instantiate(ITermFactory factory, IStrategoList kids) {
        throw new UnsupportedOperationException();
    }
}

