/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms;

import java.io.IOException;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermPrinter;
import org.spoofax.terms.StrategoTerm;
import org.spoofax.terms.TermFactory;

public class StrategoString
extends StrategoTerm
implements IStrategoString {
    private static final long serialVersionUID = 237308007762215350L;
    private final String value;

    public StrategoString(String value, IStrategoList annotations, int storageType) {
        super(annotations, storageType);
        this.value = value;
        assert (storageType != 3 || annotations == null);
        this.initImmutableHashCode();
    }

    protected StrategoString(String value) {
        this(value, TermFactory.EMPTY_LIST, 1);
    }

    public IStrategoTerm getSubterm(int index) {
        throw new IndexOutOfBoundsException();
    }

    public IStrategoTerm[] getAllSubterms() {
        return TermFactory.EMPTY;
    }

    public int getSubtermCount() {
        return 0;
    }

    public int getTermType() {
        return 5;
    }

    protected boolean doSlowMatch(IStrategoTerm second, int commonStorageType) {
        IStrategoList secondAnnotations;
        String secondValue;
        if (second.getTermType() != 5) {
            return false;
        }
        String value = this.stringValue();
        if (value != (secondValue = ((IStrategoString)second).stringValue()) && !value.equals(secondValue)) {
            return false;
        }
        IStrategoList annotations = this.getAnnotations();
        if (annotations == (secondAnnotations = second.getAnnotations())) {
            return true;
        }
        if (annotations.match(secondAnnotations)) {
            if (commonStorageType == 2) {
                this.internalSetAnnotations(secondAnnotations);
            }
            return true;
        }
        return false;
    }

    public String stringValue() {
        return this.value;
    }

    public String getName() {
        return this.value;
    }

    @Deprecated
    public void prettyPrint(ITermPrinter pp) {
        pp.print("\"");
        pp.print(this.stringValue().replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r"));
        pp.print("\"");
        this.printAnnotations(pp);
    }

    public void writeAsString(Appendable output, int maxDepth) throws IOException {
        output.append("\"");
        output.append(this.stringValue().replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r"));
        output.append("\"");
        this.appendAnnotations(output, maxDepth);
    }

    public int hashFunction() {
        return this.stringValue().hashCode();
    }
}

