/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms;

import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoPlaceholder;
import org.spoofax.interpreter.terms.IStrategoReal;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.AbstractTermFactory;
import org.spoofax.terms.StrategoAnnotation;
import org.spoofax.terms.StrategoAppl;
import org.spoofax.terms.StrategoInt;
import org.spoofax.terms.StrategoList;
import org.spoofax.terms.StrategoPlaceholder;
import org.spoofax.terms.StrategoReal;
import org.spoofax.terms.StrategoString;
import org.spoofax.terms.StrategoTerm;
import org.spoofax.terms.StrategoTuple;
import org.spoofax.terms.StrategoWrapped;

public class TermFactory
extends AbstractTermFactory
implements ITermFactory {
    private static final int STRING_POOL_STORAGE_TYPE = 2;
    private static final int INT_POOL_STORAGE_TYPE = 3;
    public static final int MAX_POOLED_STRING_LENGTH = 100;
    private static final IStrategoInt[] intCache = TermFactory.initIntCache();
    private IStrategoConstructor placeholderConstructor;
    public static final StrategoList EMPTY_LIST = new StrategoList(null, null, null, 3);
    private static final WeakHashMap<String, WeakReference<StrategoString>> asyncStringPool = new WeakHashMap();

    public TermFactory() {
        super(2);
    }

    public ITermFactory getFactoryWithStorageType(int storageType) {
        if (storageType > 2) {
            throw new UnsupportedOperationException();
        }
        if (storageType == this.defaultStorageType) {
            return this;
        }
        TermFactory result = new TermFactory();
        result.defaultStorageType = storageType;
        return result;
    }

    public IStrategoAppl makeAppl(IStrategoConstructor ctr, IStrategoTerm[] terms, IStrategoList annotations) {
        int storageType = this.defaultStorageType;
        if ((storageType = Math.min(storageType, this.getStorageType(terms))) != 0) {
            storageType = Math.min(storageType, TermFactory.getStorageType(annotations));
        }
        assert (ctr.getArity() == terms.length);
        return new StrategoAppl(ctr, terms, annotations, storageType);
    }

    public IStrategoInt makeInt(int i) {
        if (i >= 0 && i <= 255 && this.isTermSharingAllowed()) {
            return intCache[i];
        }
        return new StrategoInt(i, null, this.defaultStorageType);
    }

    private static final IStrategoInt[] initIntCache() {
        IStrategoInt[] results = new IStrategoInt[256];
        int i = 0;
        while (i < results.length) {
            results[i] = new StrategoInt(i, 3);
            ++i;
        }
        return results;
    }

    public IStrategoList makeList() {
        return this.isTermSharingAllowed() ? EMPTY_LIST : new StrategoList(null, null, null, this.defaultStorageType);
    }

    public IStrategoList makeList(IStrategoTerm[] terms, IStrategoList outerAnnos) {
        IStrategoTerm head;
        int storageType = this.defaultStorageType;
        IStrategoList result = this.makeList();
        int i = terms.length - 1;
        while (i > 0) {
            head = terms[i--];
            storageType = Math.min(storageType, TermFactory.getStorageType(head));
            result = new StrategoList(head, result, null, storageType);
        }
        if (i != 0) {
            if (outerAnnos == null || outerAnnos.isEmpty()) {
                return this.makeList();
            }
            return new StrategoList(null, null, outerAnnos, this.defaultStorageType);
        }
        head = terms[0];
        storageType = Math.min(storageType, TermFactory.getStorageType(head));
        result = new StrategoList(head, result, outerAnnos, storageType);
        return result;
    }

    public IStrategoList makeListCons(IStrategoTerm head, IStrategoList tail, IStrategoList annotations) {
        int storageType = Math.min(this.defaultStorageType, TermFactory.getStorageType(head, tail));
        if (head == null) {
            return this.makeList();
        }
        return new StrategoList(head, tail, annotations, storageType);
    }

    public IStrategoReal makeReal(double d) {
        return new StrategoReal(d, null, this.defaultStorageType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStrategoString makeString(String s) {
        if (s.length() > 100) {
            return new StrategoString(s, null, this.defaultStorageType);
        }
        Class<TermFactory> clazz = TermFactory.class;
        synchronized (TermFactory.class) {
            int type;
            WeakReference<StrategoString> resultRef = asyncStringPool.get(s);
            StrategoString result = resultRef == null ? null : (StrategoString)resultRef.get();
            int n = type = this.isTermSharingAllowed() ? 2 : 0;
            if (result == null) {
                result = new StrategoString(s, null, type);
                asyncStringPool.put(s, new WeakReference<StrategoString>(result));
            } else if (result.getStorageType() == 0 || !this.isTermSharingAllowed()) {
                result = new StrategoString(s, null, type);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStrategoString tryMakeUniqueString(String name) {
        Class<TermFactory> clazz = TermFactory.class;
        synchronized (TermFactory.class) {
            block5: {
                if (!asyncStringPool.containsKey(name)) break block5;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            if (name.length() > 100) {
                throw new UnsupportedOperationException("String too long to be pooled (newname not allowed): " + name);
            }
            StrategoString result = new StrategoString(name, null, this.isTermSharingAllowed() ? 2 : 0);
            asyncStringPool.put(name, new WeakReference<StrategoString>(result));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    public IStrategoTuple makeTuple(IStrategoTerm[] terms, IStrategoList annos) {
        int storageType = Math.min(this.defaultStorageType, this.getStorageType(terms));
        return new StrategoTuple(terms, annos, storageType);
    }

    public IStrategoTerm annotateTerm(IStrategoTerm term, IStrategoList annotations) {
        IStrategoList currentAnnos = term.getAnnotations();
        if (currentAnnos == annotations) {
            return term;
        }
        if (term.getStorageType() == 3) {
            if (term == EMPTY_LIST) {
                if (annotations == EMPTY_LIST || annotations.isEmpty()) {
                    return EMPTY_LIST;
                }
                return new StrategoList(null, null, annotations, this.defaultStorageType);
            }
            if (term.getTermType() == 5) {
                String value = ((IStrategoString)term).stringValue();
                if (annotations == EMPTY_LIST || annotations.isEmpty()) {
                    return this.makeString(value);
                }
                return new StrategoString(value, annotations, this.defaultStorageType);
            }
            if (currentAnnos == EMPTY_LIST) {
                return annotations.isEmpty() ? term : new StrategoAnnotation(this, term, annotations);
            }
            if (term instanceof StrategoAnnotation) {
                term = ((StrategoAnnotation)term).getWrapped();
                return new StrategoAnnotation(this, term, annotations);
            }
            throw new UnsupportedOperationException("Unable to annotate term of type " + term.getClass().getName());
        }
        if ((annotations == EMPTY_LIST || annotations.isEmpty()) && term.getTermType() == 5) {
            return this.makeString(((IStrategoString)term).stringValue());
        }
        if (term instanceof StrategoTerm) {
            StrategoTerm result = ((StrategoTerm)term).clone(true);
            assert (!(result instanceof StrategoWrapped)) : "not yet supported";
            result.internalSetAnnotations(annotations);
            assert (result.getStorageType() != 3);
            return result;
        }
        throw new UnsupportedOperationException("Unable to annotate term of type " + term.getClass().getName() + " in " + this.getClass().getName());
    }

    public IStrategoPlaceholder makePlaceholder(IStrategoTerm template) {
        if (this.placeholderConstructor == null) {
            this.placeholderConstructor = this.makeConstructor("<>", 1);
        }
        return new StrategoPlaceholder(this.placeholderConstructor, template, (IStrategoList)EMPTY_LIST, this.defaultStorageType);
    }
}

