/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms.attachments;

import java.util.Iterator;
import org.spoofax.interpreter.terms.ISimpleTerm;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.SimpleTermVisitor;
import org.spoofax.terms.attachments.AbstractTermAttachment;
import org.spoofax.terms.attachments.TermAttachmentType;
import org.spoofax.terms.attachments.VolatileTermAttachmentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParentAttachment
extends AbstractTermAttachment {
    private static final long serialVersionUID = -159325782499007370L;
    public static TermAttachmentType<ParentAttachment> TYPE = new VolatileTermAttachmentType<ParentAttachment>(ParentAttachment.class);
    private IStrategoTerm parent;
    private IStrategoTerm elementParent;

    private ParentAttachment(IStrategoTerm parent, IStrategoTerm elementParent) {
        this.parent = parent;
        this.elementParent = elementParent;
    }

    public TermAttachmentType<ParentAttachment> getAttachmentType() {
        return TYPE;
    }

    public static ParentAttachment get(IStrategoTerm term) {
        return term.getAttachment(TYPE);
    }

    public IStrategoTerm getParent() {
        if (this.parent == null && this.elementParent != null) {
            IStrategoTerm listAncestor = ParentAttachment.getParent(this.elementParent);
            this.parent = listAncestor == null ? this.elementParent : listAncestor;
        }
        return this.parent;
    }

    public static void putParent(ISimpleTerm term, IStrategoTerm parent, IStrategoTerm elementParent) {
        term.putAttachment(new ParentAttachment(parent, elementParent));
    }

    public static void putParent(ISimpleTerm term, ParentAttachment parent) {
        if (parent != null) {
            term.putAttachment(new ParentAttachment(parent.parent, parent.elementParent));
        }
    }

    public static IStrategoTerm getParent(ISimpleTerm term) {
        if (term == null) {
            return null;
        }
        ParentAttachment attachment = term.getAttachment(TYPE);
        return attachment == null ? null : attachment.getParent();
    }

    public static IStrategoTerm getRoot(IStrategoTerm term) {
        IStrategoTerm parent = ParentAttachment.getParent(term);
        while (parent != null) {
            term = parent;
            parent = ParentAttachment.getParent(term);
        }
        return term;
    }

    public static ISimpleTerm getRoot(ISimpleTerm term) {
        IStrategoTerm parent = ParentAttachment.getParent(term);
        while (parent != null) {
            term = parent;
            parent = ParentAttachment.getParent(term);
        }
        return term;
    }

    public static ISimpleTerm tryTraverseGetParent(ISimpleTerm child, ISimpleTerm root) {
        IStrategoTerm result = ParentAttachment.getParent(child);
        return result != null ? result : ParentAttachment.traverseGetParent(child, root);
    }

    public static ISimpleTerm traverseGetParent(ISimpleTerm child, ISimpleTerm root) {
        return ParentAttachment.traverseGetParent(child, root, null);
    }

    private static ISimpleTerm traverseGetParent(ISimpleTerm child, ISimpleTerm current, ISimpleTerm lastParent) {
        if (current == child) {
            return lastParent;
        }
        Iterator<ISimpleTerm> iterator = SimpleTermVisitor.tryGetListIterator(current);
        int i = 0;
        int max2 = current.getSubtermCount();
        while (i < max2) {
            ISimpleTerm currentChild = iterator == null ? current.getSubterm(i) : iterator.next();
            ISimpleTerm result = ParentAttachment.traverseGetParent(child, currentChild, current);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        return "parent: " + this.getParent();
    }
}

