/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms.attachments;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.StrategoTerm;
import org.spoofax.terms.Term;
import org.spoofax.terms.TermTransformer;
import org.spoofax.terms.attachments.ITermAttachment;
import org.spoofax.terms.attachments.OriginAttachment;
import org.spoofax.terms.attachments.TermAttachmentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TermAttachmentSerializer {
    final ITermFactory factory;

    public TermAttachmentSerializer(ITermFactory factory) {
        this.factory = factory;
    }

    public static void initialize(TermAttachmentType<?> ... types) {
    }

    public IStrategoTerm toAnnotations(IStrategoTerm term) {
        final ITermFactory factory = this.factory;
        return new TermTransformer(factory, false){

            public IStrategoTerm preTransform(IStrategoTerm term) {
                IStrategoList results = null;
                Object attachment = term.getAttachment(null);
                while (attachment != null) {
                    if (attachment.getAttachmentType().isSerializationSupported()) {
                        IStrategoAppl result = attachment.getAttachmentType().toTerm(factory, (ITermAttachment)attachment);
                        if (results == null) {
                            results = term.getAnnotations();
                        }
                        results = result == null ? results : factory.makeListCons(result, results);
                    }
                    attachment = attachment.getNext();
                }
                if (results != null) {
                    term = factory.annotateTerm(term, results);
                }
                return term;
            }
        }.transform(term);
    }

    static IStrategoTerm tryConvertAttachmentTypeToTerm(ITermFactory factory, ITermAttachment attachment) {
        try {
            return attachment.getAttachmentType().toTerm(factory, attachment);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public IStrategoTerm fromAnnotations(IStrategoTerm term, final boolean mutableOperations) {
        final TermAttachmentType[] types = TermAttachmentType.getKnownTypes();
        return new TermTransformer(this.factory, true){

            @Override
            public IStrategoTerm preTransform(IStrategoTerm term) {
                IStrategoTerm origin = OriginAttachment.getOrigin(term);
                term = this.fromAnnotations(term, term);
                if (origin != null) {
                    term = this.fromAnnotations(origin, term);
                }
                return term;
            }

            private IStrategoTerm fromAnnotations(IStrategoTerm source, IStrategoTerm target) {
                boolean isChanged = false;
                IStrategoList annotations = source.getAnnotations();
                while (!annotations.isEmpty()) {
                    IStrategoAppl appl;
                    IStrategoConstructor cons;
                    TermAttachmentType<?> type;
                    IStrategoTerm head = annotations.head();
                    if (Term.isTermAppl(head) && (type = this.getAttachmentType(cons = (appl = (IStrategoAppl)head).getConstructor())) != null) {
                        if (!isChanged) {
                            isChanged = true;
                            target = this.removeAttachAnnotations(target, annotations);
                        }
                        target.putAttachment((ITermAttachment)type.fromTerm(appl));
                    }
                    annotations = annotations.tail();
                }
                return target;
            }

            private TermAttachmentType<?> getAttachmentType(IStrategoConstructor cons) {
                if (cons == null) {
                    return null;
                }
                TermAttachmentType[] termAttachmentTypeArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    TermAttachmentType type = termAttachmentTypeArray[n2];
                    if (type.getTermConstructor() == cons) {
                        return type;
                    }
                    ++n2;
                }
                return null;
            }

            private IStrategoTerm removeAttachAnnotations(IStrategoTerm term, IStrategoList annotations) {
                List<IStrategoTerm> newAnnos = this.getNonAttachAnnotations(annotations);
                if (mutableOperations && term instanceof StrategoTerm) {
                    ((StrategoTerm)term).internalSetAnnotations(TermAttachmentSerializer.this.factory.makeList(newAnnos));
                    return term;
                }
                return TermAttachmentSerializer.this.factory.annotateTerm(term, TermAttachmentSerializer.this.factory.makeList(newAnnos));
            }

            private List<IStrategoTerm> getNonAttachAnnotations(IStrategoList annotations) {
                ArrayList<IStrategoList> newAnnos = null;
                while (!annotations.isEmpty()) {
                    if (this.getAttachmentType(Term.tryGetConstructor(annotations.head())) == null) {
                        if (newAnnos == null) {
                            newAnnos = new ArrayList<IStrategoList>(annotations.size());
                        }
                        newAnnos.add(annotations);
                    }
                    annotations = annotations.tail();
                }
                if (newAnnos == null) {
                    return Collections.emptyList();
                }
                return newAnnos;
            }
        }.transform(term);
    }
}

