/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms.skeleton;

import java.io.IOException;
import java.math.BigInteger;
import org.spoofax.NotImplementedException;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermPrinter;
import org.spoofax.terms.StrategoTerm;
import org.spoofax.terms.TermFactory;

public class SkeletonStrategoInt
extends StrategoTerm
implements IStrategoInt {
    private static final long serialVersionUID = 2915870332171452430L;
    private final BigInteger value;

    public SkeletonStrategoInt(long value, IStrategoList annotations, int storageType) {
        super(annotations, storageType);
        this.value = BigInteger.valueOf(value);
    }

    public SkeletonStrategoInt(int value, int storageType) {
        this(value, null, storageType);
    }

    public int intValue() {
        return this.value.intValue();
    }

    public IStrategoTerm[] getAllSubterms() {
        return TermFactory.EMPTY;
    }

    public IStrategoTerm getSubterm(int index) {
        throw new IndexOutOfBoundsException();
    }

    public int getSubtermCount() {
        return 0;
    }

    public int getTermType() {
        return 3;
    }

    public boolean isUniqueValueTerm() {
        return false;
    }

    protected boolean doSlowMatch(IStrategoTerm second, int commonStorageType) {
        IStrategoList secondAnnotations;
        if (second.getTermType() != 3) {
            return false;
        }
        if (this.intValue() != ((IStrategoInt)second).intValue()) {
            return false;
        }
        IStrategoList annotations = this.getAnnotations();
        if (annotations == (secondAnnotations = second.getAnnotations())) {
            return true;
        }
        if (annotations.match(secondAnnotations)) {
            if (commonStorageType == 2) {
                this.internalSetAnnotations(secondAnnotations);
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public void prettyPrint(ITermPrinter pp) {
        throw new NotImplementedException();
    }

    public void writeAsString(Appendable output, int maxDepth) throws IOException {
        output.append(Integer.toString(this.intValue()));
        this.appendAnnotations(output, maxDepth);
    }

    public int hashFunction() {
        return 449 * this.intValue() ^ 0x1EA1;
    }
}

