/*
 * Decompiled with CFR 0.152.
 */
package org.strategoxt;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.spoofax.IAsyncCancellable;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.Interpreter;
import org.spoofax.interpreter.core.InterpreterErrorExit;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.core.InterpreterExit;
import org.spoofax.interpreter.core.StackTracer;
import org.spoofax.interpreter.core.Tools;
import org.spoofax.interpreter.core.UndefinedStrategyException;
import org.spoofax.interpreter.core.VarScope;
import org.spoofax.interpreter.library.IOperatorRegistry;
import org.spoofax.interpreter.library.ssl.SSLLibrary;
import org.spoofax.interpreter.stratego.SDefT;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.StrategoConstructor;
import org.spoofax.terms.TermFactory;
import org.spoofax.terms.TermTransformer;
import org.spoofax.terms.attachments.AbstractWrappedTermFactory;
import org.strategoxt.IncompatibleJarException;
import org.strategoxt.NoInteropRegistererJarException;
import org.strategoxt.lang.Context;
import org.strategoxt.lang.InteropRegisterer;
import org.strategoxt.lang.InteropSDefT;
import org.strategoxt.lang.MissingStrategyException;
import org.strategoxt.lang.StrategoErrorExit;
import org.strategoxt.lang.StrategoException;
import org.strategoxt.lang.StrategoExit;
import org.strategoxt.stratego_rtg.Main;
import org.strategoxt.strc.desugar_0_0;
import org.strategoxt.strc.desugar_list_matching_0_0;
import org.strategoxt.strc.pre_desugar_0_0;
import org.strategoxt.strc.raise_annotations_0_0;
import org.strategoxt.strc.simplify_0_0;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HybridInterpreter
extends Interpreter
implements IAsyncCancellable {
    protected static final String USAGE = "Uses: run [FILE.ctree | FILE.jar]... MAINCLASS [ARGUMENT]...\n      run                    PACKAGE.MAINCLASS [ARGUMENT]...";
    private final HybridCompiledContext compiledContext;
    private boolean registeredLibraries;
    private boolean loadedJars;
    private final ConstructorRecordingTermFactory recordingFactory;

    public HybridInterpreter() {
        this(new TermFactory());
    }

    public HybridInterpreter(ITermFactory iTermFactory) {
        this(iTermFactory, iTermFactory);
    }

    public HybridInterpreter(ITermFactory iTermFactory, ITermFactory iTermFactory2) {
        super(iTermFactory, iTermFactory2);
        this.compiledContext = new HybridCompiledContext(iTermFactory);
        this.recordingFactory = new ConstructorRecordingTermFactory(iTermFactory);
    }

    public HybridInterpreter(HybridInterpreter hybridInterpreter, String ... stringArray) {
        this(hybridInterpreter.getFactory(), ((org.spoofax.interpreter.core.Context)hybridInterpreter.getContext()).getProgramFactory());
        Set<String> set = HybridInterpreter.asSet(stringArray);
        this.getContext().setVarScope(new VarScope(hybridInterpreter.getContext().getVarScope()));
        hybridInterpreter.init();
        for (IOperatorRegistry iOperatorRegistry : hybridInterpreter.getCompiledContext().getOperatorRegistries()) {
            IOperatorRegistry iOperatorRegistry2 = this.getContext().getOperatorRegistry(iOperatorRegistry.getOperatorRegistryName());
            if (iOperatorRegistry2 != null && !set.contains(iOperatorRegistry.getOperatorRegistryName())) continue;
            this.addOperatorRegistry(iOperatorRegistry);
        }
        this.registeredLibraries = hybridInterpreter.registeredLibraries;
        this.loadedJars = hybridInterpreter.loadedJars;
        this.setIOAgent(hybridInterpreter.getIOAgent());
        this.setCurrent(hybridInterpreter.current());
    }

    public static void main(String ... stringArray) {
        HybridInterpreter hybridInterpreter;
        int n;
        if (stringArray == null || stringArray.length < 1) {
            System.out.println(USAGE);
            System.exit(127);
        }
        boolean bl = (n = HybridInterpreter.mainLoadAll(hybridInterpreter = new HybridInterpreter(), stringArray)) == 0;
        String string = stringArray[n++];
        if (bl) {
            HybridInterpreter.warnUnqualifiedInvoke(hybridInterpreter, string);
        }
        IStrategoTerm[] iStrategoTermArray = new IStrategoString[stringArray.length - n + 1];
        iStrategoTermArray[0] = hybridInterpreter.getFactory().makeString(string);
        int n2 = 1;
        while (n2 < iStrategoTermArray.length) {
            iStrategoTermArray[n2] = hybridInterpreter.getFactory().makeString(stringArray[n]);
            ++n;
            ++n2;
        }
        hybridInterpreter.setCurrent(hybridInterpreter.getFactory().makeList(iStrategoTermArray));
        try {
            hybridInterpreter.invoke(string);
        }
        catch (InterpreterExit interpreterExit) {
            System.exit(interpreterExit.getValue());
        }
        catch (UndefinedStrategyException undefinedStrategyException) {
            System.err.println(undefinedStrategyException.getMessage());
            System.exit(125);
        }
        catch (InterpreterException interpreterException) {
            interpreterException.printStackTrace();
            System.exit(124);
        }
    }

    private static Set<String> asSet(String ... stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                hashSet.add(string);
                ++n2;
            }
        }
        return hashSet;
    }

    protected static void warnUnqualifiedInvoke(HybridInterpreter hybridInterpreter, String string) {
        hybridInterpreter.init();
        SDefT sDefT = hybridInterpreter.lookupUncifiedSVar(string);
        if (sDefT != null) {
            String string2 = ((InteropSDefT)sDefT).getStrategy().getClass().getName();
            System.err.println("Warning: unqualified invocation of " + string2);
        }
    }

    protected static int mainLoadAll(HybridInterpreter hybridInterpreter, String ... stringArray) {
        boolean bl;
        int n = 0;
        while (n < stringArray.length) {
            try {
                if (stringArray[n].endsWith(".ctree")) {
                    hybridInterpreter.load(stringArray[n++]);
                    continue;
                }
                if (!stringArray[n].endsWith(".jar")) break;
                URL[] uRLArray = new URL[]{new File(stringArray[n++]).toURI().toURL()};
                hybridInterpreter.loadJars(uRLArray);
            }
            catch (Exception exception) {
                System.err.println("Could not open input file " + stringArray[n - 1] + ": " + exception.getClass().getSimpleName() + " - " + exception.getMessage());
                System.exit(126);
            }
        }
        boolean bl2 = bl = n == 0;
        if (n == stringArray.length) {
            System.err.println(USAGE);
            System.exit(1);
        } else if (bl && stringArray[n].indexOf(46) > -1) {
            HybridInterpreter.mainLocalJar(stringArray);
        }
        return n;
    }

    private static void mainLocalJar(String ... stringArray) {
        String string = stringArray[0];
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
        try {
            IStrategoTerm iStrategoTerm;
            Context context = new Context();
            try {
                iStrategoTerm = context.invokeStrategyCLI(string, string, stringArray2);
            }
            finally {
                context.getIOAgent().closeAllFiles();
            }
            if (iStrategoTerm == null) {
                System.err.println(String.valueOf(string) + (context.getTraceDepth() != 0 ? ": rewriting failed, trace:" : ": rewriting failed"));
                context.printStackTrace();
                System.exit(1);
            } else {
                System.exit(0);
            }
        }
        catch (MissingStrategyException missingStrategyException) {
            System.err.println(missingStrategyException.getMessage());
            System.exit(125);
        }
        catch (StrategoExit strategoExit) {
            System.exit(strategoExit.getValue());
        }
    }

    @Override
    protected org.spoofax.interpreter.core.Context createContext(ITermFactory iTermFactory, ITermFactory iTermFactory2) {
        return new HybridContext(iTermFactory, iTermFactory2);
    }

    @Override
    public void load(IStrategoTerm iStrategoTerm) throws InterpreterException {
        this.init();
        super.load(iStrategoTerm);
    }

    public void loadJars(URL ... uRLArray) throws SecurityException, NoInteropRegistererJarException, IncompatibleJarException, IOException {
        this.loadJars(HybridInterpreter.class.getClassLoader(), uRLArray);
    }

    public void loadJars(ClassLoader classLoader, URL ... uRLArray) throws SecurityException, NoInteropRegistererJarException, IncompatibleJarException, IOException {
        URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray, classLoader);
        boolean bl = false;
        this.loadedJars = true;
        URL[] uRLArray2 = uRLArray;
        int n = uRLArray.length;
        int n2 = 0;
        while (n2 < n) {
            URL uRL = uRLArray2[n2];
            bl |= this.registerJar(uRLClassLoader, uRL);
            ++n2;
        }
        if (!bl) {
            throw new NoInteropRegistererJarException(uRLArray);
        }
    }

    private boolean registerJar(URLClassLoader uRLClassLoader, URL uRL) throws SecurityException, IncompatibleJarException, IOException {
        URL uRL2 = new URL("jar", "", uRL + "!/");
        JarURLConnection jarURLConnection = (JarURLConnection)uRL2.openConnection();
        jarURLConnection.setUseCaches(false);
        boolean bl = false;
        JarFile jarFile = jarURLConnection.getJarFile();
        try {
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement().getName();
                if (!string.endsWith("/InteropRegisterer.class") && !string.endsWith("$InteropRegisterer.class") && !string.equals("InteropRegisterer.class")) continue;
                int n = ".class".length();
                String string2 = string.substring(0, string.length() - n);
                string2 = string2.replace('/', '.');
                try {
                    Class<?> clazz = uRLClassLoader.loadClass(string2);
                    Object obj = clazz.newInstance();
                    if (obj instanceof InteropRegisterer) {
                        assert (this.recordingFactory.getWrappedFactory() == this.getCompiledContext().getFactory());
                        this.getCompiledContext().setFactory(this.recordingFactory);
                        ((InteropRegisterer)obj).registerLazy(this.getContext(), this.getCompiledContext(), uRLClassLoader);
                        this.getCompiledContext().addConstructors(this.recordingFactory.getAndClearConstructorRecord());
                        this.getCompiledContext().setFactory(this.recordingFactory.getWrappedFactory());
                        bl = true;
                        continue;
                    }
                    throw new IncompatibleJarException(uRL, (Throwable)new ClassCastException("Unknown type for InteropRegisterer"));
                }
                catch (InstantiationException instantiationException) {
                    throw new IncompatibleJarException(uRL, (Throwable)instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IncompatibleJarException(uRL, (Throwable)illegalAccessException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IncompatibleJarException(uRL, (Throwable)classNotFoundException);
                }
                catch (RuntimeException runtimeException) {
                    throw new IncompatibleJarException(uRL, (Throwable)runtimeException);
                }
                catch (Error error) {
                    throw new IncompatibleJarException(uRL, (Throwable)error);
                }
            }
        }
        finally {
            jarFile.close();
        }
        return bl;
    }

    public void init() {
        if (!this.registeredLibraries && !this.loadedJars) {
            this.registeredLibraries = true;
            this.registerLibraries();
        }
    }

    public void uninit() {
        this.loadedJars = false;
        this.getContext().getVarScope().clear();
        SSLLibrary sSLLibrary = SSLLibrary.instance(this.getContext());
        if (sSLLibrary != null) {
            sSLLibrary.getIOAgent().closeAllFiles();
        }
    }

    protected void registerLibraries() {
        IContext iContext = this.getContext();
        Context context = this.getCompiledContext();
        org.strategoxt.tools.Main.registerInterop(iContext, context);
        org.strategoxt.stratego_gpp.Main.registerInterop(iContext, context);
        org.strategoxt.stratego_aterm.Main.registerInterop(iContext, context);
        Main.registerInterop(iContext, context);
        org.strategoxt.stratego_sdf.Main.registerInterop(iContext, context);
        org.strategoxt.stratego_sglr.Main.registerInterop(iContext, context);
        org.strategoxt.stratego_tool_doc.Main.registerInterop(iContext, context);
        org.strategoxt.stratego_xtc.Main.registerInterop(iContext, context);
        org.strategoxt.java_front.Main.registerInterop(iContext, context);
        org.strategoxt.stratego_lib.Main.registerInterop(iContext, context);
        org.strategoxt.strc.Main.registerInterop(iContext, context);
    }

    public final Context getCompiledContext() {
        return this.compiledContext;
    }

    public static Context getCompiledContext(IContext iContext) {
        return ((HybridContext)iContext).getCompiledContext();
    }

    public static IContext getContext(Context context) {
        return context instanceof HybridCompiledContext ? ((HybridCompiledContext)context).getContext() : null;
    }

    public static HybridInterpreter getInterpreter(Context context) {
        return context instanceof HybridCompiledContext ? ((HybridCompiledContext)context).getInterpreter() : null;
    }

    @Override
    public boolean invoke(String string) throws InterpreterErrorExit, InterpreterExit, UndefinedStrategyException, InterpreterException {
        try {
            if (!this.loadedJars) {
                this.init();
            }
            return super.invoke(string);
        }
        catch (StrategoErrorExit strategoErrorExit) {
            throw new InterpreterErrorExit(strategoErrorExit.getMessage(), strategoErrorExit.getTerm(), (Throwable)strategoErrorExit);
        }
        catch (StrategoExit strategoExit) {
            throw new InterpreterExit(strategoExit.getValue(), (Throwable)strategoExit);
        }
        catch (MissingStrategyException missingStrategyException) {
            throw new UndefinedStrategyException(missingStrategyException);
        }
        catch (StrategoException strategoException) {
            throw new InterpreterException(strategoException);
        }
    }

    @Override
    public boolean evaluate(IStrategoAppl iStrategoAppl) throws InterpreterErrorExit, InterpreterExit, UndefinedStrategyException, InterpreterException {
        this.init();
        return super.evaluate(iStrategoAppl);
    }

    public boolean evaluate(IStrategoAppl iStrategoAppl, boolean bl) throws InterpreterErrorExit, InterpreterExit, UndefinedStrategyException, InterpreterException {
        if (bl) {
            this.init();
            iStrategoAppl = this.desugar(iStrategoAppl);
        }
        return this.evaluate(iStrategoAppl);
    }

    private IStrategoAppl desugar(IStrategoAppl iStrategoAppl) {
        final ITermFactory iTermFactory = this.getProgramFactory();
        final IStrategoConstructor iStrategoConstructor = iTermFactory.makeConstructor("CallT", 3);
        final IStrategoConstructor iStrategoConstructor2 = iTermFactory.makeConstructor("SDefT", 4);
        iStrategoAppl = (IStrategoAppl)pre_desugar_0_0.instance.invoke(this.getCompiledContext(), iStrategoAppl);
        iStrategoAppl = (IStrategoAppl)desugar_list_matching_0_0.instance.invoke(this.getCompiledContext(), iStrategoAppl);
        iStrategoAppl = (IStrategoAppl)desugar_0_0.instance.invoke(this.getCompiledContext(), iStrategoAppl);
        iStrategoAppl = (IStrategoAppl)raise_annotations_0_0.instance.invoke(this.getCompiledContext(), iStrategoAppl);
        iStrategoAppl = (IStrategoAppl)simplify_0_0.instance.invoke(this.getCompiledContext(), iStrategoAppl);
        iStrategoAppl = (IStrategoAppl)new TermTransformer(iTermFactory, false){

            public IStrategoTerm preTransform(IStrategoTerm iStrategoTerm) {
                if (Tools.isTermAppl(iStrategoTerm)) {
                    iStrategoTerm = HybridInterpreter.this.cifyAndAddParams(iTermFactory, iStrategoConstructor, iStrategoConstructor2, (IStrategoAppl)iStrategoTerm);
                }
                return iStrategoTerm;
            }
        }.transform(iStrategoAppl);
        return iStrategoAppl;
    }

    private IStrategoTerm cifyAndAddParams(ITermFactory iTermFactory, IStrategoConstructor iStrategoConstructor, IStrategoConstructor iStrategoConstructor2, IStrategoAppl iStrategoAppl) {
        IStrategoConstructor iStrategoConstructor3 = iStrategoAppl.getConstructor();
        if (iStrategoConstructor3 == iStrategoConstructor2 || iStrategoConstructor3 == iStrategoConstructor) {
            Object t = Tools.termAt(iStrategoAppl, 1);
            Object t2 = Tools.termAt(iStrategoAppl, 2);
            if (iStrategoConstructor3 == iStrategoConstructor2) {
                IStrategoString iStrategoString = (IStrategoString)Tools.termAt(iStrategoAppl, 0);
                iStrategoString = iTermFactory.makeString(String.valueOf(HybridInterpreter.cify(Tools.asJavaString(iStrategoString))) + "_" + t.getSubtermCount() + "_" + t2.getSubtermCount());
                iStrategoAppl = iTermFactory.makeAppl(iStrategoConstructor3, new IStrategoTerm[]{iStrategoString, t, t2, Tools.termAt(iStrategoAppl, 3)});
            } else {
                IStrategoAppl iStrategoAppl2 = (IStrategoAppl)Tools.termAt(iStrategoAppl, 0);
                Object object = Tools.termAt(iStrategoAppl2, 0);
                object = iTermFactory.makeString(String.valueOf(HybridInterpreter.cify(Tools.asJavaString(object))) + "_" + t.getSubtermCount() + "_" + t2.getSubtermCount());
                object = iTermFactory.makeAppl(iStrategoAppl2.getConstructor(), new IStrategoTerm[]{object});
                iStrategoAppl = iTermFactory.makeAppl(iStrategoConstructor3, new IStrategoTerm[]{object, t, t2});
            }
        }
        return iStrategoAppl;
    }

    @Override
    public void asyncCancel() {
        this.getCompiledContext().asyncCancel();
        this.getContext().asyncCancel();
    }

    @Override
    public void asyncCancelReset() {
        this.getCompiledContext().asyncCancelReset();
        this.getContext().asyncCancelReset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConstructorRecordingTermFactory
    extends AbstractWrappedTermFactory {
        private final Collection<IStrategoConstructor> constructors = new ArrayList<IStrategoConstructor>();
        private final ITermFactory theBaseFactory;

        public ConstructorRecordingTermFactory(ITermFactory iTermFactory) {
            super(0, iTermFactory);
            this.theBaseFactory = iTermFactory;
        }

        @Override
        public ITermFactory getFactoryWithStorageType(int n) {
            assert (this.getDefaultStorageType() <= n);
            return this;
        }

        @Override
        public StrategoConstructor makeConstructor(String string, int n) {
            StrategoConstructor strategoConstructor = super.makeConstructor(string, n);
            this.constructors.add(strategoConstructor);
            return strategoConstructor;
        }

        public Collection<IStrategoConstructor> getAndClearConstructorRecord() {
            ArrayList<IStrategoConstructor> arrayList = new ArrayList<IStrategoConstructor>(this.constructors);
            this.constructors.clear();
            return arrayList;
        }

        public ITermFactory getWrappedFactory() {
            return this.theBaseFactory;
        }
    }

    private class HybridCompiledContext
    extends Context {
        public HybridCompiledContext(ITermFactory iTermFactory) {
            super(iTermFactory);
        }

        public HybridInterpreter getInterpreter() {
            return HybridInterpreter.this;
        }

        public IContext getContext() {
            return this.getInterpreter().getContext();
        }

        public void addOperatorRegistry(IOperatorRegistry iOperatorRegistry) {
            super.addOperatorRegistry(iOperatorRegistry);
            ((HybridContext)this.getContext()).internalAddOperatorRegistryNoCompiledContext(iOperatorRegistry);
        }

        protected final void internalAddOperatorRegistry(IOperatorRegistry iOperatorRegistry) {
            super.addOperatorRegistry(iOperatorRegistry);
        }

        public IStrategoTerm invokeStrategy(String string, IStrategoTerm iStrategoTerm) throws MissingStrategyException, StrategoErrorExit, StrategoExit, StrategoException {
            IStrategoTerm iStrategoTerm2 = HybridInterpreter.this.current();
            try {
                HybridInterpreter.this.setCurrent(iStrategoTerm);
                HybridInterpreter.this.invoke(string);
                IStrategoTerm iStrategoTerm3 = HybridInterpreter.this.current();
                return iStrategoTerm3;
            }
            catch (InterpreterErrorExit interpreterErrorExit) {
                throw new StrategoErrorExit(interpreterErrorExit.getMessage(), interpreterErrorExit.getTerm(), (Throwable)interpreterErrorExit);
            }
            catch (InterpreterExit interpreterExit) {
                throw new StrategoExit(interpreterExit.getValue(), (Throwable)interpreterExit);
            }
            catch (UndefinedStrategyException undefinedStrategyException) {
                throw new MissingStrategyException(undefinedStrategyException.getMessage(), undefinedStrategyException);
            }
            catch (InterpreterException interpreterException) {
                throw new StrategoException(interpreterException.getMessage(), interpreterException);
            }
            finally {
                HybridInterpreter.this.setCurrent(iStrategoTerm2);
            }
        }

        protected void cancel() {
            this.getContext().asyncCancelReset();
            super.cancel();
        }
    }

    private class HybridContext
    extends org.spoofax.interpreter.core.Context {
        public HybridContext(ITermFactory iTermFactory, ITermFactory iTermFactory2) {
            super(iTermFactory, iTermFactory2, true);
        }

        public void addOperatorRegistry(IOperatorRegistry iOperatorRegistry) {
            super.addOperatorRegistry(iOperatorRegistry);
            HybridInterpreter.this.compiledContext.internalAddOperatorRegistry(iOperatorRegistry);
        }

        private final void internalAddOperatorRegistryNoCompiledContext(IOperatorRegistry iOperatorRegistry) {
            super.addOperatorRegistry(iOperatorRegistry);
        }

        public StackTracer getStackTracer() {
            return HybridInterpreter.this.compiledContext;
        }

        public Context getCompiledContext() {
            return HybridInterpreter.this.compiledContext;
        }

        public void setFactory(ITermFactory iTermFactory) {
            super.setFactory(iTermFactory);
            HybridInterpreter.this.compiledContext.setFactory(iTermFactory);
        }

        protected void cancel() {
            this.getCompiledContext().asyncCancelReset();
            super.cancel();
        }
    }
}

