/*
 * Decompiled with CFR 0.152.
 */
package org.strategoxt.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import org.spoofax.IAsyncCancellable;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.core.InterpreterExit;
import org.spoofax.interpreter.core.StackTracer;
import org.spoofax.interpreter.library.AbstractPrimitive;
import org.spoofax.interpreter.library.IOAgent;
import org.spoofax.interpreter.library.IOperatorRegistry;
import org.spoofax.interpreter.library.java.JFFLibrary;
import org.spoofax.interpreter.library.ssl.SSLLibrary;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.TermFactory;
import org.strategoxt.lang.InteropCallT;
import org.strategoxt.lang.InteropContext;
import org.strategoxt.lang.MissingStrategyException;
import org.strategoxt.lang.StackSaver;
import org.strategoxt.lang.StrategoErrorExit;
import org.strategoxt.lang.StrategoException;
import org.strategoxt.lang.StrategoExit;
import org.strategoxt.lang.Strategy;
import org.strategoxt.lang.Term;
import org.strategoxt.lang.UncaughtExceptionHandler;
import org.strategoxt.lang.compat.CompatManager;
import org.strategoxt.lang.compat.SSL_EXT_java_call;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context
extends StackTracer
implements IAsyncCancellable {
    private final InteropContext interopContext = new InteropContext(this);
    private final Map<String, IOperatorRegistry> operatorRegistryMap;
    private final List<IOperatorRegistry> operatorRegistries;
    private final CompatManager compat = new CompatManager(this);
    private final UncaughtExceptionHandler exceptionHandler = new UncaughtExceptionHandler(this);
    private final UncaughtExceptionHandler.Finalizer exceptionHandlerFinalizer = new UncaughtExceptionHandler.Finalizer(this.exceptionHandler);
    private ITermFactory factory;
    private transient String lastPrimitiveName1;
    private transient String lastPrimitiveName2;
    private transient AbstractPrimitive lastPrimitive1;
    private transient AbstractPrimitive lastPrimitive2;
    private volatile transient boolean asyncCancelled;

    public Context() {
        this(new TermFactory());
    }

    public Context(ITermFactory iTermFactory) {
        this(iTermFactory, null);
    }

    public Context(ITermFactory iTermFactory, IOAgent iOAgent) {
        this.factory = iTermFactory;
        this.operatorRegistryMap = new HashMap<String, IOperatorRegistry>();
        this.operatorRegistries = new ArrayList<IOperatorRegistry>();
        this.addOperatorRegistry(new SSLLibrary());
        this.addOperatorRegistry(new JFFLibrary(iTermFactory));
        if (iOAgent != null) {
            this.setIOAgent(iOAgent);
        }
        this.compat.init();
    }

    protected Context(ITermFactory iTermFactory, Map<String, IOperatorRegistry> map, List<IOperatorRegistry> list, boolean bl) {
        this.factory = iTermFactory;
        this.operatorRegistryMap = map;
        this.operatorRegistries = list;
        if (!bl) {
            this.compat.init();
        }
    }

    public final ITermFactory getFactory() {
        if (this.asyncCancelled) {
            this.cancel();
        }
        return this.factory;
    }

    public void setFactory(ITermFactory iTermFactory) {
        this.factory = iTermFactory;
    }

    public List<IOperatorRegistry> getOperatorRegistries() {
        return this.operatorRegistries;
    }

    public Map<String, IOperatorRegistry> getOperatorRegistryMap() {
        return this.operatorRegistryMap;
    }

    public UncaughtExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public IOAgent getIOAgent() {
        SSLLibrary sSLLibrary = (SSLLibrary)this.getOperatorRegistry("SSL");
        return sSLLibrary == null ? null : sSLLibrary.getIOAgent();
    }

    @Override
    public void setIOAgent(IOAgent iOAgent) {
        SSLLibrary sSLLibrary = (SSLLibrary)this.getOperatorRegistry("SSL");
        if (sSLLibrary == null) {
            throw new IllegalStateException("No SSL library");
        }
        sSLLibrary.setIOAgent(iOAgent);
        super.setIOAgent(iOAgent);
    }

    public void registerClassLoader(ClassLoader classLoader) {
        SSL_EXT_java_call.registerClassLoader(classLoader);
    }

    public final IOperatorRegistry getOperatorRegistry(String string) {
        return this.operatorRegistryMap.get(string);
    }

    public void addOperatorRegistry(IOperatorRegistry iOperatorRegistry) {
        IOperatorRegistry iOperatorRegistry2 = this.operatorRegistryMap.put(iOperatorRegistry.getOperatorRegistryName(), iOperatorRegistry);
        if (iOperatorRegistry2 == null) {
            this.operatorRegistries.add(iOperatorRegistry);
        } else {
            int n = this.operatorRegistries.indexOf(iOperatorRegistry2);
            this.operatorRegistries.remove(iOperatorRegistry2);
            this.operatorRegistries.add(n, iOperatorRegistry);
        }
        this.lastPrimitiveName1 = null;
        this.lastPrimitiveName2 = null;
    }

    public void addConstructors(Collection<IStrategoConstructor> collection) {
        this.interopContext.addConstructors(collection);
    }

    public void registerComponent(String string) {
        this.compat.registerComponent(string);
    }

    public CompatManager getCompatManager() {
        return this.compat;
    }

    public void setStandAlone(boolean bl) {
        this.exceptionHandler.setEnabled(bl);
    }

    public IStrategoTerm invokeStrategyCLI(Strategy strategy, String string, String ... stringArray) throws StrategoExit, StrategoException {
        IStrategoList iStrategoList = this.toCLITerm(string, stringArray);
        if (new Exception().getStackTrace().length > 20) {
            return new StackSaver(strategy).invokeStackFriendly(this, iStrategoList, Term.NO_STRATEGIES, Term.NO_TERMS);
        }
        return strategy.invoke(this, iStrategoList);
    }

    public IStrategoTerm invokeStrategyCLI(String string, String string2, String ... stringArray) throws MissingStrategyException, StrategoErrorExit, StrategoExit, StrategoException {
        return this.invokeStrategy(string, this.toCLITerm(string2, stringArray));
    }

    public IStrategoTerm invokeStrategy(String string, IStrategoTerm iStrategoTerm) throws MissingStrategyException, StrategoErrorExit, StrategoExit, StrategoException {
        SSL_EXT_java_call sSL_EXT_java_call = (SSL_EXT_java_call)this.lookupPrimitive("SSL_EXT_java_call");
        if (sSL_EXT_java_call == null) {
            sSL_EXT_java_call = new SSL_EXT_java_call();
        }
        return sSL_EXT_java_call.call(this, string, iStrategoTerm, false);
    }

    private IStrategoList toCLITerm(String string, String ... stringArray) {
        ITermFactory iTermFactory = this.getFactory();
        IStrategoTerm[] iStrategoTermArray = new IStrategoTerm[stringArray.length + 1];
        iStrategoTermArray[0] = iTermFactory.makeString(string);
        int n = 0;
        while (n < stringArray.length) {
            iStrategoTermArray[n + 1] = iTermFactory.makeString(stringArray[n]);
            ++n;
        }
        IStrategoList iStrategoList = iTermFactory.makeList(iStrategoTermArray);
        return iStrategoList;
    }

    public final IStrategoTerm invokePrimitive(String string, IStrategoTerm iStrategoTerm, Strategy[] strategyArray, IStrategoTerm[] iStrategoTermArray) {
        AbstractPrimitive abstractPrimitive = this.lookupPrimitive(string);
        if (abstractPrimitive == null) {
            throw new StrategoException("Primitive not defined: " + string);
        }
        return this.invokePrimitive(abstractPrimitive, iStrategoTerm, strategyArray, iStrategoTermArray);
    }

    public IStrategoTerm invokePrimitive(AbstractPrimitive abstractPrimitive, IStrategoTerm iStrategoTerm, Strategy[] strategyArray, IStrategoTerm[] iStrategoTermArray) {
        if (abstractPrimitive == null) {
            throw new StrategoException("Calling undefined primitive");
        }
        if (this.asyncCancelled) {
            this.cancel();
        }
        this.interopContext.setCurrent(iStrategoTerm);
        try {
            if (abstractPrimitive.call(this.interopContext, InteropCallT.toInteropCallTs(strategyArray, this), iStrategoTermArray)) {
                IStrategoTerm iStrategoTerm2 = this.interopContext.current();
                this.interopContext.setCurrent(null);
                return iStrategoTerm2;
            }
            return null;
        }
        catch (InterpreterExit interpreterExit) {
            throw new StrategoExit(interpreterExit.getValue());
        }
        catch (InterpreterException interpreterException) {
            throw new StrategoException("Exception in execution of primitive '" + abstractPrimitive.getName() + "'", interpreterException);
        }
        catch (RuntimeException runtimeException) {
            throw new StrategoException("Exception in execution of primitive '" + abstractPrimitive.getName() + "'", runtimeException);
        }
    }

    public AbstractPrimitive lookupPrimitive(String string) {
        if (this.lastPrimitiveName1 == string) {
            return this.lastPrimitive1;
        }
        if (this.lastPrimitiveName2 == string) {
            return this.lastPrimitive2;
        }
        int n = 0;
        int n2 = this.operatorRegistries.size();
        while (n < n2) {
            AbstractPrimitive abstractPrimitive = this.operatorRegistries.get(n).get(string);
            if (abstractPrimitive != null) {
                this.lastPrimitiveName2 = this.lastPrimitiveName1;
                this.lastPrimitive2 = this.lastPrimitive1;
                this.lastPrimitiveName1 = string;
                this.lastPrimitive1 = abstractPrimitive;
                return this.lastPrimitive1;
            }
            ++n;
        }
        return null;
    }

    @Override
    public void asyncCancel() {
        this.asyncCancelled = true;
    }

    @Override
    public void asyncCancelReset() {
        this.asyncCancelled = false;
    }

    protected void cancel() {
        this.asyncCancelled = false;
        this.getIOAgent().closeAllFiles();
        throw new CancellationException("Stratego interpreter cancelled");
    }
}

