/*
 * Decompiled with CFR 0.152.
 */
package org.strategoxt.lang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.LazyTerm;
import org.spoofax.terms.io.binary.TermReader;
import org.strategoxt.lang.StrategoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportTerm
extends LazyTerm {
    private final ITermFactory factory;
    private final String path;
    private final String name;
    private final Class<?> container;
    private ZipFile lastZipFile;

    public ImportTerm(ITermFactory iTermFactory, Class<?> clazz, String string, String string2) {
        assert (string.endsWith("/"));
        this.factory = iTermFactory;
        this.container = clazz;
        this.path = string;
        this.name = string2;
    }

    @Override
    protected IStrategoTerm init() {
        InputStream inputStream = this.openStream();
        try {
            IStrategoTerm iStrategoTerm;
            IStrategoTerm iStrategoTerm2 = iStrategoTerm = new TermReader(this.factory).parseFromStream(inputStream);
            return iStrategoTerm2;
        }
        catch (IOException iOException) {
            throw new StrategoException(String.valueOf(this.container.getSimpleName()) + ": Could not read imported term file " + this.name, iOException);
        }
        catch (RuntimeException runtimeException) {
            throw new StrategoException(String.valueOf(this.container.getSimpleName()) + ": Could not read imported term file " + this.name, runtimeException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (this.lastZipFile != null) {
                    this.lastZipFile.close();
                }
                this.lastZipFile = null;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private InputStream openStream() {
        InputStream inputStream = this.tryOpenStreamFromJar();
        if (inputStream == null) {
            inputStream = this.container.getResourceAsStream(String.valueOf(ImportTerm.removePrecedingSlash(this.path)) + this.name);
        }
        if (inputStream == null) {
            inputStream = this.container.getResourceAsStream(String.valueOf(this.path) + this.name);
        }
        if (inputStream == null) {
            inputStream = this.container.getResourceAsStream("/" + this.name);
        }
        if (inputStream == null) {
            throw new StrategoException(String.valueOf(this.container.getSimpleName()) + ": Could not find imported term file " + this.name);
        }
        return inputStream;
    }

    private InputStream tryOpenStreamFromJar() {
        block5: {
            ZipEntry zipEntry;
            ZipFile zipFile;
            block6: {
                try {
                    URL uRL = this.container.getProtectionDomain().getCodeSource().getLocation();
                    if (!uRL.getFile().endsWith(".jar")) break block5;
                    File file = new File(uRL.toURI());
                    this.lastZipFile = new ZipFile(file);
                    zipFile = this.lastZipFile;
                    zipEntry = zipFile.getEntry(String.valueOf(ImportTerm.removePrecedingSlash(this.path)) + this.name);
                    if (zipEntry == null) {
                        zipEntry = zipFile.getEntry(String.valueOf(this.path) + this.name);
                    }
                    if (zipEntry == null) {
                        zipEntry = zipFile.getEntry(this.name);
                    }
                    if (zipEntry != null) break block6;
                    return null;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            return zipFile.getInputStream(zipEntry);
        }
        return null;
    }

    private static String removePrecedingSlash(String string) {
        return string.startsWith("/") ? string.substring(1) : string;
    }
}

