/*
 * Decompiled with CFR 0.152.
 */
package org.strategoxt.lang;

import java.util.regex.Pattern;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.VarScope;
import org.strategoxt.lang.Context;
import org.strategoxt.lang.InteropRegisterer;
import org.strategoxt.lang.InteropSDefT;
import org.strategoxt.lang.Strategy;

public class JavaInteropRegisterer
extends InteropRegisterer {
    private static final Pattern BINARY_STRATEGY_NAME = Pattern.compile("[A-Za-z_$]+_[0-9]+_[0-9+]");
    private final Strategy[] strategies;

    public JavaInteropRegisterer(Strategy ... strategyArray) {
        if (strategyArray == null) {
            throw new IllegalArgumentException("strategies");
        }
        if (!this.getClass().getSimpleName().equals("InteropRegisterer")) {
            throw new IllegalStateException("Class must be named InteropRegisterer: " + this.getClass().getName());
        }
        this.strategies = strategyArray;
    }

    public void register(IContext iContext, Context context) {
        VarScope varScope = iContext.getVarScope();
        Strategy[] strategyArray = this.strategies;
        int n = this.strategies.length;
        int n2 = 0;
        while (n2 < n) {
            Strategy strategy = strategyArray[n2];
            String string = strategy.getClass().getSimpleName();
            String string2 = strategy.getName();
            if (!BINARY_STRATEGY_NAME.matcher(string).matches()) {
                throw new IllegalArgumentException("Strategy class must encode number of strategy and term arguments in name (e.g. foo_0_0): " + string);
            }
            if (!BINARY_STRATEGY_NAME.matcher(string2).matches()) {
                throw new IllegalArgumentException("Strategy name must encode number of strategy and term arguments in name (e.g. foo_0_0): " + string2);
            }
            varScope.addSVar(string2, new InteropSDefT(strategy, iContext));
            ++n2;
        }
    }

    public void registerLazy(IContext iContext, Context context, ClassLoader classLoader) {
        this.register(iContext, context);
    }
}

