/*
 * Decompiled with CFR 0.152.
 */
package org.strategoxt.lang.parallel.stratego_parallel;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.strategoxt.lang.Context;
import org.strategoxt.lang.Strategy;
import org.strategoxt.lang.parallel.stratego_parallel.ParallelAll;
import org.strategoxt.lang.parallel.stratego_parallel.ParallelContext;
import org.strategoxt.lang.parallel.stratego_parallel.ParallelJobAbortedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelJob
implements Runnable,
Comparable<ParallelJob> {
    public static final int COMPLETED_FOCUS_INDEX = Integer.MAX_VALUE;
    private final Context parentContext;
    private final Strategy strategy;
    private final IStrategoTerm[] inputs;
    private final IStrategoTerm[] outputs;
    private final AtomicInteger focusIndex;
    private final AtomicBoolean isAborted;
    private final AtomicReference<String> lastSynchronousOperation;
    private final AtomicReference<Throwable> lastException;
    private final boolean allowUnordered;
    private final int startIndex;
    private final int jobLength;
    private final int parallelismLevel;
    private boolean isFocusJob;

    public ParallelJob(Context context, Strategy strategy, IStrategoTerm[] iStrategoTermArray, IStrategoTerm[] iStrategoTermArray2, AtomicInteger atomicInteger, AtomicBoolean atomicBoolean, AtomicReference<String> atomicReference, AtomicReference<Throwable> atomicReference2, boolean bl, int n, int n2, int n3) {
        this.parentContext = context;
        this.strategy = strategy;
        this.inputs = iStrategoTermArray;
        this.outputs = iStrategoTermArray2;
        this.focusIndex = atomicInteger;
        this.isAborted = atomicBoolean;
        this.lastSynchronousOperation = atomicReference;
        this.lastException = atomicReference2;
        this.allowUnordered = bl;
        this.startIndex = n;
        this.jobLength = n2;
        this.parallelismLevel = n3;
    }

    @Override
    public final void run() {
        System.out.print('.');
        int n = Math.min(this.inputs.length, this.startIndex + this.jobLength);
        ParallelContext parallelContext = new ParallelContext(this.parentContext, this, this.isAborted, this.allowUnordered);
        int n2 = this.startIndex;
        while (n2 < n) {
            IStrategoTerm iStrategoTerm = this.execute(parallelContext, this.inputs[n2]);
            if (iStrategoTerm == null) break;
            this.outputs[n2] = iStrategoTerm;
            ++n2;
        }
        if (!this.isFocusJob) {
            System.out.print('!');
        }
        this.updateFocusIndex();
    }

    public final AtomicInteger getFocusIndex() {
        return this.focusIndex;
    }

    protected final Object getFocusIndexMonitor() {
        return this.focusIndex;
    }

    public final int getStartIndex() {
        return this.startIndex;
    }

    private void updateFocusIndex() {
        if (this.focusIndex.get() == Integer.MAX_VALUE) {
            return;
        }
        this.focusIndex.set(Integer.MAX_VALUE);
        System.out.print(">");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStrategoTerm execute(ParallelContext parallelContext, IStrategoTerm iStrategoTerm) {
        if (this.isAborted.get()) {
            return null;
        }
        IStrategoTerm iStrategoTerm2 = null;
        try {
            iStrategoTerm2 = this.strategy.invoke(parallelContext, iStrategoTerm);
        }
        catch (ParallelJobAbortedException parallelJobAbortedException) {
        }
        catch (RuntimeException runtimeException) {
            this.lastException.set(runtimeException);
        }
        catch (Error error) {
            this.lastException.set(error);
        }
        if (iStrategoTerm2 == null) {
            this.isAborted.set(true);
            this.getFocusIndex().set(Integer.MAX_VALUE);
            ParallelAll.instance.getExecutor().getQueue().clear();
            System.out.print("@>");
            Object object = this.getFocusIndexMonitor();
            synchronized (object) {
                this.getFocusIndexMonitor().notifyAll();
            }
        }
        return iStrategoTerm2;
    }

    public boolean isFocusJob() {
        return this.isFocusJob || this.focusIndex.get() == this.startIndex;
    }

    public void waitForFocus() throws InterruptedException {
        if (!this.isFocusJob) {
            this.waitForFocusIndexAndComplain();
            this.isFocusJob = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForFocusIndexAndComplain() throws InterruptedException {
        System.out.print("$?");
        if (this.focusIndex.get() < this.startIndex) {
            Object object;
            Object object2 = object = this.getFocusIndexMonitor();
            synchronized (object2) {
                this.updateFocusIndex();
                while (this.focusIndex.get() < this.startIndex) {
                    System.out.print('$');
                    object.wait();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForCompletedFocusIndex() throws InterruptedException {
        Object object;
        int n = 1000;
        int n2 = 0;
        while (n2 < n) {
            if (this.focusIndex.get() == Integer.MAX_VALUE) {
                return;
            }
            ++n2;
        }
        System.out.print("$??");
        Object object2 = object = this.getFocusIndexMonitor();
        synchronized (object2) {
            while (this.focusIndex.get() != Integer.MAX_VALUE) {
                object.wait();
            }
        }
    }

    @Override
    public int compareTo(ParallelJob parallelJob) {
        if (this.parallelismLevel > parallelJob.parallelismLevel) {
            return -1;
        }
        if (this.parallelismLevel == parallelJob.parallelismLevel) {
            return this.startIndex < parallelJob.startIndex ? -1 : (this.startIndex == parallelJob.startIndex ? 0 : 1);
        }
        return 1;
    }
}

