/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend;

import org.kframework.backend.Backend;
import org.kframework.compile.FlattenModules;
import org.kframework.compile.ResolveConfigurationAbstraction;
import org.kframework.compile.checks.CheckConfigurationCells;
import org.kframework.compile.checks.CheckRewrite;
import org.kframework.compile.checks.CheckVariables;
import org.kframework.compile.sharing.DeclareCellLabels;
import org.kframework.compile.tags.AddDefaultComputational;
import org.kframework.compile.tags.AddOptionalTags;
import org.kframework.compile.tags.AddStrictStar;
import org.kframework.compile.transformers.AddEmptyLists;
import org.kframework.compile.transformers.AddHeatingConditions;
import org.kframework.compile.transformers.AddK2SMTLib;
import org.kframework.compile.transformers.AddKCell;
import org.kframework.compile.transformers.AddKLabelConstant;
import org.kframework.compile.transformers.AddKStringConversion;
import org.kframework.compile.transformers.AddPredicates;
import org.kframework.compile.transformers.AddSemanticEquality;
import org.kframework.compile.transformers.AddStreamCells;
import org.kframework.compile.transformers.AddSupercoolDefinition;
import org.kframework.compile.transformers.AddSuperheatRules;
import org.kframework.compile.transformers.AddSymbolicK;
import org.kframework.compile.transformers.AddTopCellConfig;
import org.kframework.compile.transformers.AddTopCellRules;
import org.kframework.compile.transformers.ContextsToHeating;
import org.kframework.compile.transformers.DesugarStreams;
import org.kframework.compile.transformers.FlattenSyntax;
import org.kframework.compile.transformers.FreezeUserFreezers;
import org.kframework.compile.transformers.FreshCondToFreshVar;
import org.kframework.compile.transformers.RemoveBrackets;
import org.kframework.compile.transformers.RemoveSyntacticCasts;
import org.kframework.compile.transformers.ResolveAnonymousVariables;
import org.kframework.compile.transformers.ResolveBinder;
import org.kframework.compile.transformers.ResolveBlockingInput;
import org.kframework.compile.transformers.ResolveBuiltins;
import org.kframework.compile.transformers.ResolveFreshVarMOS;
import org.kframework.compile.transformers.ResolveFunctions;
import org.kframework.compile.transformers.ResolveHybrid;
import org.kframework.compile.transformers.ResolveListOfK;
import org.kframework.compile.transformers.ResolveOpenCells;
import org.kframework.compile.transformers.ResolveRewrite;
import org.kframework.compile.transformers.ResolveSupercool;
import org.kframework.compile.transformers.ResolveSyntaxPredicates;
import org.kframework.compile.transformers.StrictnessToContexts;
import org.kframework.compile.utils.CheckVisitorStep;
import org.kframework.compile.utils.CompileDataStructures;
import org.kframework.compile.utils.CompilerSteps;
import org.kframework.compile.utils.InitializeConfigurationStructure;
import org.kframework.kil.Definition;
import org.kframework.kil.loader.Context;
import org.kframework.main.FirstStep;
import org.kframework.main.LastStep;
import org.kframework.utils.Stopwatch;
import org.kframework.utils.general.GlobalSettings;

public abstract class BasicBackend
implements Backend {
    protected Stopwatch sw;
    protected Context context;

    public BasicBackend(Stopwatch sw, Context context) {
        this.sw = sw;
        this.context = context;
    }

    @Override
    public Definition lastStep(Definition def) {
        return def;
    }

    @Override
    public Definition firstStep(Definition def) {
        return def;
    }

    @Override
    public boolean autoinclude() {
        return !GlobalSettings.noPrelude;
    }

    @Override
    public CompilerSteps<Definition> getCompilationSteps() {
        CompilerSteps<Definition> steps = new CompilerSteps<Definition>(this.context);
        steps.add(new FirstStep(this, this.context));
        steps.add(new CheckVisitorStep(new CheckConfigurationCells(this.context), this.context));
        steps.add(new RemoveBrackets(this.context));
        steps.add(new AddEmptyLists(this.context));
        steps.add(new RemoveSyntacticCasts(this.context));
        steps.add(new CheckVisitorStep(new CheckVariables(this.context), this.context));
        steps.add(new CheckVisitorStep(new CheckRewrite(this.context), this.context));
        steps.add(new FlattenModules(this.context));
        steps.add(new StrictnessToContexts(this.context));
        steps.add(new FreezeUserFreezers(this.context));
        steps.add(new ContextsToHeating(this.context));
        steps.add(new AddSupercoolDefinition(this.context));
        steps.add(new AddHeatingConditions(this.context));
        steps.add(new AddSuperheatRules(this.context));
        steps.add(new DesugarStreams(this.context, false));
        steps.add(new ResolveFunctions(this.context));
        steps.add(new AddKCell(this.context));
        steps.add(new AddStreamCells(this.context));
        steps.add(new AddSymbolicK(this.context));
        steps.add(new AddSemanticEquality(this.context));
        steps.add(new FreshCondToFreshVar(this.context));
        steps.add(new ResolveFreshVarMOS(this.context));
        steps.add(new AddTopCellConfig(this.context));
        if (GlobalSettings.addTopCell) {
            steps.add(new AddTopCellRules(this.context));
        }
        steps.add(new ResolveBinder(this.context));
        steps.add(new ResolveAnonymousVariables(this.context));
        steps.add(new ResolveBlockingInput(this.context, false));
        steps.add(new AddK2SMTLib(this.context));
        steps.add(new AddPredicates(this.context));
        steps.add(new ResolveSyntaxPredicates(this.context));
        steps.add(new ResolveBuiltins(this.context));
        steps.add(new ResolveListOfK(this.context));
        steps.add(new FlattenSyntax(this.context));
        steps.add(new InitializeConfigurationStructure(this.context));
        steps.add(new AddKStringConversion(this.context));
        steps.add(new AddKLabelConstant(this.context));
        steps.add(new ResolveHybrid(this.context));
        steps.add(new ResolveConfigurationAbstraction(this.context));
        steps.add(new ResolveOpenCells(this.context));
        steps.add(new ResolveRewrite(this.context));
        steps.add(new CompileDataStructures(this.context));
        steps.add(new ResolveSupercool(this.context));
        steps.add(new AddStrictStar(this.context));
        steps.add(new AddDefaultComputational(this.context));
        steps.add(new AddOptionalTags(this.context));
        steps.add(new DeclareCellLabels(this.context));
        steps.add(new LastStep(this, this.context));
        return steps;
    }
}

