/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.html;

import java.awt.Color;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kframework.backend.BackendFilter;
import org.kframework.backend.html.HTMLPatternsVisitor;
import org.kframework.kil.Attribute;
import org.kframework.kil.Attributes;
import org.kframework.kil.Bracket;
import org.kframework.kil.Cell;
import org.kframework.kil.Collection;
import org.kframework.kil.Configuration;
import org.kframework.kil.Definition;
import org.kframework.kil.Hole;
import org.kframework.kil.KApp;
import org.kframework.kil.KList;
import org.kframework.kil.KSequence;
import org.kframework.kil.ListTerminator;
import org.kframework.kil.LiterateComment;
import org.kframework.kil.LiterateDefinitionComment;
import org.kframework.kil.LiterateModuleComment;
import org.kframework.kil.MapItem;
import org.kframework.kil.Module;
import org.kframework.kil.Production;
import org.kframework.kil.ProductionItem;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Rule;
import org.kframework.kil.Sort;
import org.kframework.kil.Syntax;
import org.kframework.kil.Term;
import org.kframework.kil.TermComment;
import org.kframework.kil.TermCons;
import org.kframework.kil.Terminal;
import org.kframework.kil.Token;
import org.kframework.kil.UserList;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.utils.file.FileUtil;
import org.kframework.utils.general.GlobalSettings;

public class HTMLFilter
extends BackendFilter {
    String endl = System.getProperty("line.separator");
    private String cssFile = GlobalSettings.style;
    private String css = "";
    private String preamble = "";
    private String title = "";
    private String author = "";
    private String organization = "";
    private HashSet<String> usedColors = new HashSet();
    private Map<String, String> cellColors = new HashMap<String, String>();
    private Map<String, Color> HTMLColors = new HashMap<String, Color>();
    private HTMLPatternsVisitor patternsVisitor = new HTMLPatternsVisitor(this.context);
    private boolean firstAttribute;
    private boolean firstProduction = false;
    private Properties Latex2HTMLzero = new Properties();
    private Properties Latex2HTMLone = new Properties();
    private String includePath = new String();

    public HTMLFilter(String includePath, Context context) {
        super(context);
        this.includePath = includePath;
        this.createHTMLColors();
        this.loadProperties();
    }

    public String getHTML() {
        String preamble = this.parsePreamble();
        String html = "<!DOCTYPE html>" + this.endl + "<html lang=\"en\">" + this.endl + "<head>" + this.endl + "    <title>" + this.title + "</title>" + this.endl + "    <link rel=\"stylesheet\" type=\"text/css\" href=\"" + this.cssFile + "\">" + this.endl + "   <style>" + this.endl + this.css + this.endl + "   </style>" + "    <meta charset=\"utf-8\" />" + this.endl + "<script type=\"text/javascript\" " + this.endl + "src=\"http://cdn.mathjax.org/mathjax/latest/MathJax.js?config=TeX-AMS-MML_HTMLorMML\">" + this.endl + "</script>" + this.endl + "</head>" + this.endl + "<body>" + this.endl;
        html = html + preamble + this.result + "</body>" + this.endl + "</html>" + this.endl;
        return html;
    }

    public void setResult(String result) {
        this.result = new StringBuilder(result);
    }

    public void setPreamble(String preamble) {
        this.preamble = preamble;
    }

    public String getPreamble() {
        return this.preamble;
    }

    @Override
    public void visit(Definition def) {
        def.accept(this.patternsVisitor);
        this.title = def.getMainModule();
        super.visit(def);
    }

    @Override
    public void visit(Module mod) {
        if (mod.isPredefined()) {
            return;
        }
        this.result.append("<div>MODULE <span class=\"large\">" + mod.getName() + "</span> <br /> <br />" + this.endl);
        super.visit(mod);
        this.result.append("END MODULE </div>" + this.endl + "<br />" + this.endl);
    }

    @Override
    public void visit(Syntax syn) {
        this.result.append("<table> <tr> <td> SYNTAX ");
        this.firstProduction = true;
        super.visit(syn);
        this.result.append("</table>" + this.endl + "<br />" + this.endl);
    }

    @Override
    public void visit(Sort sort) {
        this.result.append("<span class =\"italic\"> " + this.makeGreek(sort.getName()) + " </span>");
    }

    @Override
    public void visit(Production p) {
        if (this.firstProduction) {
            this.result.append("</td><td> ::= </td> <td>");
            this.firstProduction = false;
        } else {
            this.result.append("<tr> <td> </td> <td class = \"textCentered\"> |  </td> <td>");
        }
        if (!(p.getItems().get(0) instanceof UserList) && p.containsAttribute("cons") && this.patternsVisitor.getPatterns().containsKey(p.getAttribute("cons")) && this.patternsVisitor.getPatternType(p.getAttribute("cons")) != HTMLPatternsVisitor.HTMLPatternType.DEFAULT) {
            String pattern = this.patternsVisitor.getPatterns().get(p.getAttribute("cons"));
            boolean isLatex = this.patternsVisitor.getPatternType(p.getAttribute("cons")) == HTMLPatternsVisitor.HTMLPatternType.LATEX;
            int n = 1;
            HTMLFilter termFilter = new HTMLFilter(this.includePath, this.context);
            for (ProductionItem pi : p.getItems()) {
                if (pi instanceof Terminal) continue;
                termFilter.setResult("");
                pi.accept(termFilter);
                pattern = pattern.replace("{#" + n++ + "}", isLatex ? "\\)" + termFilter.getResult() + "\\(" : termFilter.getResult());
            }
            this.result.append(isLatex ? "\\(" + pattern + "\\)" : pattern);
        } else {
            super.visit(p);
        }
        p.getAttributes().accept(this);
        this.result.append("</td> </tr>" + this.endl);
    }

    @Override
    public void visit(Terminal pi) {
        this.result.append(this.makeGreek(this.htmlify(pi.getTerminal())) + " ");
    }

    @Override
    public void visit(UserList ul) {
        this.result.append("<span class =\"italic\">List</span>{#<span class =\"italic\">" + ul.getSort() + "</span>,\"" + ul.getSeparator() + "\"} </span>" + this.endl);
    }

    @Override
    public void visit(Configuration conf) {
        this.result.append("<div> CONFIGURATION : <br />");
        super.visit(conf);
        this.result.append("</div> <br />");
    }

    @Override
    public void visit(Cell c) {
        String cellName;
        String color;
        String blockClasses = "block";
        String tabClasses = "tab";
        Cell.Ellipses ellipses = c.getEllipses();
        if (ellipses == Cell.Ellipses.LEFT) {
            blockClasses = blockClasses + " left";
            tabClasses = tabClasses + " straightEdge";
        } else if (ellipses == Cell.Ellipses.RIGHT) {
            blockClasses = blockClasses + " right";
            tabClasses = tabClasses + " curvedEdge";
        } else if (ellipses == Cell.Ellipses.BOTH) {
            blockClasses = blockClasses + " left right";
            tabClasses = tabClasses + " straightEdge";
        } else {
            tabClasses = tabClasses + " curvedEdge";
        }
        if (c.getCellAttributes().containsKey("color") && this.HTMLColors.containsKey(c.getCellAttributes().get("color").toLowerCase())) {
            this.cellColors.put(c.getLabel(), c.getCellAttributes().get("color").toLowerCase());
        }
        if (this.usedColors.add(color = this.getCellColor(cellName = this.makeGreek(this.htmlify(c.getLabel()))))) {
            this.addToCss(color);
        }
        this.result.append("<div class=\"cell\"> <div class=\"" + tabClasses + " " + color + "\">");
        this.result.append("<span class = \"bold\">" + cellName + "</span> </div>");
        this.result.append("<br />");
        this.result.append("<div class=\"" + blockClasses + " " + color + "\" ");
        if (cellName.length() > 5) {
            double mw = Math.floor((double)cellName.length() * 0.7 * 10.0 + 0.5) / 10.0;
            this.result.append("style=\"min-width:" + mw + "em\"");
        }
        this.result.append("> <div class=\"center\">");
        super.visit(c);
        this.result.append("</div> </div> </div>" + this.endl);
    }

    @Override
    public void visit(Collection col) {
        if (col.isEmpty()) {
            this.printEmpty(col.getSort());
            return;
        }
        List<Term> contents = col.getContents();
        this.printList(contents, "");
    }

    private void printEmpty(String sort) {
        this.result.append("&bull;");
    }

    private void printList(List<Term> contents, String str) {
        boolean first = true;
        for (Term trm : contents) {
            if (first) {
                first = false;
            } else {
                this.result.append(str);
            }
            trm.accept(this);
        }
    }

    @Override
    public void visit(TermComment tc) {
        this.result.append("<br />");
        super.visit(tc);
    }

    @Override
    public void visit(Variable var) {
        this.result.append("<span ");
        if (var.getSort() != null) {
            this.result.append("title =\"" + var.getSort() + "\"");
        }
        this.result.append(">" + this.makeGreek(var.getName()));
        this.result.append(" </span> ");
    }

    @Override
    public void visit(ListTerminator e) {
        this.result.append(" <span title=\"" + e.getSort() + "\" class = \"bold\"> &nbsp;&nbsp;&middot;&nbsp;&nbsp;</span> ");
    }

    @Override
    public void visit(Rule rule) {
        this.result.append("<div> <span ");
        if (!"".equals(rule.getLabel())) {
            this.result.append("title =\"Rule Label: " + rule.getLabel() + "\"");
        }
        this.result.append("> RULE </span>");
        this.result.append("<div class=\"cell\"> ");
        rule.getBody().accept(this);
        this.result.append("</div> ");
        if (rule.getRequires() != null) {
            this.result.append(" when ");
            rule.getRequires().accept(this);
        }
        if (rule.getEnsures() != null) {
            this.result.append(" ensures ");
            rule.getEnsures().accept(this);
        }
        rule.getAttributes().accept(this);
        this.result.append("</div> <br />" + this.endl);
    }

    @Override
    public void visit(org.kframework.kil.Context cxt) {
        this.result.append("<div> CONTEXT ");
        cxt.getBody().accept(this);
        if (cxt.getRequires() != null) {
            this.result.append(" when ");
            cxt.getRequires().accept(this);
        }
        if (cxt.getEnsures() != null) {
            this.result.append(" ensures ");
            cxt.getEnsures().accept(this);
        }
        cxt.getAttributes().accept(this);
        this.result.append("</div> <br />" + this.endl);
    }

    @Override
    public void visit(Hole hole) {
        this.result.append("&#9633;");
    }

    @Override
    public void visit(Rewrite rew) {
        this.result.append("<table class=\"rewrite\"> <tr class='rewriteLeft'> <td> <em>");
        rew.getLeft().accept(this);
        this.result.append("</em></td></tr> <tr class='rewriteRight'> <td><em>");
        rew.getRight().accept(this);
        this.result.append("</em> </td> </tr> </table>");
    }

    @Override
    public void visit(Bracket trm) {
        if (trm.getContent() instanceof Rewrite) {
            super.visit(trm);
        } else {
            String pattern = this.getBracketPattern(trm);
            HTMLFilter termFilter = new HTMLFilter(this.includePath, this.context);
            trm.getContent().accept(termFilter);
            pattern = pattern.replace("{#1}", "<span>" + termFilter.getResult() + "</span>");
            this.result.append(pattern);
        }
    }

    private String getBracketPattern(Bracket trm) {
        return "({#1})";
    }

    @Override
    public void visit(TermCons trm) {
        HTMLPatternsVisitor.HTMLPatternType type = this.patternsVisitor.getPatternType(trm.getCons());
        if (type == null) {
            Production pr = (Production)this.context.conses.get(trm.getCons());
            pr.accept(this.patternsVisitor);
            type = this.patternsVisitor.getPatternType(trm.getCons());
        }
        if (type != HTMLPatternsVisitor.HTMLPatternType.DEFAULT) {
            String pattern = this.patternsVisitor.getPatterns().get(trm.getCons());
            int n = 1;
            HTMLFilter termFilter = new HTMLFilter(this.includePath, this.context);
            for (Term t : trm.getContents()) {
                termFilter.setResult("");
                t.accept(termFilter);
                if (type == HTMLPatternsVisitor.HTMLPatternType.LATEX) {
                    pattern = pattern.replace("{#" + n++ + "}", "\\) " + termFilter.getResult() + "\\(");
                    continue;
                }
                pattern = pattern.replace("{#" + n++ + "}", termFilter.getResult());
            }
            if (type == HTMLPatternsVisitor.HTMLPatternType.LATEX) {
                this.result.append("\\(" + pattern + "\\)");
            } else {
                this.result.append(pattern);
            }
        } else {
            boolean empty = true;
            Production pr = trm.getProduction();
            if (pr.getItems().size() > 0) {
                if (pr.getItems().get(0) instanceof UserList) {
                    String separator = ((UserList)pr.getItems().get(0)).getSeparator();
                    trm.getContents().get(0).accept(this);
                    this.result.append(" " + separator + " ");
                    trm.getContents().get(1).accept(this);
                    this.result.append(" ");
                    empty = false;
                } else {
                    int j = 0;
                    for (int i = 0; i < pr.getItems().size(); ++i) {
                        ProductionItem pi = pr.getItems().get(i);
                        if (pi instanceof Terminal) {
                            pi.accept(this);
                            empty = false;
                            continue;
                        }
                        if (!(pi instanceof Sort)) continue;
                        Term t = trm.getContents().get(j++);
                        t.accept(this);
                        empty = false;
                    }
                }
            }
            if (empty) {
                this.result.append("&nbsp; &nbsp; &middot; &nbsp; &nbsp;");
            }
        }
    }

    @Override
    public void visit(MapItem mi) {
        mi.getKey().accept(this);
        this.result.append("<span text-size=\"large\"> &#x21a6; </span>");
        mi.getItem().accept(this);
    }

    @Override
    public void visit(KSequence k) {
        if (k.isEmpty()) {
            this.printEmpty("K");
            return;
        }
        this.printList(k.getContents(), "&#x219d; ");
    }

    @Override
    public void visit(KApp app) {
        if (app.getLabel() instanceof Token) {
            this.result.append("<span title =\"" + ((Token)app.getLabel()).tokenSort() + "\"> " + this.makeGreek(((Token)app.getLabel()).value()) + " </span> ");
        } else {
            app.getLabel().accept(this);
            this.result.append("(");
            app.getChild().accept(this);
            this.result.append(")");
        }
    }

    @Override
    public void visit(KList list) {
        this.printList(list.getContents(), "<span class=\"bold\">, </span>");
    }

    @Override
    public void visit(LiterateDefinitionComment comment) {
        if (comment.getType() == LiterateComment.LiterateCommentType.LATEX) {
            this.result.append("<div class=\"commentBlock definitionComment tex2jax_ignore\">" + this.endl);
            this.result.append(this.parseComment(comment.getValue()));
            this.result.append("</div><div><br /></div>" + this.endl);
        } else if (comment.getType() == LiterateComment.LiterateCommentType.PREAMBLE) {
            this.preamble = this.preamble + comment.getValue();
        }
    }

    @Override
    public void visit(LiterateModuleComment comment) {
        if (comment.getType() == LiterateComment.LiterateCommentType.LATEX) {
            this.result.append("<div class=\"commentBlock moduleComment tex2jax_ignore\">" + this.endl);
            this.result.append(this.parseComment(comment.getValue()));
            this.result.append("</div><div><br /></div>" + this.endl);
        } else if (comment.getType() == LiterateComment.LiterateCommentType.PREAMBLE) {
            this.preamble = this.preamble + comment.getValue();
        }
    }

    @Override
    public void visit(Attributes attributes) {
        this.firstAttribute = true;
        for (Attribute entry : attributes.getContents()) {
            entry.accept(this);
        }
        if (!this.firstAttribute) {
            this.result.append("</span> ]");
        }
    }

    @Override
    public void visit(Attribute entry) {
        if ("generated".equals(entry.getLocation())) {
            return;
        }
        if (this.context.isTagGenerated(entry.getKey())) {
            return;
        }
        if (this.context.isParsingTag(entry.getKey())) {
            return;
        }
        if (entry.getKey().equals("latex")) {
            return;
        }
        if (entry.getKey().equals("html")) {
            return;
        }
        if (this.firstAttribute) {
            this.result.append(" [ <span class =\"attribute\"> ");
            this.firstAttribute = false;
        } else {
            this.result.append(", ");
        }
        this.result.append(this.makeGreek(entry.getKey()));
        String value = this.makeGreek(entry.getValue());
        if (!value.isEmpty()) {
            this.result.append("(" + value + ")");
        }
    }

    private String makeGreek(String name) {
        return name.replace("Alpha", "&alpha;").replace("Beta", "&beta;").replace("Gamma", "&gamma;").replace("Delta", "&delta;").replace("VarEpsilon", "&vepsilon;").replace("Epsilon", "&epsilon;").replace("Zeta", "&zeta;").replace("Eta", "&eta;").replace("Theta", "&theta;").replace("Kappa", "&kappa;").replace("Lambda", "&lambda;").replace("Mu", "&mu;").replace("Nu", "&nu;").replace("Xi", "&xi;").replace("Pi", "&pi;").replace("VarRho", "&varrho;").replace("Rho", "&rho;").replace("VarSigma", "&vsigma;").replace("Sigma", "&sigma;").replace("GAMMA", "&Gamma;").replace("DELTA", "&Delta;").replace("THETA", "&Theta;").replace("LAMBDA", "&Lambda;").replace("XI", "&Xi;").replace("PI", "&Pi;").replace("SIGMA", "&Sigma;").replace("UPSILON", "&Upsilon;").replace("PHI", "&Phi;");
    }

    private String htmlify(String name) {
        return name.replace("<", "&lt;");
    }

    private String HTMLColorToString(Color a) {
        return "#" + this.toHex(a.getRed()) + this.toHex(a.getGreen()) + this.toHex(a.getBlue());
    }

    private String toHex(int c) {
        if (0 <= c && c <= 15) {
            return "0" + Integer.toHexString(c);
        }
        if (16 <= c && c <= 255) {
            return Integer.toHexString(c);
        }
        return "ERROR in String toHex(int c), c = " + c;
    }

    private String parseComment(String comment) {
        String key;
        Enumeration<Object> e = this.Latex2HTMLone.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            if (key == null) continue;
            Vector<Integer> startIndexs = this.findStartIndexs(key);
            int numberOfIndexs = startIndexs.size();
            Vector<Vector<String>> contents = this.multipleLatexExtracts(comment, this.regexify(key), startIndexs);
            for (Vector<String> c : contents) {
                String copyKey = key;
                String property = this.Latex2HTMLone.getProperty(key);
                for (int i = 1; i < numberOfIndexs + 1; ++i) {
                    copyKey = copyKey.replace("#" + i, c.get(i - 1));
                    property = property.replace("#" + i, c.get(i - 1));
                }
                comment = comment.replace(copyKey, property);
            }
        }
        e = this.Latex2HTMLzero.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            if (key == null) continue;
            comment = comment.replace(key, this.Latex2HTMLzero.getProperty(key));
        }
        return comment;
    }

    private Vector<Vector<String>> multipleLatexExtracts(String from, String regex, Vector<Integer> startIndexs) {
        Vector<Vector<String>> results = new Vector<Vector<String>>();
        Pattern p = Pattern.compile(regex, 32);
        Matcher m = p.matcher(from);
        while (m.find()) {
            int offset = 0;
            if (m.group().isEmpty()) continue;
            Vector<String> contents = new Vector<String>();
            for (int start : startIndexs) {
                int a;
                int i;
                int braceCount = 1;
                for (i = a = m.start() + start + offset; braceCount > 0 && i < from.length(); ++i) {
                    if (from.charAt(i) == '{') {
                        ++braceCount;
                        continue;
                    }
                    if (from.charAt(i) != '}') continue;
                    --braceCount;
                }
                contents.add(from.substring(a, i - 1));
                offset += from.substring(a, i - 1).length() - 2;
            }
            results.add(contents);
        }
        return results;
    }

    private Vector<Integer> findStartIndexs(String from) {
        Vector<Integer> result = new Vector<Integer>();
        int i = 1;
        while (from.contains("#" + i)) {
            result.add(from.indexOf("#" + i));
            ++i;
        }
        return result;
    }

    private String regexify(String regex) {
        String a = regex;
        int i = 1;
        while (a.contains("#" + i)) {
            a = a.replace("#" + i, ".*?");
            ++i;
        }
        return a.replace("\\", "\\\\").replace("{", "\\{").replace("}", "\\}");
    }

    private Color alter(Color a) {
        float[] hsb = Color.RGBtoHSB(a.getRed(), a.getGreen(), a.getBlue(), null);
        hsb[1] = hsb[1] / 4.0f;
        hsb[2] = 0.9411765f;
        return new Color(Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]));
    }

    private void loadProperties() {
        try {
            FileUtil.loadProperties(this.Latex2HTMLzero, this.includePath + "Latex2HTMLzero.properties");
        }
        catch (IOException e) {
            System.out.println("error loading " + this.includePath + "Latex2HTMLzero.properties");
        }
        try {
            FileUtil.loadProperties(this.Latex2HTMLone, this.includePath + "Latex2HTMLone.properties");
        }
        catch (IOException e) {
            System.out.println("error loading Latex2HTMLone.properties");
        }
    }

    private void addToCss(String color) {
        this.css = this.css + "." + color + this.endl + "{" + this.endl + "border-color: " + this.HTMLColorToString(this.HTMLColors.get(color).darker().darker()) + ";" + this.endl + "background-color: " + this.HTMLColorToString(this.alter(this.HTMLColors.get(color))) + ";" + this.endl + "}" + this.endl;
    }

    private String getCellColor(String cellName) {
        if (this.cellColors.get(cellName) != null) {
            return this.cellColors.get(cellName);
        }
        return "defaultColor";
    }

    private String parsePreamble() {
        String result = "";
        if (this.preamble.contains("\\title{")) {
            this.title = this.parseComment(this.latexExtract(this.preamble, "\\title{"));
        }
        this.organization = this.latexExtract(this.preamble, "\\organization{");
        this.author = this.latexExtract(this.preamble, "\\author{");
        if (this.organization != null) {
            result = "<div> <br /> </div>" + this.endl + result;
            result = "<span>" + this.parseComment(this.organization) + " </span> " + this.endl + result;
        }
        if (this.author != null) {
            result = "<div> <br /> </div>" + this.endl + result;
            result = "<span>" + this.parseComment(this.author) + "</span> " + this.endl + result;
        }
        result = "<div> <br /> </div>" + this.endl + result;
        result = "<h1>" + this.title + " </h1> " + this.endl + result;
        return result;
    }

    private String latexExtract(String from, String instruction) {
        int a = from.indexOf(instruction);
        if (a != -1) {
            int i;
            int b = 1;
            for (i = a += instruction.length(); b > 0 && i < from.length(); ++i) {
                if (from.charAt(i) == '{') {
                    ++b;
                    continue;
                }
                if (from.charAt(i) != '}') continue;
                --b;
            }
            return from.substring(a, i - 1);
        }
        return null;
    }

    private void createHTMLColors() {
        this.usedColors.add("defaultColor");
        this.HTMLColors.put("aliceblue", new Color(240, 248, 255));
        this.HTMLColors.put("antiquewhite", new Color(250, 235, 215));
        this.HTMLColors.put("aqua", new Color(0, 255, 255));
        this.HTMLColors.put("aquamarine", new Color(127, 255, 212));
        this.HTMLColors.put("azure", new Color(240, 255, 255));
        this.HTMLColors.put("beige", new Color(245, 245, 220));
        this.HTMLColors.put("bisque", new Color(255, 228, 196));
        this.HTMLColors.put("black", new Color(0, 0, 0));
        this.HTMLColors.put("blanchedalmond", new Color(255, 235, 205));
        this.HTMLColors.put("blue", new Color(0, 0, 255));
        this.HTMLColors.put("blueviolet", new Color(138, 43, 226));
        this.HTMLColors.put("brown", new Color(165, 42, 42));
        this.HTMLColors.put("burlywood", new Color(222, 184, 135));
        this.HTMLColors.put("cadetblue", new Color(95, 158, 160));
        this.HTMLColors.put("chartreuse", new Color(127, 255, 0));
        this.HTMLColors.put("chocolate", new Color(210, 105, 30));
        this.HTMLColors.put("coral", new Color(255, 127, 80));
        this.HTMLColors.put("cornflowerblue", new Color(100, 149, 237));
        this.HTMLColors.put("cornsilk", new Color(255, 248, 220));
        this.HTMLColors.put("crimson", new Color(220, 20, 60));
        this.HTMLColors.put("cyan", new Color(0, 255, 255));
        this.HTMLColors.put("darkblue", new Color(0, 0, 139));
        this.HTMLColors.put("darkcyan", new Color(0, 139, 139));
        this.HTMLColors.put("darkgoldenrod", new Color(184, 134, 11));
        this.HTMLColors.put("darkgray", new Color(169, 169, 169));
        this.HTMLColors.put("darkgreen", new Color(0, 100, 0));
        this.HTMLColors.put("darkgrey", new Color(169, 169, 169));
        this.HTMLColors.put("darkkhaki", new Color(189, 183, 107));
        this.HTMLColors.put("darkmagenta", new Color(139, 0, 139));
        this.HTMLColors.put("darkolivegreen", new Color(85, 107, 47));
        this.HTMLColors.put("darkorchid", new Color(153, 50, 204));
        this.HTMLColors.put("darkred", new Color(139, 0, 0));
        this.HTMLColors.put("darksalmon", new Color(233, 150, 122));
        this.HTMLColors.put("darkseagreen", new Color(143, 188, 143));
        this.HTMLColors.put("darkslateblue", new Color(72, 61, 139));
        this.HTMLColors.put("darkslategray", new Color(47, 79, 79));
        this.HTMLColors.put("darkslategrey", new Color(47, 79, 79));
        this.HTMLColors.put("darkturquoise", new Color(0, 206, 209));
        this.HTMLColors.put("darkviolet", new Color(148, 0, 211));
        this.HTMLColors.put("darkorange", new Color(255, 140, 0));
        this.HTMLColors.put("deeppink", new Color(255, 20, 147));
        this.HTMLColors.put("deepskyblue", new Color(0, 191, 255));
        this.HTMLColors.put("dimgray", new Color(105, 105, 105));
        this.HTMLColors.put("dimgrey", new Color(105, 105, 105));
        this.HTMLColors.put("dodgerblue", new Color(30, 144, 255));
        this.HTMLColors.put("firebrick", new Color(178, 34, 34));
        this.HTMLColors.put("floralwhite", new Color(255, 250, 240));
        this.HTMLColors.put("forestgreen", new Color(34, 139, 34));
        this.HTMLColors.put("fuchsia", new Color(255, 0, 255));
        this.HTMLColors.put("gainsboro", new Color(220, 220, 220));
        this.HTMLColors.put("ghostwhite", new Color(248, 248, 255));
        this.HTMLColors.put("gold", new Color(255, 215, 0));
        this.HTMLColors.put("goldenrod", new Color(218, 165, 32));
        this.HTMLColors.put("gray", new Color(128, 128, 128));
        this.HTMLColors.put("green", new Color(0, 128, 0));
        this.HTMLColors.put("greenyellow", new Color(173, 255, 47));
        this.HTMLColors.put("grey", new Color(128, 128, 128));
        this.HTMLColors.put("honeydew", new Color(240, 255, 240));
        this.HTMLColors.put("hotpink", new Color(255, 105, 180));
        this.HTMLColors.put("indianred", new Color(205, 92, 92));
        this.HTMLColors.put("indigo", new Color(75, 0, 130));
        this.HTMLColors.put("ivory", new Color(255, 255, 240));
        this.HTMLColors.put("khaki", new Color(240, 230, 140));
        this.HTMLColors.put("lavender", new Color(230, 230, 250));
        this.HTMLColors.put("lavenderblush", new Color(255, 240, 245));
        this.HTMLColors.put("lawngreen", new Color(124, 252, 0));
        this.HTMLColors.put("lemonchiffon", new Color(255, 250, 205));
        this.HTMLColors.put("lightblue", new Color(173, 216, 230));
        this.HTMLColors.put("lightcoral", new Color(240, 128, 128));
        this.HTMLColors.put("lightcyan", new Color(224, 255, 255));
        this.HTMLColors.put("lightgoldenrodyellow", new Color(250, 250, 210));
        this.HTMLColors.put("lightgray", new Color(211, 211, 211));
        this.HTMLColors.put("lightgreen", new Color(144, 238, 144));
        this.HTMLColors.put("lightgrey", new Color(211, 211, 211));
        this.HTMLColors.put("lightpink", new Color(255, 182, 193));
        this.HTMLColors.put("lightsalmon", new Color(255, 160, 122));
        this.HTMLColors.put("lightseagreen", new Color(32, 178, 170));
        this.HTMLColors.put("lightskyblue", new Color(135, 206, 250));
        this.HTMLColors.put("lightslategray", new Color(119, 136, 153));
        this.HTMLColors.put("lightslategrey", new Color(119, 136, 153));
        this.HTMLColors.put("lightsteelblue", new Color(176, 196, 222));
        this.HTMLColors.put("lightyellow", new Color(255, 255, 224));
        this.HTMLColors.put("lime", new Color(0, 255, 0));
        this.HTMLColors.put("limegreen", new Color(50, 205, 50));
        this.HTMLColors.put("linen", new Color(250, 240, 230));
        this.HTMLColors.put("magenta", new Color(255, 0, 255));
        this.HTMLColors.put("maroon", new Color(128, 0, 0));
        this.HTMLColors.put("mediumaquamarine", new Color(102, 205, 170));
        this.HTMLColors.put("mediumblue", new Color(0, 0, 205));
        this.HTMLColors.put("mediumorchid", new Color(186, 85, 211));
        this.HTMLColors.put("mediumpurple", new Color(147, 112, 216));
        this.HTMLColors.put("mediumseagreen", new Color(60, 179, 113));
        this.HTMLColors.put("mediumslateblue", new Color(123, 104, 238));
        this.HTMLColors.put("mediumspringgreen", new Color(0, 250, 154));
        this.HTMLColors.put("mediumturquoise", new Color(72, 209, 204));
        this.HTMLColors.put("mediumvioletred", new Color(199, 21, 133));
        this.HTMLColors.put("midnightblue", new Color(25, 25, 112));
        this.HTMLColors.put("mintcream", new Color(245, 255, 250));
        this.HTMLColors.put("mistyrose", new Color(255, 228, 225));
        this.HTMLColors.put("moccasin", new Color(255, 228, 181));
        this.HTMLColors.put("navajowhite", new Color(255, 222, 173));
        this.HTMLColors.put("navy", new Color(0, 0, 128));
        this.HTMLColors.put("oldlace", new Color(253, 245, 230));
        this.HTMLColors.put("olive", new Color(128, 128, 0));
        this.HTMLColors.put("olivedrab", new Color(107, 142, 35));
        this.HTMLColors.put("orange", new Color(255, 165, 0));
        this.HTMLColors.put("orangered", new Color(255, 69, 0));
        this.HTMLColors.put("orchid", new Color(218, 112, 214));
        this.HTMLColors.put("palegoldenrod", new Color(238, 232, 170));
        this.HTMLColors.put("palegreen", new Color(152, 251, 152));
        this.HTMLColors.put("paleturquoise", new Color(175, 238, 238));
        this.HTMLColors.put("palevioletred", new Color(216, 112, 147));
        this.HTMLColors.put("papayawhip", new Color(255, 239, 213));
        this.HTMLColors.put("peachpuff", new Color(255, 218, 185));
        this.HTMLColors.put("peru", new Color(205, 133, 63));
        this.HTMLColors.put("pink", new Color(255, 192, 203));
        this.HTMLColors.put("plum", new Color(221, 160, 221));
        this.HTMLColors.put("powderblue", new Color(176, 224, 230));
        this.HTMLColors.put("purple", new Color(128, 0, 128));
        this.HTMLColors.put("red", new Color(255, 0, 0));
        this.HTMLColors.put("rosybrown", new Color(188, 143, 143));
        this.HTMLColors.put("royalblue", new Color(65, 105, 225));
        this.HTMLColors.put("saddlebrown", new Color(139, 69, 19));
        this.HTMLColors.put("salmon", new Color(250, 128, 114));
        this.HTMLColors.put("sandybrown", new Color(244, 164, 96));
        this.HTMLColors.put("seagreen", new Color(46, 139, 87));
        this.HTMLColors.put("seashell", new Color(255, 245, 238));
        this.HTMLColors.put("sienna", new Color(160, 82, 45));
        this.HTMLColors.put("silver", new Color(192, 192, 192));
        this.HTMLColors.put("skyblue", new Color(135, 206, 235));
        this.HTMLColors.put("slateblue", new Color(106, 90, 205));
        this.HTMLColors.put("slategray", new Color(112, 128, 144));
        this.HTMLColors.put("slategrey", new Color(112, 128, 144));
        this.HTMLColors.put("snow", new Color(255, 250, 250));
        this.HTMLColors.put("springgreen", new Color(0, 255, 127));
        this.HTMLColors.put("steelblue", new Color(70, 130, 180));
        this.HTMLColors.put("tan", new Color(210, 180, 140));
        this.HTMLColors.put("teal", new Color(0, 128, 128));
        this.HTMLColors.put("thistle", new Color(216, 191, 216));
        this.HTMLColors.put("tomato", new Color(255, 99, 71));
        this.HTMLColors.put("turquoise", new Color(64, 224, 208));
        this.HTMLColors.put("violet", new Color(238, 130, 238));
        this.HTMLColors.put("wheat", new Color(245, 222, 179));
        this.HTMLColors.put("white", new Color(255, 255, 255));
        this.HTMLColors.put("whitesmoke", new Color(245, 245, 245));
        this.HTMLColors.put("yellow", new Color(255, 255, 0));
        this.HTMLColors.put("yellowgreen", new Color(154, 205, 50));
    }
}

