/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.html;

import java.util.HashMap;
import java.util.Map;
import org.kframework.kil.Production;
import org.kframework.kil.Sort;
import org.kframework.kil.Terminal;
import org.kframework.kil.UserList;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.BasicVisitor;

public class HTMLPatternsVisitor
extends BasicVisitor {
    private Map<String, String> patterns = new HashMap<String, String>();
    private Map<String, HTMLPatternType> type = new HashMap<String, HTMLPatternType>();
    String pattern = "";
    int nonTerm;
    boolean prevNonTerm;

    public HTMLPatternsVisitor(Context context) {
        super(context);
    }

    public void setPatterns(Map<String, String> patterns) {
        this.patterns = patterns;
    }

    public Map<String, String> getPatterns() {
        return this.patterns;
    }

    public HTMLPatternType getPatternType(String cons) {
        if (this.type.containsKey(cons)) {
            return this.type.get(cons);
        }
        return null;
    }

    @Override
    public void visit(Production p) {
        if (!p.containsAttribute("cons")) {
            return;
        }
        if (p.containsAttribute("latex") || p.containsAttribute("html")) {
            if (p.containsAttribute("latex")) {
                this.pattern = p.getAttribute("latex");
                this.pattern = this.pattern.replace("\\\\", "\\");
                this.patterns.put(p.getAttribute("cons"), this.pattern);
                this.type.put(p.getAttribute("cons"), HTMLPatternType.LATEX);
            }
            if (p.containsAttribute("html")) {
                this.pattern = p.getAttribute("html");
                this.pattern = this.pattern.substring(1, this.pattern.length() - 1).replace("\\\\", "\\");
                this.patterns.put(p.getAttribute("cons"), this.pattern);
                this.type.put(p.getAttribute("cons"), HTMLPatternType.HTML);
            }
        } else {
            this.type.put(p.getAttribute("cons"), HTMLPatternType.DEFAULT);
        }
    }

    @Override
    public void visit(Sort sort) {
    }

    @Override
    public void visit(UserList sort) {
    }

    @Override
    public void visit(Terminal pi) {
    }

    public static enum HTMLPatternType {
        LATEX,
        HTML,
        DEFAULT;

    }
}

