/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.builtins;

import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.kil.Token;
import org.kframework.backend.java.symbolic.Matcher;
import org.kframework.backend.java.symbolic.Transformer;
import org.kframework.backend.java.symbolic.Unifier;
import org.kframework.backend.java.symbolic.Visitor;
import org.kframework.kil.ASTNode;

public class BoolToken
extends Token {
    public static final String SORT_NAME = "Bool";
    public static final BoolToken TRUE = new BoolToken(true);
    public static final BoolToken FALSE = new BoolToken(false);
    private final boolean value;

    private BoolToken(boolean value) {
        this.value = value;
    }

    public static BoolToken of(boolean value) {
        return value ? TRUE : FALSE;
    }

    public boolean booleanValue() {
        return this.value;
    }

    @Override
    public String sort() {
        return SORT_NAME;
    }

    @Override
    public String value() {
        return Boolean.toString(this.value);
    }

    @Override
    public int hashCode() {
        return Boolean.valueOf(this.value).hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public void accept(Unifier unifier, Term pattern) {
        unifier.unify(this, pattern);
    }

    @Override
    public void accept(Matcher matcher, Term pattern) {
        matcher.match(this, pattern);
    }

    @Override
    public ASTNode accept(Transformer transformer) {
        return transformer.transform(this);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    private Object readResolve() {
        return BoolToken.of(this.booleanValue());
    }
}

