/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.builtins;

import com.google.common.collect.ImmutableList;
import org.kframework.backend.java.builtins.BoolToken;
import org.kframework.backend.java.builtins.UninterpretedToken;
import org.kframework.backend.java.kil.KItem;
import org.kframework.backend.java.kil.KLabelConstant;
import org.kframework.backend.java.kil.KList;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.kil.TermContext;
import org.kframework.backend.java.util.GappaPrinter;
import org.kframework.backend.java.util.GappaServer;
import org.kframework.krun.K;

public class BuiltinFloatOperations {
    public static Term add(Term term1, Term term2, TermContext context) {
        if (term1.equals(UninterpretedToken.of("#Float", "0.0"))) {
            return term2;
        }
        if (term2.equals(UninterpretedToken.of("#Float", "0.0"))) {
            return term1;
        }
        return null;
    }

    public static Term sub(Term term1, Term term2, TermContext context) {
        if (term1.equals(UninterpretedToken.of("#Float", "0.0"))) {
            return new KItem(KLabelConstant.of("'--Float_", context), new KList(ImmutableList.of(term2), null), context).evaluate(context);
        }
        if (term2.equals(UninterpretedToken.of("#Float", "0.0"))) {
            return term1;
        }
        return null;
    }

    public static Term mul(Term term1, Term term2, TermContext context) {
        if (term1.equals(UninterpretedToken.of("#Float", "0.0")) || term2.equals(UninterpretedToken.of("#Float", "0.0"))) {
            return UninterpretedToken.of("#Float", "0.0");
        }
        return null;
    }

    public static Term unaryMinus(Term term, TermContext context) {
        if (term instanceof KItem) {
            Term kLabel = ((KItem)term).kLabel();
            Term kList = ((KItem)term).kList();
            if (kLabel instanceof KLabelConstant && kList instanceof KList && ((KLabelConstant)kLabel).label().equals("'--Float_")) {
                return ((KList)kList).get(0);
            }
        }
        if (!(term instanceof UninterpretedToken)) {
            return null;
        }
        UninterpretedToken token = (UninterpretedToken)term;
        String sort = token.sort();
        if (!sort.equals("#Float")) {
            return null;
        }
        String value = token.value();
        value = value.startsWith("-") ? value.substring(1) : "-" + value;
        return UninterpretedToken.of(sort, value);
    }

    public static BoolToken eq(Term term1, Term term2, TermContext context) {
        if (term1.equals(term2)) {
            return BoolToken.TRUE;
        }
        return null;
    }

    public static BoolToken gt(Term term1, Term term2, TermContext context) {
        if (!K.smt.equals("gappa")) {
            return null;
        }
        GappaPrinter gappaPrinter = GappaPrinter.toGappaGround(term1);
        if (gappaPrinter.getException() != null) {
            return null;
        }
        String gterm1 = gappaPrinter.getResult();
        gappaPrinter = GappaPrinter.toGappaGround(term2);
        if (gappaPrinter.getException() != null) {
            return null;
        }
        String gterm2 = gappaPrinter.getResult();
        String inputFalse = "(" + gterm1 + " - " + gterm2 + ")" + " <= 0";
        if (GappaServer.proveFalse(inputFalse)) {
            return BoolToken.TRUE;
        }
        if (GappaServer.proveTrue(inputFalse)) {
            return BoolToken.FALSE;
        }
        return null;
    }

    public static BoolToken ge(Term term1, Term term2, TermContext context) {
        if (!K.smt.equals("gappa")) {
            return null;
        }
        GappaPrinter gappaPrinter = GappaPrinter.toGappaGround(term1);
        if (gappaPrinter.getException() != null) {
            return null;
        }
        String gterm1 = gappaPrinter.getResult();
        gappaPrinter = GappaPrinter.toGappaGround(term2);
        if (gappaPrinter.getException() != null) {
            return null;
        }
        String gterm2 = gappaPrinter.getResult();
        String inputTrue = "(" + gterm1 + "-" + gterm2 + ")" + " >= 0";
        if (GappaServer.proveTrue(inputTrue)) {
            return BoolToken.TRUE;
        }
        if (GappaServer.proveFalse(inputTrue)) {
            return BoolToken.FALSE;
        }
        return null;
    }

    public static BoolToken lt(Term term1, Term term2, TermContext context) {
        if (!K.smt.equals("gappa")) {
            return null;
        }
        GappaPrinter gappaPrinter = GappaPrinter.toGappaGround(term1);
        if (gappaPrinter.getException() != null) {
            return null;
        }
        String gterm1 = gappaPrinter.getResult();
        gappaPrinter = GappaPrinter.toGappaGround(term2);
        if (gappaPrinter.getException() != null) {
            return null;
        }
        String gterm2 = gappaPrinter.getResult();
        String inputFalse = "(" + gterm1 + " - " + gterm2 + ")" + " >= 0";
        if (GappaServer.proveFalse(inputFalse)) {
            return BoolToken.TRUE;
        }
        if (GappaServer.proveTrue(inputFalse)) {
            return BoolToken.FALSE;
        }
        return null;
    }

    public static BoolToken le(Term term1, Term term2, TermContext context) {
        if (!K.smt.equals("gappa")) {
            return null;
        }
        GappaPrinter gappaPrinter = GappaPrinter.toGappaGround(term1);
        if (gappaPrinter.getException() != null) {
            return null;
        }
        String gterm1 = gappaPrinter.getResult();
        gappaPrinter = GappaPrinter.toGappaGround(term2);
        if (gappaPrinter.getException() != null) {
            return null;
        }
        String gterm2 = gappaPrinter.getResult();
        String inputTrue = "(" + gterm1 + "-" + gterm2 + ")" + " <= 0";
        if (GappaServer.proveTrue(inputTrue)) {
            return BoolToken.TRUE;
        }
        if (GappaServer.proveFalse(inputTrue)) {
            return BoolToken.FALSE;
        }
        return null;
    }
}

