/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.builtins;

import java.util.HashSet;
import org.kframework.backend.java.builtins.BoolToken;
import org.kframework.backend.java.kil.BuiltinSet;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.kil.TermContext;
import org.kframework.backend.java.kil.Variable;

public class BuiltinSetOperations {
    public static BuiltinSet construct(BuiltinSet term1, BuiltinSet term2, TermContext context) {
        Variable frame = null;
        if (term1.hasFrame() && term2.hasFrame()) {
            throw new IllegalArgumentException("both set arguments have frames, but the combined set cannot have two frames");
        }
        if (term1.hasFrame()) {
            frame = term1.frame();
        } else if (term2.hasFrame()) {
            frame = term2.frame();
        }
        HashSet<Term> elements = new HashSet<Term>(term1.elements());
        elements.addAll(term2.elements());
        return new BuiltinSet(elements, frame);
    }

    public static BuiltinSet difference(BuiltinSet term1, BuiltinSet term2, TermContext context) {
        if (!term1.isGround()) {
            throw new IllegalArgumentException("first argument " + term1 + " is not ground");
        }
        if (!term2.isGround()) {
            throw new IllegalArgumentException("second argument " + term2 + " is not ground");
        }
        HashSet<Term> elements = new HashSet<Term>(term1.elements());
        elements.removeAll(term2.elements());
        return new BuiltinSet(elements);
    }

    public static BoolToken in(Term term1, BuiltinSet term2, TermContext context) {
        if (!term1.isGround()) {
            throw new IllegalArgumentException("first argument " + term1 + " is not ground");
        }
        if (!term2.isGround()) {
            throw new IllegalArgumentException("second argument " + term2 + " is not ground");
        }
        return BoolToken.of(term2.elements().contains(term1));
    }
}

