/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.builtins;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.kframework.backend.java.builtins.BoolToken;
import org.kframework.backend.java.kil.KCollection;
import org.kframework.backend.java.kil.KItem;
import org.kframework.backend.java.kil.KLabel;
import org.kframework.backend.java.kil.KLabelInjection;
import org.kframework.backend.java.kil.KList;
import org.kframework.backend.java.kil.Kind;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.kil.TermContext;
import org.kframework.backend.java.symbolic.LocalTransformer;
import org.kframework.backend.java.symbolic.PrePostTransformer;
import org.kframework.kil.ASTNode;

public class BuiltinVisitorOperations
extends PrePostTransformer {
    private final KLabel ifLabel;
    private final List<Term> ifParams;
    private final KLabel visitLabel;
    private final List<Term> visitParams;

    BuiltinVisitorOperations(KLabel ifLabel, List<Term> ifParams, KLabel visitLabel, List<Term> visitParams, TermContext context) {
        super(context);
        this.ifLabel = ifLabel;
        this.ifParams = ifParams;
        this.visitLabel = visitLabel;
        this.visitParams = visitParams;
        this.preTransformer.addTransformer(new LocalTransformer(context){

            @Override
            public ASTNode transform(Term term) {
                if (term instanceof KLabel) {
                    return new PrePostTransformer.DoneTransforming(BuiltinVisitorOperations.this, term);
                }
                if (BuiltinVisitorOperations.this.evaluateGuard(term)) {
                    return new PrePostTransformer.DoneTransforming(BuiltinVisitorOperations.this, BuiltinVisitorOperations.this.visitNode(term));
                }
                return term;
            }
        });
    }

    private Term visitNode(Term term) {
        this.visitParams.set(0, term);
        term = new KItem(this.visitLabel, new KList(ImmutableList.copyOf(this.visitParams)), this.context);
        return term.evaluate(this.context);
    }

    private boolean evaluateGuard(Term term) {
        this.ifParams.set(0, term);
        KItem test2 = new KItem(this.ifLabel, new KList(ImmutableList.copyOf(this.ifParams)), this.context);
        return test2.evaluate(this.context) == BoolToken.TRUE;
    }

    private static Term getInjectedTerm(KItem kItem) {
        return ((KLabelInjection)kItem.kLabel()).term();
    }

    public static Term visit(Term term, KItem visitLabelTerm, KItem visitListTerm, KItem ifLabelTerm, KItem ifListTerm, TermContext context) {
        KList ifList;
        KLabel ifLabel;
        KList visitList;
        KLabel visitLabel;
        try {
            visitLabel = (KLabel)BuiltinVisitorOperations.getInjectedTerm(visitLabelTerm);
            visitList = (KList)KCollection.upKind(BuiltinVisitorOperations.getInjectedTerm(visitListTerm), Kind.KLIST);
            ifLabel = (KLabel)BuiltinVisitorOperations.getInjectedTerm(ifLabelTerm);
            ifList = (KList)KCollection.upKind(BuiltinVisitorOperations.getInjectedTerm(ifListTerm), Kind.KLIST);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e);
        }
        ArrayList<Term> ifParams = new ArrayList<Term>();
        ifParams.add(term);
        ifParams.addAll(ifList.getContents());
        ArrayList<Term> visitParams = new ArrayList<Term>();
        visitParams.add(term);
        visitParams.addAll(visitList.getContents());
        return (Term)term.accept(new BuiltinVisitorOperations(ifLabel, ifParams, visitLabel, visitParams, context));
    }
}

