/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.builtins;

import java.util.HashMap;
import java.util.Map;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.kil.Token;
import org.kframework.backend.java.symbolic.Matcher;
import org.kframework.backend.java.symbolic.Transformer;
import org.kframework.backend.java.symbolic.Unifier;
import org.kframework.backend.java.symbolic.Visitor;
import org.kframework.kil.ASTNode;

public class Int32Token
extends Token {
    public static final String SORT_NAME = "Int32";
    private static final Map<Integer, Int32Token> cache = new HashMap<Integer, Int32Token>();
    private static int freshValue = 0;
    private final int value;

    private Int32Token(int value) {
        this.value = value;
    }

    public static Int32Token fresh() {
        return Int32Token.of(++freshValue);
    }

    public static Int32Token of(int value) {
        Int32Token intToken = cache.get(value);
        if (intToken == null) {
            intToken = new Int32Token(value);
            cache.put(value, intToken);
        }
        return intToken;
    }

    public int intValue() {
        return this.value;
    }

    public byte unsignedByteValue() {
        if (this.value > 255) {
            throw new ArithmeticException();
        }
        if (this.value < 0) {
            throw new ArithmeticException();
        }
        return (byte)this.value;
    }

    @Override
    public String sort() {
        return SORT_NAME;
    }

    @Override
    public String value() {
        return Integer.toString(this.value);
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public void accept(Unifier unifier, Term pattern) {
        unifier.unify(this, pattern);
    }

    @Override
    public void accept(Matcher matcher, Term pattern) {
        matcher.match(this, pattern);
    }

    @Override
    public ASTNode accept(Transformer transformer) {
        return transformer.transform(this);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    private Object readResolve() {
        Int32Token intToken = cache.get(this.value);
        if (intToken == null) {
            intToken = this;
            cache.put(this.value, intToken);
        }
        return intToken;
    }
}

