/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.builtins;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.kil.Token;
import org.kframework.backend.java.symbolic.Matcher;
import org.kframework.backend.java.symbolic.Transformer;
import org.kframework.backend.java.symbolic.Unifier;
import org.kframework.backend.java.symbolic.Visitor;
import org.kframework.kil.ASTNode;

public class IntToken
extends Token {
    public static final String SORT_NAME = "Int";
    private static final Map<BigInteger, IntToken> cache = new HashMap<BigInteger, IntToken>();
    private static BigInteger freshValue = BigInteger.valueOf(0L);
    private final BigInteger value;

    private IntToken(BigInteger value) {
        this.value = value;
    }

    public static IntToken fresh() {
        freshValue = freshValue.add(BigInteger.valueOf(1L));
        return IntToken.of(freshValue);
    }

    public static IntToken of(BigInteger value) {
        assert (value != null);
        IntToken intToken = cache.get(value);
        if (intToken == null) {
            intToken = new IntToken(value);
            cache.put(value, intToken);
        }
        return intToken;
    }

    public static IntToken of(long value) {
        return IntToken.of(BigInteger.valueOf(value));
    }

    public BigInteger bigIntegerValue() {
        return this.value;
    }

    public int intValue() {
        if (this.value.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
            throw new ArithmeticException();
        }
        if (this.value.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) < 0) {
            throw new ArithmeticException();
        }
        return (int)this.value.longValue();
    }

    public long longValue() {
        if (this.value.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
            throw new ArithmeticException();
        }
        if (this.value.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) < 0) {
            throw new ArithmeticException();
        }
        return this.value.longValue();
    }

    public byte unsignedByteValue() {
        if (this.value.compareTo(BigInteger.valueOf(255L)) > 0) {
            throw new ArithmeticException();
        }
        if (this.value.compareTo(BigInteger.valueOf(0L)) < 0) {
            throw new ArithmeticException();
        }
        return (byte)this.value.longValue();
    }

    @Override
    public String sort() {
        return SORT_NAME;
    }

    @Override
    public String value() {
        return this.value.toString();
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public void accept(Unifier unifier, Term pattern) {
        unifier.unify(this, pattern);
    }

    @Override
    public void accept(Matcher matcher, Term pattern) {
        matcher.match(this, pattern);
    }

    @Override
    public ASTNode accept(Transformer transformer) {
        return transformer.transform(this);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    private Object readResolve() {
        IntToken intToken = cache.get(this.value);
        if (intToken == null) {
            intToken = this;
            cache.put(this.value, intToken);
        }
        return intToken;
    }
}

