/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.builtins;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.kframework.backend.java.builtins.BoolToken;
import org.kframework.backend.java.kil.BuiltinMap;
import org.kframework.backend.java.kil.BuiltinSet;
import org.kframework.backend.java.kil.KItem;
import org.kframework.backend.java.kil.KLabel;
import org.kframework.backend.java.kil.MetaVariable;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.kil.TermContext;
import org.kframework.backend.java.kil.Variable;
import org.kframework.backend.java.symbolic.PatternMatcher;
import org.kframework.backend.java.symbolic.SymbolicConstraint;
import org.kframework.backend.java.symbolic.SymbolicUnifier;
import org.kframework.backend.java.symbolic.UnificationFailure;

public class MetaK {
    public static BoolToken unifiable(Term term1, Term term2, TermContext context) {
        SymbolicConstraint constraint = new SymbolicConstraint(context);
        SymbolicUnifier unifier = new SymbolicUnifier(constraint, context);
        try {
            unifier.unify(term1, term2);
        }
        catch (UnificationFailure e) {
            return BoolToken.FALSE;
        }
        return BoolToken.TRUE;
    }

    public static BoolToken matchable(Term subject, Term pattern, TermContext context) {
        return PatternMatcher.matchable(subject, pattern, context) ? BoolToken.TRUE : BoolToken.FALSE;
    }

    public static Term rename(Term term, BuiltinSet builtinSet, TermContext context) {
        if (builtinSet.hasFrame()) {
            return term;
        }
        HashSet<Variable> variables = new HashSet<Variable>();
        for (Term element : builtinSet.elements()) {
            if (!(element instanceof MetaVariable)) {
                return term;
            }
            variables.add(new Variable((MetaVariable)element));
        }
        return term.substitute(Variable.getFreshSubstitution(variables), context);
    }

    public static Term renameVariables(Term term, TermContext context) {
        Set<Variable> variables = term.variableSet();
        return term.substitute(Variable.getFreshSubstitution(variables), context);
    }

    public static BuiltinSet variables(Term term, TermContext context) {
        HashSet<MetaVariable> metaVariables = new HashSet<MetaVariable>();
        for (Variable variable : term.variableSet()) {
            metaVariables.add(new MetaVariable(variable));
        }
        return new BuiltinSet(metaVariables);
    }

    public static BuiltinSet trueVariables(Term term, TermContext context) {
        Set<Variable> trueVariables = term.variableSet();
        return new BuiltinSet(trueVariables);
    }

    public static BuiltinMap variablesMap(Term term, TermContext context) {
        Set<Variable> variables = term.variableSet();
        HashMap<MetaVariable, Variable> result = new HashMap<MetaVariable, Variable>(variables.size());
        for (Variable variable : variables) {
            assert (variable instanceof Variable) : "this function only applies on variables";
            result.put(new MetaVariable(variable), variable);
        }
        return BuiltinMap.of(result, null);
    }

    public static KLabel getKLabel(KItem kItem, TermContext context) {
        return (KLabel)kItem.kLabel();
    }
}

