/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.builtins;

import com.google.common.collect.ImmutableSet;
import org.kframework.backend.java.builtins.BoolToken;
import org.kframework.backend.java.builtins.UninterpretedToken;
import org.kframework.backend.java.kil.BuiltinList;
import org.kframework.backend.java.kil.BuiltinMap;
import org.kframework.backend.java.kil.BuiltinSet;
import org.kframework.backend.java.kil.KCollection;
import org.kframework.backend.java.kil.KItem;
import org.kframework.backend.java.kil.KLabel;
import org.kframework.backend.java.kil.KLabelConstant;
import org.kframework.backend.java.kil.KList;
import org.kframework.backend.java.kil.Sorted;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.kil.TermContext;
import org.kframework.backend.java.kil.Token;
import org.kframework.kil.loader.Context;

public class SortMembership {
    public static Term check(KItem kItem, Context context) {
        assert (kItem.kLabel() instanceof KLabelConstant);
        assert (kItem.kList() instanceof KList && ((KList)kItem.kList()).size() == 1 && !((KList)kItem.kList()).hasFrame());
        String predicateSort = ((KLabelConstant)kItem.kLabel()).label().substring("is".length());
        if (!context.getAllSorts().contains(predicateSort)) {
            return kItem;
        }
        Term term = (Term)((KList)kItem.kList()).getContents().get(0);
        String termSort = ((Sorted)((Object)term)).sort();
        if (term instanceof KItem && ((KItem)term).kLabel() instanceof KLabel && ((KLabel)((KItem)term).kLabel()).isConstructor()) {
            return context.isSubsortedEq(predicateSort, termSort) ? BoolToken.TRUE : BoolToken.FALSE;
        }
        if (context.isSubsortedEq(predicateSort, termSort)) {
            return BoolToken.TRUE;
        }
        if (null == context.getGLBSort(ImmutableSet.of(predicateSort, termSort))) {
            return BoolToken.FALSE;
        }
        return kItem;
    }

    public static Term isBuiltin(Term term, TermContext context) {
        if (term.kind().isComputational()) {
            term = KCollection.downKind(term);
        }
        if (term instanceof Token || term instanceof BuiltinList || term instanceof BuiltinSet || term instanceof BuiltinMap) {
            return BoolToken.TRUE;
        }
        if (term.isGround()) {
            return BoolToken.FALSE;
        }
        throw new IllegalArgumentException("argument " + term + " is not ground");
    }

    public static Term isToken(Term term, TermContext context) {
        if (term.kind().isComputational()) {
            term = KCollection.downKind(term);
        }
        if (term instanceof UninterpretedToken) {
            return BoolToken.TRUE;
        }
        if (term.isGround()) {
            return BoolToken.FALSE;
        }
        throw new IllegalArgumentException("argument " + term + " is not ground");
    }
}

