/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.builtins;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.util.HashMap;
import java.util.Map;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.kil.Token;
import org.kframework.backend.java.symbolic.Matcher;
import org.kframework.backend.java.symbolic.Transformer;
import org.kframework.backend.java.symbolic.Unifier;
import org.kframework.backend.java.symbolic.Visitor;
import org.kframework.kil.ASTNode;
import org.kframework.utils.StringUtil;

public class StringToken
extends Token {
    public static final String SORT_NAME = "String";
    private static final Map<String, StringToken> cache = new HashMap<String, StringToken>();
    private final String value;

    private StringToken(String value) {
        this.value = value;
    }

    public static StringToken of(String value) {
        assert (value != null);
        StringToken stringToken = cache.get(value);
        if (stringToken == null) {
            stringToken = new StringToken(value);
            cache.put(value, stringToken);
        }
        return stringToken;
    }

    public static StringToken of(byte[] value) {
        try {
            String stringValue = new String(value, "ISO-8859-1");
            return StringToken.of(stringValue);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"no latin-1 charset???");
        }
    }

    public String stringValue() {
        return this.value;
    }

    public byte[] byteArrayValue() throws CharacterCodingException {
        ByteBuffer buffer = Charset.forName("ISO-8859-1").newEncoder().onUnmappableCharacter(CodingErrorAction.REPORT).encode(CharBuffer.wrap(this.value));
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return bytes;
    }

    @Override
    public String sort() {
        return SORT_NAME;
    }

    @Override
    public String value() {
        return StringUtil.escapeK(this.value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public void accept(Unifier unifier, Term pattern) {
        unifier.unify(this, pattern);
    }

    @Override
    public void accept(Matcher matcher, Term pattern) {
        matcher.match(this, pattern);
    }

    @Override
    public ASTNode accept(Transformer transformer) {
        return transformer.transform(this);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    private Object readResolve() {
        StringToken stringToken = cache.get(this.value);
        if (stringToken == null) {
            stringToken = this;
            cache.put(this.value, stringToken);
        }
        return stringToken;
    }
}

