/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.indexing;

import java.io.Serializable;
import org.kframework.backend.java.indexing.BottomIndex;
import org.kframework.backend.java.indexing.FreezerIndex;
import org.kframework.backend.java.indexing.Index;
import org.kframework.backend.java.indexing.KLabelIndex;
import org.kframework.backend.java.indexing.TokenIndex;
import org.kframework.backend.java.indexing.TopIndex;
import org.kframework.backend.java.kil.Definition;
import org.kframework.backend.java.kil.Hole;
import org.kframework.backend.java.kil.KItem;
import org.kframework.backend.java.kil.KLabelConstant;
import org.kframework.backend.java.kil.KLabelFreezer;
import org.kframework.backend.java.kil.KList;
import org.kframework.backend.java.kil.KSequence;
import org.kframework.backend.java.kil.Sorted;
import org.kframework.backend.java.kil.Term;

public class IndexingPair
implements Serializable {
    public static final IndexingPair TOP = new IndexingPair(TopIndex.TOP, TopIndex.TOP);
    public final Index first;
    public final Index second;

    public static Index getIndex(Term term, Definition definition) {
        if (term instanceof KItem) {
            KItem kItem = (KItem)term;
            if (kItem.kLabel() instanceof KLabelConstant) {
                KLabelConstant kLabel = (KLabelConstant)kItem.kLabel();
                return new KLabelIndex(kLabel);
            }
            if (kItem.kLabel() instanceof KLabelFreezer) {
                KLabelFreezer freezer = (KLabelFreezer)kItem.kLabel();
                KItem frozenKItem = (KItem)freezer.term();
                return new FreezerIndex((KLabelConstant)frozenKItem.kLabel(), ((KList)frozenKItem.kList()).getContents().indexOf(Hole.HOLE));
            }
        } else if (term instanceof Sorted) {
            Sorted sorted = (Sorted)((Object)term);
            if (definition.builtinSorts().contains(sorted.sort())) {
                return new TokenIndex(sorted.sort());
            }
        }
        return TopIndex.TOP;
    }

    public static IndexingPair getIndexingPair(Term term, Definition definition) {
        if (term instanceof KSequence) {
            KSequence kSequence = (KSequence)term;
            if (kSequence.size() == 0) {
                if (kSequence.hasFrame()) {
                    return new IndexingPair(TopIndex.TOP, TopIndex.TOP);
                }
                return new IndexingPair(BottomIndex.BOTTOM, BottomIndex.BOTTOM);
            }
            if (kSequence.size() == 1) {
                if (kSequence.hasFrame()) {
                    return new IndexingPair(IndexingPair.getIndex(kSequence.get(0), definition), TopIndex.TOP);
                }
                return new IndexingPair(IndexingPair.getIndex(kSequence.get(0), definition), BottomIndex.BOTTOM);
            }
            return new IndexingPair(IndexingPair.getIndex(kSequence.get(0), definition), IndexingPair.getIndex(kSequence.get(1), definition));
        }
        return new IndexingPair(IndexingPair.getIndex(term, definition), BottomIndex.BOTTOM);
    }

    public IndexingPair(Index first, Index second) {
        this.first = first;
        this.second = second;
    }

    public boolean isUnifiable(IndexingPair pair) {
        return this.first.isUnifiable(pair.first) && this.second.isUnifiable(pair.second);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IndexingPair)) {
            return false;
        }
        IndexingPair pair = (IndexingPair)object;
        return this.first.equals(pair.first) && this.second.equals(pair.second);
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 47 + this.first.hashCode();
        hash = hash * 47 + this.second.hashCode();
        return hash;
    }

    public String toString() {
        return "(" + this.first + ", " + this.second + ")";
    }
}

