/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.indexing;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.kframework.backend.java.indexing.BottomIndex;
import org.kframework.backend.java.indexing.FreezerIndex;
import org.kframework.backend.java.indexing.Index;
import org.kframework.backend.java.indexing.IndexingPair;
import org.kframework.backend.java.indexing.KLabelIndex;
import org.kframework.backend.java.indexing.RuleIndex;
import org.kframework.backend.java.indexing.TokenIndex;
import org.kframework.backend.java.indexing.TopIndex;
import org.kframework.backend.java.kil.Definition;
import org.kframework.backend.java.kil.KLabelConstant;
import org.kframework.backend.java.kil.Rule;
import org.kframework.backend.java.kil.Term;
import org.kframework.kil.Production;

public class IndexingTable
implements Serializable,
RuleIndex {
    private Map<Index, List<Rule>> ruleTable;
    private Map<Index, List<Rule>> heatingRuleTable;
    private Map<Index, List<Rule>> coolingRuleTable;
    private Map<Index, List<Rule>> simulationRuleTable;
    private List<Rule> unindexedRules;
    private final Definition definition;

    public IndexingTable(Definition definition) {
        this.definition = definition;
        this.buildIndex();
    }

    @Override
    public void buildIndex() {
        ArrayList<Index> indices = new ArrayList<Index>();
        indices.add(TopIndex.TOP);
        indices.add(BottomIndex.BOTTOM);
        for (KLabelConstant kLabel : this.definition.kLabels()) {
            indices.add(new KLabelIndex(kLabel));
            indices.add(new FreezerIndex(kLabel, -1));
            if (kLabel.productions().isEmpty()) continue;
            int maxArity = this.getMaxArityForProductions(kLabel.productions());
            for (int i = 0; i < maxArity; ++i) {
                indices.add(new FreezerIndex(kLabel, i));
            }
        }
        for (String sort : this.definition.builtinSorts()) {
            indices.add(new TokenIndex(sort));
        }
        ImmutableMap.Builder<Index, ImmutableCollection> mapBuilder = ImmutableMap.builder();
        ImmutableMap.Builder<Index, ImmutableCollection> heatingMapBuilder = ImmutableMap.builder();
        ImmutableMap.Builder<Index, ImmutableCollection> coolingMapBuilder = ImmutableMap.builder();
        ImmutableMap.Builder<Index, ImmutableCollection> simulationMapBuilder = ImmutableMap.builder();
        for (Index index : indices) {
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            ImmutableList.Builder heatingListBuilder = ImmutableList.builder();
            ImmutableList.Builder coolingListBuilder = ImmutableList.builder();
            ImmutableList.Builder simulationListBuilder = ImmutableList.builder();
            for (Rule rule : this.definition.rules()) {
                if (rule.containsAttribute("heat")) {
                    if (!index.isUnifiable(rule.indexingPair().first)) continue;
                    heatingListBuilder.add(rule);
                    continue;
                }
                if (rule.containsAttribute("cool")) {
                    if (!index.isUnifiable(rule.indexingPair().second)) continue;
                    coolingListBuilder.add(rule);
                    continue;
                }
                if (rule.containsAttribute("alphaRule")) {
                    if (!index.isUnifiable(rule.indexingPair().first)) continue;
                    simulationListBuilder.add(rule);
                    continue;
                }
                if (!index.isUnifiable(rule.indexingPair().first)) continue;
                listBuilder.add(rule);
            }
            ImmutableCollection rules = listBuilder.build();
            if (!rules.isEmpty()) {
                mapBuilder.put(index, rules);
            }
            if (!(rules = heatingListBuilder.build()).isEmpty()) {
                heatingMapBuilder.put(index, rules);
            }
            if (!(rules = coolingListBuilder.build()).isEmpty()) {
                coolingMapBuilder.put(index, rules);
            }
            if ((rules = simulationListBuilder.build()).isEmpty()) continue;
            simulationMapBuilder.put(index, rules);
        }
        this.heatingRuleTable = heatingMapBuilder.build();
        this.coolingRuleTable = coolingMapBuilder.build();
        this.ruleTable = mapBuilder.build();
        this.simulationRuleTable = simulationMapBuilder.build();
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (Rule rule : this.definition.rules()) {
            if (rule.containsKCell()) continue;
            listBuilder.add(rule);
        }
        this.unindexedRules = listBuilder.build();
    }

    private int getMaxArityForProductions(List<Production> productions) {
        int max = productions.get(0).getArity();
        if (productions.size() > 1) {
            for (Production production : productions.subList(1, productions.size())) {
                if (production.getArity() <= max) continue;
                max = production.getArity();
            }
        }
        return max;
    }

    @Override
    public List<Rule> getRules(Term term) {
        LinkedHashSet<Rule> rules = new LinkedHashSet<Rule>();
        for (IndexingPair pair : term.getIndexingPairs(this.definition)) {
            if (this.ruleTable.get(pair.first) != null) {
                rules.addAll((Collection)this.ruleTable.get(pair.first));
            }
            if (this.heatingRuleTable.get(pair.first) != null) {
                rules.addAll((Collection)this.heatingRuleTable.get(pair.first));
            }
            if (this.coolingRuleTable.get(pair.second) == null) continue;
            rules.addAll((Collection)this.coolingRuleTable.get(pair.second));
        }
        rules.addAll(this.unindexedRules);
        return new ArrayList<Rule>(rules);
    }

    public Map<Index, List<Rule>> getSimulationRuleTable() {
        return this.simulationRuleTable;
    }
}

