/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.indexing.pathIndex;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections15.MultiMap;
import org.apache.commons.collections15.multimap.MultiHashMap;
import org.kframework.backend.java.indexing.RuleIndex;
import org.kframework.backend.java.indexing.pathIndex.trie.PathIndexTrie;
import org.kframework.backend.java.indexing.pathIndex.visitors.CoolingRuleVisitor;
import org.kframework.backend.java.indexing.pathIndex.visitors.HeatingRuleVisitor;
import org.kframework.backend.java.indexing.pathIndex.visitors.RuleVisitor;
import org.kframework.backend.java.indexing.pathIndex.visitors.TermVisitor;
import org.kframework.backend.java.kil.Definition;
import org.kframework.backend.java.kil.Rule;
import org.kframework.backend.java.kil.Term;
import org.kframework.krun.K;
import org.kframework.utils.general.IndexingStatistics;

public class PathIndex
implements RuleIndex,
Serializable {
    private final Map<Integer, Rule> indexedRules;
    private final Definition definition;
    private PathIndexTrie trie;
    private final Set<Integer> outputRuleIndices = new LinkedHashSet<Integer>();
    private final Set<Integer> inputRuleIndices = new LinkedHashSet<Integer>();
    private TermVisitor termVisitor;

    public PathIndex(Definition definition) {
        this.definition = definition;
        this.indexedRules = new LinkedHashMap<Integer, Rule>();
        this.termVisitor = new TermVisitor(definition.context());
        this.buildIndex();
    }

    @Override
    public void buildIndex() {
        MultiHashMap<Integer, String> pStringMap = new MultiHashMap<Integer, String>();
        int count = 1;
        for (Rule rule : this.definition.rules()) {
            if (rule.containsAttribute("heat") || rule.containsAttribute("print")) {
                pStringMap.putAll(this.createRulePString(rule, count, RuleType.HEATING));
            } else if (rule.containsAttribute("cool")) {
                pStringMap.putAll(this.createRulePString(rule, count, RuleType.COOLING));
            } else if (rule.containsAttribute("stdout") || rule.containsAttribute("stderr")) {
                pStringMap.putAll(this.createRulePString(rule, count, RuleType.OUT));
            } else if (rule.containsAttribute("stdin")) {
                pStringMap.putAll(this.createRulePString(rule, count, RuleType.IN));
            } else {
                pStringMap.putAll(this.createRulePString(rule, count, RuleType.OTHER));
            }
            this.indexedRules.put(count, rule);
            ++count;
        }
        assert (this.indexedRules.size() == this.definition.rules().size());
        this.trie = new PathIndexTrie();
        for (Integer key : pStringMap.keySet()) {
            ArrayList strings = (ArrayList)pStringMap.get(key);
            for (String string : strings) {
                this.trie.addIndex(this.trie.getRoot(), string.substring(2), key);
            }
        }
    }

    private void printIndices(Map<Integer, Rule> indexedRules, MultiMap<Integer, String> pString) {
        for (Integer n : indexedRules.keySet()) {
            System.out.println("Rule " + n + ": ");
            System.out.println(indexedRules.get(n));
            System.out.println("Rule Attribute:");
            System.out.println(indexedRules.get(n).getAttributes());
            System.out.println("P-Strings: ");
            ArrayList p_strings = (ArrayList)pString.get(n);
            if (p_strings != null) {
                for (int i = 0; i < p_strings.size(); ++i) {
                    System.out.println(i + 1 + ": " + (String)p_strings.get(i));
                }
            }
            System.out.println();
        }
    }

    private MultiMap<Integer, String> createRulePString(Rule rule, int n, RuleType type) {
        RuleVisitor ruleVisitor;
        MultiHashMap<Integer, String> pStrings = new MultiHashMap<Integer, String>();
        ArrayList kCells = new ArrayList();
        switch (type) {
            case COOLING: {
                ruleVisitor = new CoolingRuleVisitor(rule, this.definition.context());
                break;
            }
            case HEATING: {
                ruleVisitor = new HeatingRuleVisitor(this.definition.context());
                break;
            }
            case OTHER: {
                ruleVisitor = new RuleVisitor(this.definition.context());
                break;
            }
            case OUT: {
                pStrings.put(n, "@.out");
                this.outputRuleIndices.add(n);
                return pStrings;
            }
            case IN: {
                pStrings.put(n, "@.in");
                this.inputRuleIndices.add(n);
                return pStrings;
            }
            default: {
                throw new IllegalArgumentException("Cannot create P-String for unknown rule type:" + (Object)((Object)type));
            }
        }
        rule.accept(ruleVisitor);
        pStrings.putAll(n, ruleVisitor.getpStrings());
        return pStrings;
    }

    @Override
    public List<Rule> getRules(Term term) {
        Set<String> pStrings;
        if (K.get_indexing_stats) {
            IndexingStatistics.getPStringFromTermStopWatch.reset();
            IndexingStatistics.getPStringFromTermStopWatch.start();
            pStrings = this.getPStringsFromTerm(term);
            IndexingStatistics.getPStringFromTermStopWatch.stop();
            IndexingStatistics.timesForGettingPStringsFromTerm.add(IndexingStatistics.getPStringFromTermStopWatch.elapsed(TimeUnit.MICROSECONDS));
        } else {
            pStrings = this.getPStringsFromTerm(term);
        }
        LinkedHashSet<Rule> rules = new LinkedHashSet<Rule>();
        Set<Integer> matchingIndices = new LinkedHashSet<Integer>();
        if (K.get_indexing_stats) {
            IndexingStatistics.findMatchingIndicesStopWatch.reset();
            IndexingStatistics.findMatchingIndicesStopWatch.start();
        }
        for (String pString : pStrings) {
            String[] split = pString.split("\\.");
            int i = split.length;
            Set<Integer> currentMatch = this.trie.retrieve(this.trie.getRoot(), pString);
            String subString = pString;
            while (i > 0 && subString.lastIndexOf(46) > 1) {
                subString = pString.substring(0, subString.lastIndexOf(46) - 2);
                Set<Integer> retrievedIndices = this.trie.retrieve(this.trie.getRoot(), subString);
                if (retrievedIndices == null) continue;
                currentMatch.addAll(retrievedIndices);
            }
            if (matchingIndices.isEmpty()) {
                matchingIndices = currentMatch;
                continue;
            }
            matchingIndices.addAll(currentMatch);
        }
        if (this.termVisitor.isAddOutputRules()) {
            matchingIndices.addAll(this.outputRuleIndices);
        }
        if (this.termVisitor.isAddInputRules()) {
            matchingIndices.addAll(this.inputRuleIndices);
        }
        if (matchingIndices != null) {
            for (Integer n : matchingIndices) {
                rules.add(this.indexedRules.get(n));
            }
        }
        if (K.get_indexing_stats) {
            IndexingStatistics.findMatchingIndicesStopWatch.stop();
            IndexingStatistics.timesForFindingMatchingIndices.add(IndexingStatistics.findMatchingIndicesStopWatch.elapsed(TimeUnit.MICROSECONDS));
        }
        return new ArrayList<Rule>(rules);
    }

    private Set<String> getPStringsFromTerm(Term term) {
        this.termVisitor = new TermVisitor(this.definition.context());
        term.accept(this.termVisitor);
        return this.termVisitor.getpStrings();
    }

    public static enum RuleType {
        COOLING,
        HEATING,
        OUT,
        IN,
        OTHER;

    }
}

