/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.indexing.pathIndex.trie;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.kframework.backend.java.indexing.pathIndex.trie.Trie;
import org.kframework.backend.java.indexing.pathIndex.trie.TrieLeaf;
import org.kframework.backend.java.indexing.pathIndex.trie.TrieNode;

public class PathIndexTrie
implements Trie,
Serializable {
    private final TrieNode root = new TrieNode("@");
    private final String delimiter = "\\.";

    @Override
    public void addIndex(TrieNode trieNode, String pString, int value) {
        if (pString.length() == 0) {
            return;
        }
        String[] split = pString.split("\\.");
        ArrayList<String> splitList = new ArrayList<String>(Arrays.asList(split));
        this.add(trieNode, splitList, value);
    }

    private void add(TrieNode trieNode, ArrayList<String> strings, int value) {
        TrieNode node;
        TrieNode newNode;
        if (strings.size() == 0) {
            return;
        }
        String elem = strings.get(0);
        ArrayList<String> splitList1 = new ArrayList<String>(strings.subList(1, strings.size()));
        if (trieNode.getChildren() == null) {
            if (strings.size() == 1) {
                if (trieNode instanceof TrieLeaf) {
                    trieNode.getIndices().add(value);
                    return;
                }
                TrieLeaf leaf = new TrieLeaf(elem, value);
                trieNode.setChildren(new ArrayList<TrieNode>());
                trieNode.getChildren().add(leaf);
                trieNode.getIndices().add(value);
                return;
            }
            newNode = new TrieNode(elem);
            trieNode.setChildren(new ArrayList<TrieNode>());
            trieNode.getChildren().add(newNode);
            trieNode.getIndices().add(value);
            this.add(newNode, splitList1, value);
        }
        if (strings.size() == 1 && trieNode.getChildren() != null && trieNode.inChildren(elem)) {
            node = trieNode.getChild(elem);
            if (node instanceof TrieLeaf && elem.equals(node.getValue())) {
                node.getIndices().add(value);
                trieNode.getIndices().add(value);
                return;
            }
            if (node instanceof TrieLeaf && !elem.equals(node.getValue())) {
                throw new IllegalArgumentException();
            }
            if (!(node instanceof TrieLeaf)) {
                TrieLeaf newNode2 = new TrieLeaf(elem, value);
                newNode2.setChildren(node.getChildren());
                trieNode.getChildren().remove(node);
                trieNode.getIndices().add(value);
                trieNode.getChildren().add(newNode2);
                return;
            }
        }
        if (trieNode.getChildren() != null && trieNode.inChildren(elem)) {
            trieNode.getIndices().add(value);
            node = trieNode.getChild(elem);
            this.add(node, splitList1, value);
        }
        if (trieNode.getChildren() != null && !trieNode.inChildren(elem)) {
            if (strings.size() == 1) {
                trieNode.getIndices().add(value);
                TrieLeaf leaf = new TrieLeaf(elem, value);
                trieNode.getChildren().add(leaf);
                return;
            }
            trieNode.getIndices().add(value);
            newNode = new TrieNode(elem);
            trieNode.getChildren().add(newNode);
            this.add(newNode, splitList1, value);
        }
    }

    @Override
    public Set<Integer> retrieve(TrieNode trieNode, String queryString) {
        String[] split = queryString.split("\\.");
        ArrayList<String> splitList = new ArrayList<String>(Arrays.asList(split));
        ArrayList<String> subList = new ArrayList<String>(splitList.subList(1, splitList.size()));
        return this.retrieveSet(trieNode, subList);
    }

    private Set<Integer> retrieveSet(TrieNode trieNode, ArrayList<String> splitList) {
        if (splitList.size() == 0) {
            return new LinkedHashSet<Integer>();
        }
        String firstString = splitList.get(0);
        ArrayList<String> subList = new ArrayList<String>(splitList.subList(1, splitList.size()));
        TrieNode child = trieNode.getChild(firstString);
        if (child != null) {
            if (trieNode.getValue().equals("@")) {
                if (splitList.size() == 1 && child instanceof TrieLeaf) {
                    return child.getIndices();
                }
                return this.retrieveSet(child, subList);
            }
        } else if (!trieNode.getValue().equals("@")) {
            return trieNode.getIndices();
        }
        if (splitList.size() == 1) {
            if (child != null) {
                return child.getIndices();
            }
            if (!trieNode.getValue().equals("@")) {
                return trieNode.getIndices();
            }
        } else if (splitList.size() > 1) {
            return this.retrieveSet(child, subList);
        }
        return null;
    }

    @Override
    public boolean isMember(TrieNode trieNode, String queryString) {
        boolean isMember = false;
        if (trieNode == null || queryString.length() == 0) {
            return false;
        }
        return isMember;
    }

    public String toString() {
        return this.print(this.root);
    }

    private String print(TrieNode root) {
        StringBuilder tree = new StringBuilder(root.toString());
        if (root.getChildren() == null) {
            return tree.append("").toString();
        }
        for (TrieNode node : root.getChildren()) {
            tree.append(this.print(node));
        }
        return tree.toString();
    }

    @Override
    public TrieNode getRoot() {
        return this.root;
    }
}

