/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.indexing.pathIndex.trie;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;

public class TrieNode
implements Serializable {
    private final String value;
    private ArrayList<TrieNode> children;
    private final Set<Integer> indices;

    public TrieNode(String value) {
        this.value = value;
        this.indices = new LinkedHashSet<Integer>();
    }

    public boolean inChildren(String value) {
        boolean contained = false;
        for (TrieNode node : this.getChildren()) {
            if (!node.getValue().equals(value)) continue;
            contained = true;
            break;
        }
        return contained;
    }

    public TrieNode getChild(String value) {
        TrieNode child = null;
        for (TrieNode node : this.getChildren()) {
            if (!node.getValue().equals(value)) continue;
            child = node;
        }
        return child;
    }

    public String getValue() {
        return this.value;
    }

    public ArrayList<TrieNode> getChildren() {
        return this.children;
    }

    public void setChildren(ArrayList<TrieNode> children) {
        this.children = children;
    }

    public Set<Integer> getIndices() {
        return this.indices;
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrieNode trieNode = (TrieNode)o;
        if (this.children != null ? !this.children.equals(trieNode.children) : trieNode.children != null) {
            return false;
        }
        return this.value.equals(trieNode.value);
    }

    public int hashCode() {
        int result = this.value.hashCode();
        result = 31 * result + (this.children != null ? this.children.hashCode() : 0);
        return result;
    }
}

