/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.indexing.pathIndex.visitors;

import java.util.ArrayList;
import org.kframework.backend.java.indexing.pathIndex.visitors.RuleVisitor;
import org.kframework.backend.java.kil.Hole;
import org.kframework.backend.java.kil.KItem;
import org.kframework.backend.java.kil.KLabelConstant;
import org.kframework.backend.java.kil.KLabelFreezer;
import org.kframework.backend.java.kil.KList;
import org.kframework.backend.java.kil.KSequence;
import org.kframework.backend.java.kil.Rule;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.kil.Variable;
import org.kframework.kil.Production;
import org.kframework.kil.loader.Context;

public class CoolingRuleVisitor
extends RuleVisitor {
    private static final String K_RESULT_STRING = "KResult";
    private final Rule rule;
    private String currentLabel;
    private boolean isKItemHead = false;
    private static final String USER_LIST_REPLACEMENT = "UserList";

    public CoolingRuleVisitor(Rule rule, Context context) {
        super(context);
        this.rule = rule;
    }

    @Override
    public void visit(KSequence kSequence) {
        Term term = kSequence.get(0);
        if (term instanceof KItem) {
            this.isKItemHead = true;
        }
        term.accept(this);
        ((KItem)kSequence.get(1)).kLabel().accept(this);
    }

    @Override
    public void visit(Variable variable) {
        String requiredKResult = this.getRequiresKResultString(variable);
        if (!this.rule.requires().toString().contains(requiredKResult)) {
            throw new IllegalStateException("First term in K cell is not a K result: \n" + this.rule);
        }
        String firstSort = K_RESULT_STRING;
        this.pString = this.pString.concat(firstSort + ".1.");
    }

    @Override
    public void visit(KLabelFreezer kLabelFreezer) {
        kLabelFreezer.term().accept(this);
    }

    @Override
    public void visit(KItem kItem) {
        this.visit((KLabelConstant)kItem.kLabel());
        if (this.isKItemHead) {
            Term term = ((KList)kItem.kList()).get(0);
            if (term instanceof Variable) {
                String requiredKResult = this.getRequiresKResultString(term);
                if (!this.rule.requires().toString().contains(requiredKResult)) {
                    throw new IllegalStateException("First term in K cell is not a K result: \n" + this.rule);
                }
                String firstSort = K_RESULT_STRING;
                this.pStrings.add(this.pString + "1" + "." + firstSort);
            }
        } else {
            this.visit((KList)kItem.kList());
        }
        this.proceed = false;
    }

    private String getRequiresKResultString(Term term) {
        return "isKResult(" + term + ")";
    }

    @Override
    public void visit(KLabelConstant kLabel) {
        this.currentLabel = kLabel.toString();
        this.pString = this.pString.concat(kLabel.toString() + ".");
    }

    @Override
    public void visit(KList kList) {
        for (int i = 0; i < kList.size(); ++i) {
            Term frozenTerm = kList.get(i);
            if (frozenTerm instanceof Hole) {
                this.pStrings.add(this.pString + (i + 1) + ".HOLE");
                continue;
            }
            ArrayList productions = (ArrayList)this.context.productionsOf(this.currentLabel);
            Production p = (Production)productions.get(0);
            if (productions.size() == 1) {
                this.pStrings.add(this.pString + (i + 1) + "." + p.getChildSort(0));
                continue;
            }
            this.pStrings.add(this.pString + (i + 1) + "." + USER_LIST_REPLACEMENT);
        }
    }
}

