/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.indexing.pathIndex.visitors;

import java.util.ArrayList;
import java.util.List;
import org.kframework.backend.java.builtins.BoolToken;
import org.kframework.backend.java.builtins.UninterpretedToken;
import org.kframework.backend.java.kil.Cell;
import org.kframework.backend.java.kil.KItem;
import org.kframework.backend.java.kil.KLabelConstant;
import org.kframework.backend.java.kil.KList;
import org.kframework.backend.java.kil.KSequence;
import org.kframework.backend.java.kil.Kind;
import org.kframework.backend.java.kil.Rule;
import org.kframework.backend.java.kil.Variable;
import org.kframework.backend.java.symbolic.LocalVisitor;
import org.kframework.backend.java.util.LookupCell;
import org.kframework.kil.loader.Context;

public class RuleVisitor
extends LocalVisitor {
    static final String SEPARATOR = ".";
    static final String START_STRING = "@.";
    private static final String EMPTY_K = "EMPTY_K";
    private static final String K_CELL_NAME = "k";
    final Context context;
    String pString;
    final List<String> pStrings;
    private boolean isKSequence = false;

    public RuleVisitor(Context context) {
        this.context = context;
        this.pString = START_STRING;
        this.pStrings = new ArrayList<String>();
    }

    @Override
    public void visit(Rule rule) {
        this.visit(LookupCell.find(rule.leftHandSide(), K_CELL_NAME));
    }

    @Override
    public void visit(Cell cell) {
        if (cell.getLabel().equals(K_CELL_NAME)) {
            cell.getContent().accept(this);
        } else if (cell.contentKind() == Kind.CELL_COLLECTION) {
            super.visit(cell);
        }
    }

    @Override
    public void visit(KSequence kSequence) {
        this.isKSequence = true;
        if (kSequence.size() > 0) {
            kSequence.get(0).accept(this);
        } else if (kSequence.size() == 0) {
            this.pStrings.add("@.EMPTY_K");
        }
    }

    @Override
    public void visit(KItem kItem) {
        kItem.kLabel().accept(this);
        this.visit((KList)kItem.kList());
    }

    @Override
    public void visit(KLabelConstant kLabel) {
        this.pString = this.pString.concat(kLabel.toString());
    }

    @Override
    public void visit(KList kList) {
        String base = this.pString;
        if (kList.size() == 0) {
            this.pStrings.add(this.pString);
        }
        for (int i = 0; i < kList.size(); ++i) {
            int position = i + 1;
            if (!this.isKSequence) {
                String pending = this.pString + SEPARATOR + position;
                if (kList.get(i) instanceof KItem) {
                    this.pStrings.add(pending + SEPARATOR + ((KItem)kList.get(i)).sort());
                    continue;
                }
                this.pStrings.add(pending + SEPARATOR + ((Variable)kList.get(i)).sort());
                continue;
            }
            this.pString = base + SEPARATOR + position + SEPARATOR;
            kList.get(i).accept(this);
        }
    }

    @Override
    public void visit(Variable variable) {
        this.pStrings.add(this.pString + variable.sort());
    }

    @Override
    public void visit(UninterpretedToken uninterpretedToken) {
        this.pStrings.add(this.pString + uninterpretedToken.sort());
    }

    @Override
    public void visit(BoolToken boolToken) {
        this.pStrings.add(this.pString + boolToken.sort());
    }

    public List<String> getpStrings() {
        return this.pStrings;
    }
}

