/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.indexing.pathIndex.visitors;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.kframework.backend.java.builtins.UninterpretedToken;
import org.kframework.backend.java.indexing.pathIndex.visitors.CellVisitor;
import org.kframework.backend.java.indexing.pathIndex.visitors.OutPutCellVisitor;
import org.kframework.backend.java.kil.BuiltinList;
import org.kframework.backend.java.kil.BuiltinMap;
import org.kframework.backend.java.kil.Cell;
import org.kframework.backend.java.kil.Hole;
import org.kframework.backend.java.kil.KItem;
import org.kframework.backend.java.kil.KLabelConstant;
import org.kframework.backend.java.kil.KLabelFreezer;
import org.kframework.backend.java.kil.KList;
import org.kframework.backend.java.kil.KSequence;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.kil.Token;
import org.kframework.backend.java.symbolic.LocalVisitor;
import org.kframework.kil.Production;
import org.kframework.kil.loader.Context;
import org.kframework.krun.K;
import org.kframework.utils.general.IndexingStatistics;

public class TermVisitor
extends LocalVisitor
implements Serializable {
    private static final String K_RESULT = "KResult";
    private static final String EMPTY_LIST_LABEL = "'.List{\",\"}";
    private static final String EMPTY_LIST_SORT = "#ListOf#Bot{\",\"}";
    private static final String LIST_LABEL = "List{\",\"}";
    private static final String USER_LIST_REPLACEMENT = "UserList";
    private static final String K_ITEM_SORT = "KItem";
    private static final String EMPTY_K = "EMPTY_K";
    private static final String K_STRING = "K";
    private final Set<String> pStrings = new LinkedHashSet<String>();
    private final Context context;
    private String pString;
    private int currentPosition = 0;
    private boolean inner = false;
    private String currentLabel;
    private final String SEPARATOR = ".";
    private final String START_STRING = "@.";
    private boolean addInputRules;
    private boolean addOutputRules;

    public TermVisitor(Context context) {
        this.context = context;
    }

    @Override
    public void visit(Term node) {
        Cell cellOfInterest;
        List<Term> ioCellList;
        int BASE_IO_CELL_SIZE = 2;
        if (K.get_indexing_stats) {
            IndexingStatistics.getPStringStopwatch.reset();
            IndexingStatistics.getPStringStopwatch.start();
        }
        CellVisitor v = new CellVisitor(this.context);
        node.accept(v);
        this.pStrings.addAll(v.getkCellPStings());
        if (K.get_indexing_stats) {
            IndexingStatistics.getPStringStopwatch.stop();
            IndexingStatistics.getPStringTimes.add(IndexingStatistics.getPStringStopwatch.elapsed(TimeUnit.MICROSECONDS));
        }
        if (K.get_indexing_stats) {
            IndexingStatistics.traverseCellsStopwatch.reset();
            IndexingStatistics.traverseCellsStopwatch.start();
        }
        if (v.getOutCell() != null) {
            Cell ioCell = v.getOutCell();
            ioCellList = ((BuiltinList)ioCell.getContent()).elements();
            if (ioCellList.size() > BASE_IO_CELL_SIZE) {
                this.addOutputRules = true;
            } else {
                OutPutCellVisitor outPutCellVisitor = new OutPutCellVisitor();
                ioCell.getContent().accept(outPutCellVisitor);
                if (outPutCellVisitor.isAddOutCell()) {
                    this.addOutputRules = true;
                }
            }
        }
        if ((cellOfInterest = v.getInCell()) != null && (ioCellList = ((BuiltinList)cellOfInterest.getContent()).elements()).size() > BASE_IO_CELL_SIZE) {
            this.addInputRules = true;
        }
        if (K.get_indexing_stats) {
            IndexingStatistics.traverseCellsStopwatch.stop();
            IndexingStatistics.traverseCellsTimes.add(IndexingStatistics.traverseCellsStopwatch.elapsed(TimeUnit.MICROSECONDS));
        }
    }

    @Override
    public void visit(KSequence kSequence) {
        if (kSequence.size() > 0) {
            if (kSequence.get(0) instanceof KItem) {
                boolean isKResult = this.context.isSubsorted(K_RESULT, ((KItem)kSequence.get(0)).sort());
                if (isKResult) {
                    this.pString = "@.KResult";
                    kSequence.get(1).accept(this);
                } else {
                    kSequence.get(0).accept(this);
                    if (kSequence.get(0) instanceof Token) {
                        kSequence.get(1).accept(this);
                    }
                }
            } else {
                kSequence.get(0).accept(this);
                if (kSequence.get(0) instanceof Token) {
                    kSequence.get(1).accept(this);
                }
            }
        } else if (kSequence.size() == 0) {
            this.pStrings.add("@.EMPTY_K");
        }
    }

    @Override
    public void visit(Token token) {
        if (this.pString == null) {
            if (this.context.isSubsorted(K_RESULT, token.sort())) {
                this.pString = "@.KResult";
            } else {
                this.pStrings.add("@." + token.sort());
            }
        }
        if (this.inner) {
            List<Production> productions1 = this.context.productionsOf(this.currentLabel);
            if (productions1.isEmpty()) {
                return;
            }
            if (this.context.isSubsorted(K_RESULT, token.sort())) {
                if (this.pString != null) {
                    ArrayList productions = (ArrayList)productions1;
                    if (productions.size() == 1) {
                        this.pStrings.add(this.pString + "." + this.currentPosition + "." + token.sort());
                    } else {
                        this.pStrings.add(this.pString + "." + this.currentPosition + "." + USER_LIST_REPLACEMENT);
                    }
                }
            } else {
                ArrayList productions = (ArrayList)productions1;
                Production p = (Production)productions.get(0);
                if (productions.size() == 1) {
                    this.pStrings.add(this.pString + "." + this.currentPosition + "." + p.getChildSort(0));
                } else {
                    this.pStrings.add(this.pString + "." + this.currentPosition + "." + USER_LIST_REPLACEMENT);
                }
            }
        }
    }

    @Override
    public void visit(UninterpretedToken uninterpretedToken) {
        if (this.pString == null) {
            this.pStrings.add("@." + uninterpretedToken.sort());
        } else {
            this.pStrings.add(this.pString + "." + this.currentPosition + "." + uninterpretedToken.sort());
        }
    }

    @Override
    public void visit(KItem kItem) {
        if (kItem.kLabel() instanceof KLabelFreezer) {
            if (this.pString != null) {
                TokenVisitor visitor = new TokenVisitor(this.context, this.pString);
                kItem.kLabel().accept(visitor);
                this.pStrings.addAll(visitor.getCandidates());
            }
        } else if (!this.inner) {
            this.inner = true;
            this.currentLabel = kItem.kLabel().toString();
            kItem.kLabel().accept(this);
            kItem.kList().accept(this);
        } else {
            int kListSize = ((KList)kItem.kList()).size();
            if (kListSize == 0 && this.currentLabel.equals(LIST_LABEL)) {
                this.pStrings.add(this.pString + "." + this.currentPosition + "." + EMPTY_LIST_LABEL);
            } else if (kListSize == 0 && kItem.sort().equals(EMPTY_LIST_SORT)) {
                this.pStrings.add(this.pString + "." + this.currentPosition + "." + EMPTY_LIST_LABEL);
            } else if (this.context.isListSort(kItem.sort())) {
                this.pStrings.add(this.pString + "." + this.currentPosition + "." + USER_LIST_REPLACEMENT);
            } else if (kListSize > 0 && ((KList)kItem.kList()).get(0) instanceof Token) {
                String sort = ((Token)((KList)kItem.kList()).get(0)).sort();
                if (this.context.isSubsorted(K_RESULT, sort)) {
                    if (kItem.sort().equals(K_ITEM_SORT)) {
                        this.pStrings.add(this.pString + "." + this.currentPosition + "." + kItem.kLabel() + "." + this.currentPosition + "." + sort);
                    } else {
                        this.pStrings.add(this.pString + "." + this.currentPosition + "." + K_RESULT);
                    }
                } else {
                    ArrayList productions = (ArrayList)this.context.productionsOf(this.currentLabel);
                    Production p = (Production)productions.get(0);
                    String test2 = this.pString + "." + this.currentPosition + ".";
                    if (p.getChildSort(this.currentPosition - 1).equals(K_STRING)) {
                        this.pStrings.add(test2 + kItem.kLabel() + "." + "1.Exp");
                    } else {
                        this.pStrings.add(test2 + p.getChildSort(this.currentPosition - 1));
                    }
                }
            } else {
                String test3 = this.pString + "." + this.currentPosition + ".";
                ArrayList productions = (ArrayList)this.context.productionsOf(this.currentLabel);
                Production p = (Production)productions.get(0);
                if (p.getChildSort(this.currentPosition - 1).equals(K_STRING)) {
                    this.pStrings.add(test3 + kItem.kLabel() + "." + this.currentPosition + "." + kItem.sort());
                } else {
                    this.pStrings.add(test3 + kItem.sort());
                }
            }
        }
    }

    @Override
    public void visit(KList kList) {
        if (kList.size() == 0) {
            this.pStrings.add(this.pString);
        } else {
            for (int i = 0; i < kList.size(); ++i) {
                this.currentPosition = i + 1;
                kList.get(i).accept(this);
            }
        }
    }

    @Override
    public void visit(KLabelConstant kLabel) {
        this.pString = "@." + kLabel.toString();
    }

    @Override
    public void visit(BuiltinMap builtinMap) {
        this.pStrings.add(this.pString + "." + this.currentPosition + "." + builtinMap.sort());
    }

    public Set<String> getpStrings() {
        return this.pStrings;
    }

    public boolean isAddInputRules() {
        return this.addInputRules;
    }

    public boolean isAddOutputRules() {
        return this.addOutputRules;
    }

    private class TokenVisitor
    extends TermVisitor {
        private final String baseString;
        private String pString;
        private final List<String> candidates;

        public TokenVisitor(Context context, String string) {
            super(context);
            this.baseString = string;
            this.candidates = new ArrayList<String>();
        }

        @Override
        public void visit(KLabelFreezer kLabelFreezer) {
            KItem frozenItem = (KItem)kLabelFreezer.term();
            frozenItem.kLabel().accept(this);
            frozenItem.kList().accept(this);
        }

        @Override
        public void visit(KLabelConstant kLabel) {
            this.pString = this.baseString + ".1." + kLabel.toString();
        }

        @Override
        public void visit(UninterpretedToken uninterpretedToken) {
            this.candidates.add(this.pString + "." + TermVisitor.this.currentPosition + "." + uninterpretedToken.sort());
        }

        @Override
        public void visit(KList kList) {
            for (int i = 0; i < kList.size(); ++i) {
                TermVisitor.this.currentPosition = i + 1;
                kList.get(i).accept(this);
            }
        }

        @Override
        public void visit(Hole hole) {
            this.candidates.add(this.pString + "." + TermVisitor.this.currentPosition + ".HOLE");
        }

        @Override
        public void visit(Token token) {
            this.candidates.add(this.pString + "." + TermVisitor.this.currentPosition + "." + token.sort());
        }

        @Override
        public void visit(KItem kItem) {
            this.candidates.add(this.pString + "." + TermVisitor.this.currentPosition + "." + kItem.sort());
        }

        private List<String> getCandidates() {
            return this.candidates;
        }
    }
}

