/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.kil;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SequencedCollection;
import org.kframework.backend.java.builtins.IntToken;
import org.kframework.backend.java.kil.Bottom;
import org.kframework.backend.java.kil.Collection;
import org.kframework.backend.java.kil.Kind;
import org.kframework.backend.java.kil.ListLookup;
import org.kframework.backend.java.kil.Sorted;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.kil.Variable;
import org.kframework.backend.java.symbolic.Matcher;
import org.kframework.backend.java.symbolic.Transformer;
import org.kframework.backend.java.symbolic.Unifier;
import org.kframework.backend.java.symbolic.Visitor;
import org.kframework.backend.java.util.ImprovedArrayDeque;
import org.kframework.kil.ASTNode;

public class BuiltinList
extends Collection
implements Sorted {
    private final ImprovedArrayDeque<Term> elementsLeft;
    protected final ImprovedArrayDeque<Term> elementsRight;
    protected final int removeLeft;
    protected final int removeRight;

    public BuiltinList(java.util.Collection<Term> elements) {
        this(null, 0, 0, elements, Collections.emptyList());
    }

    public BuiltinList(Variable frame, int removeLeft, int removeRight, java.util.Collection<Term> elementsLeft, java.util.Collection<Term> elementsRight) {
        super(frame, Kind.KITEM);
        this.elementsLeft = new ImprovedArrayDeque<Term>(elementsLeft);
        if (frame == null) {
            assert (removeLeft == 0 && removeRight == 0) : "cannot remove from an empty base";
            this.elementsLeft.addAll(elementsRight);
            this.elementsRight = new ImprovedArrayDeque();
        } else {
            this.elementsRight = new ImprovedArrayDeque<Term>(elementsRight);
        }
        this.removeLeft = removeLeft;
        this.removeRight = removeRight;
    }

    public BuiltinList(Variable frame) {
        this(frame, 0, 0, Collections.emptyList(), Collections.emptyList());
    }

    public BuiltinList() {
        this(null, 0, 0, Collections.emptyList(), Collections.emptyList());
    }

    public boolean contains(Term key) {
        return this.elementsLeft.contains(key) || this.elementsRight.contains(key);
    }

    public void add(Term element) {
        this.addRight(element);
    }

    public void addRight(Term element) {
        this.elementsRight.add(element);
    }

    public void addLeft(Term element) {
        this.elementsLeft.addFirst(element);
    }

    public List<Term> elements() {
        ArrayList<Term> elements = new ArrayList<Term>(this.elementsLeft);
        elements.addAll(this.elementsRight);
        return Collections.unmodifiableList(elements);
    }

    @Override
    public int size() {
        return this.elementsLeft.size() + this.elementsRight.size();
    }

    @Override
    public String sort() {
        return "MyList";
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BuiltinList)) {
            return false;
        }
        BuiltinList list = (BuiltinList)object;
        return (this.frame == null ? list.frame == null : this.frame.equals(list.frame)) && this.removeLeft == list.removeLeft && this.removeRight == list.removeRight && this.elementsLeft.equals(list.elementsLeft) && this.elementsRight.equals(list.elementsRight);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 1;
            this.hashCode = this.hashCode * 47 + (this.frame == null ? 0 : this.frame.hashCode());
            this.hashCode = this.hashCode * 47 + this.removeLeft;
            this.hashCode = this.hashCode * 47 + this.removeRight;
            this.hashCode = this.hashCode * 47 + this.elementsLeft.hashCode();
            this.hashCode = this.hashCode * 47 + this.elementsRight.hashCode();
        }
        return this.hashCode;
    }

    @Override
    public void accept(Unifier unifier, Term pattern) {
        unifier.unify(this, pattern);
    }

    @Override
    public void accept(Matcher matcher, Term pattern) {
        matcher.match(this, pattern);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ASTNode accept(Transformer transformer) {
        return transformer.transform(this);
    }

    public Term get(int index) {
        boolean onLeft = true;
        ImprovedArrayDeque<Term> elements = this.elementsLeft;
        Iterator iterator = elements.iterator();
        if (this.frame == null) {
            if (!this.elementsRight.isEmpty()) {
                this.elementsLeft.addAll(this.elementsRight);
                this.elementsRight.clear();
            }
        } else if (index < 0) {
            onLeft = false;
            elements = this.elementsRight;
        }
        if (index < 0) {
            iterator = elements.descendingIterator();
            index = -index - 1;
        }
        if (index < elements.size()) {
            while (index-- > 0) {
                iterator.next();
            }
            return (Term)iterator.next();
        }
        if (this.frame == null) {
            return new Bottom(Kind.K);
        }
        SequencedCollection<Term> left = this.elementsLeft;
        SequencedCollection<Term> right = this.elementsRight;
        if (onLeft) {
            index -= this.elementsLeft.size();
            left = Collections.emptyList();
        } else {
            index -= this.elementsRight.size();
            index = -index - 1;
            right = Collections.emptyList();
        }
        return new ListLookup(BuiltinList.of(this.frame, this.removeLeft, this.removeRight, left, right), IntToken.of(index), Kind.K);
    }

    public java.util.Collection<Term> elementsLeft() {
        return Collections.unmodifiableCollection(this.elementsLeft);
    }

    public java.util.Collection<Term> elementsRight() {
        return Collections.unmodifiableCollection(this.elementsRight);
    }

    public String toString() {
        return this.toString(" ", ".List");
    }

    public String toString(String operator, String identity) {
        Joiner joiner = Joiner.on(operator);
        StringBuilder stringBuilder = new StringBuilder();
        joiner.appendTo(stringBuilder, (Iterable<?>)this.elementsLeft);
        if (this.frame != null) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(operator);
            }
            if (this.removeLeft != 0 || this.removeRight != 0) {
                stringBuilder.append("remove(" + this.removeLeft + ", ");
            }
            stringBuilder.append(this.frame);
            if (this.removeLeft != 0 || this.removeRight != 0) {
                stringBuilder.append(", " + this.removeRight + ")");
            }
        }
        joiner.appendTo(stringBuilder, (Iterable<?>)this.elementsRight);
        if (stringBuilder.length() == 0) {
            stringBuilder.append(identity);
        }
        return stringBuilder.toString();
    }

    public static BuiltinList of(Term frame, int removeLeft, int removeRight, java.util.Collection<Term> elementsLeft, java.util.Collection<Term> elementsRight) {
        if (frame instanceof BuiltinList) {
            BuiltinList builtinList = (BuiltinList)frame;
            if (!builtinList.hasFrame()) {
                assert (builtinList.elementsRight.isEmpty());
                assert (builtinList.elementsLeft().size() >= removeLeft + removeRight);
                if (builtinList.elementsLeft().size() > removeLeft + removeRight) {
                    Iterator iterator = builtinList.elementsLeft.iterator();
                    int deleted = removeLeft + removeRight;
                    while (removeLeft > 0) {
                        --removeLeft;
                        iterator.next();
                    }
                    for (int i = deleted; i < builtinList.elementsLeft.size(); ++i) {
                        elementsLeft.add((Term)iterator.next());
                    }
                }
                frame = null;
                removeLeft = 0;
                removeRight = 0;
            } else {
                Iterator<Term> iterator = builtinList.elementsLeft().iterator();
                while (removeLeft > 0 && iterator.hasNext()) {
                    --removeLeft;
                    iterator.next();
                }
                while (iterator.hasNext()) {
                    elementsLeft.add(iterator.next());
                }
                removeLeft += builtinList.removeLeft;
                ArrayList<Term> right = new ArrayList<Term>();
                iterator = builtinList.elementsRight.iterator();
                int size = builtinList.elementsRight.size();
                for (int i = removeRight; i < size; ++i) {
                    right.add(iterator.next());
                }
                right.addAll(elementsRight);
                removeRight = removeRight > size ? (removeRight -= size) : 0;
                right.addAll(elementsRight);
                return new BuiltinList(builtinList.frame, removeLeft, removeRight += builtinList.removeRight, elementsLeft, right);
            }
        }
        if (frame == null) {
            assert (removeLeft == 0 && removeRight == 0) : "cannot remove from an empty list";
            elementsLeft.addAll(elementsRight);
            return new BuiltinList(null, 0, 0, elementsLeft, Collections.emptyList());
        }
        if (frame instanceof Variable) {
            return new BuiltinList((Variable)frame, removeLeft, removeRight, elementsLeft, elementsRight);
        }
        assert (false) : "Frame can only be substituted by a Variable or a BuiltinList, or deleted.";
        return null;
    }

    public int removeLeft() {
        return this.removeLeft;
    }

    public int removeRight() {
        return this.removeRight;
    }
}

