/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.kil;

import com.google.common.base.Joiner;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.kframework.backend.java.kil.Collection;
import org.kframework.backend.java.kil.Kind;
import org.kframework.backend.java.kil.Sorted;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.kil.Variable;
import org.kframework.backend.java.symbolic.Matcher;
import org.kframework.backend.java.symbolic.Transformer;
import org.kframework.backend.java.symbolic.Unifier;
import org.kframework.backend.java.symbolic.Visitor;
import org.kframework.kil.ASTNode;

public class BuiltinMap
extends Collection
implements Sorted {
    private final Map<Term, Term> entries;

    public BuiltinMap(Map<? extends Term, ? extends Term> entries, Variable frame) {
        super(frame, Kind.KITEM);
        this.entries = new HashMap<Term, Term>(entries);
    }

    public BuiltinMap(Variable frame) {
        super(frame, Kind.KITEM);
        this.entries = new HashMap<Term, Term>();
    }

    public BuiltinMap(Map<? extends Term, ? extends Term> entries) {
        super(null, Kind.KITEM);
        this.entries = new HashMap<Term, Term>(entries);
    }

    public BuiltinMap() {
        super(null, Kind.KITEM);
        this.entries = new HashMap<Term, Term>();
    }

    public Term get(Term key) {
        return this.entries.get(key);
    }

    public Map<Term, Term> getEntries() {
        return Collections.unmodifiableMap(this.entries);
    }

    public Term put(Term key, Term value) {
        return this.entries.put(key, value);
    }

    public void putAll(Map<Term, Term> entries) {
        this.entries.putAll(entries);
    }

    public Term remove(Term key) {
        return this.entries.remove(key);
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public String sort() {
        return "MyMap";
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BuiltinMap)) {
            return false;
        }
        BuiltinMap map = (BuiltinMap)object;
        return (this.frame == null ? map.frame == null : this.frame.equals(map.frame)) && this.entries.equals(map.entries);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 1;
            this.hashCode = this.hashCode * 47 + (this.frame == null ? 0 : this.frame.hashCode());
            this.hashCode = this.hashCode * 47 + this.entries.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        return this.toString(" ", " |-> ", "'.MyMap");
    }

    private String toString(String operator, String mapsTo, String identity) {
        Joiner.MapJoiner joiner = Joiner.on(operator).withKeyValueSeparator(mapsTo);
        StringBuilder stringBuilder = new StringBuilder();
        joiner.appendTo(stringBuilder, this.entries);
        if (super.hasFrame()) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(operator);
            }
            stringBuilder.append(super.frame());
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append(identity);
        }
        return stringBuilder.toString();
    }

    @Override
    public void accept(Unifier unifier, Term pattern) {
        unifier.unify(this, pattern);
    }

    @Override
    public void accept(Matcher matcher, Term pattern) {
        matcher.match(this, pattern);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ASTNode accept(Transformer transformer) {
        return transformer.transform(this);
    }

    public static BuiltinMap of(Map<? extends Term, ? extends Term> entries, Term frame) {
        if (frame == null) {
            return new BuiltinMap(entries);
        }
        if (frame instanceof Variable) {
            return new BuiltinMap(entries, (Variable)frame);
        }
        if (frame instanceof BuiltinMap) {
            BuiltinMap builtinMap = (BuiltinMap)frame;
            builtinMap = new BuiltinMap(builtinMap.entries, builtinMap.frame);
            builtinMap.entries.putAll(entries);
            return builtinMap;
        }
        assert (false) : "Frame can only be substituted by a Variable or a BuiltinMap, or deleted.";
        return null;
    }
}

