/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.kil;

import com.google.common.base.Joiner;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.kframework.backend.java.kil.Collection;
import org.kframework.backend.java.kil.Kind;
import org.kframework.backend.java.kil.Sorted;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.kil.Variable;
import org.kframework.backend.java.symbolic.Matcher;
import org.kframework.backend.java.symbolic.Transformer;
import org.kframework.backend.java.symbolic.Unifier;
import org.kframework.backend.java.symbolic.Visitor;
import org.kframework.kil.ASTNode;

public class BuiltinSet
extends Collection
implements Sorted {
    private final Set<Term> elements;

    public BuiltinSet(Set<? extends Term> elements) {
        this(elements, null);
    }

    public BuiltinSet(Set<? extends Term> elements, Variable frame) {
        super(frame, Kind.KITEM);
        this.elements = new HashSet<Term>(elements);
    }

    public BuiltinSet(Variable frame) {
        super(frame, Kind.KITEM);
        this.elements = new HashSet<Term>();
    }

    public BuiltinSet() {
        super(null, Kind.KITEM);
        this.elements = new HashSet<Term>();
    }

    public boolean contains(Term key) {
        return this.elements.contains(key);
    }

    public void add(Term element) {
        this.elements.add(element);
    }

    public Set<Term> elements() {
        return Collections.unmodifiableSet(this.elements);
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public String sort() {
        return "MySet";
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BuiltinSet)) {
            return false;
        }
        BuiltinSet set = (BuiltinSet)object;
        return (this.frame == null ? set.frame == null : this.frame.equals(set.frame)) && this.elements.equals(set.elements);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 1;
            this.hashCode = this.hashCode * 47 + (this.frame == null ? 0 : this.frame.hashCode());
            this.hashCode = this.hashCode * 47 + this.elements.hashCode();
        }
        return this.hashCode;
    }

    @Override
    public void accept(Unifier unifier, Term pattern) {
        unifier.unify(this, pattern);
    }

    @Override
    public void accept(Matcher matcher, Term pattern) {
        matcher.match(this, pattern);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ASTNode accept(Transformer transformer) {
        return transformer.transform(this);
    }

    public String toString() {
        return this.toString(" ", ".Set");
    }

    public String toString(String operator, String identity) {
        Joiner joiner = Joiner.on(operator);
        StringBuilder stringBuilder = new StringBuilder();
        joiner.appendTo(stringBuilder, (Iterable<?>)this.elements);
        if (this.frame != null) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(operator);
            }
            stringBuilder.append(this.frame);
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append(identity);
        }
        return stringBuilder.toString();
    }

    public static BuiltinSet of(Set<Term> elements, Term frame) {
        if (frame == null) {
            return new BuiltinSet(elements);
        }
        if (frame instanceof Variable) {
            return new BuiltinSet(elements, (Variable)frame);
        }
        if (frame instanceof BuiltinSet) {
            BuiltinSet builtinSet = (BuiltinSet)frame;
            builtinSet = new BuiltinSet(builtinSet.elements, builtinSet.frame);
            builtinSet.elements.addAll(elements);
            return builtinSet;
        }
        assert (false) : "Frame can only be substituted by a Variable or a BuiltinSet, or deleted.";
        return null;
    }
}

