/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.kil;

import org.kframework.backend.java.kil.Kind;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.symbolic.Matcher;
import org.kframework.backend.java.symbolic.Transformer;
import org.kframework.backend.java.symbolic.Unifier;
import org.kframework.backend.java.symbolic.Visitor;
import org.kframework.kil.ASTNode;

public class Cell<T extends Term>
extends Term {
    private final String label;
    private final Kind contentKind;
    private final T content;

    public Cell(String label, T content) {
        super(Kind.CELL);
        assert (((Term)content).kind() == Kind.CELL_COLLECTION || ((Term)content).kind == Kind.CELL || ((Term)content).kind() == Kind.K || ((Term)content).kind() == Kind.KITEM || ((Term)content).kind() == Kind.KLABEL || ((Term)content).kind() == Kind.KLIST) : "unexpected cell kind " + (Object)((Object)((Term)content).kind());
        this.label = label;
        this.contentKind = ((Term)content).kind();
        this.content = content;
    }

    public String getLabel() {
        return this.label;
    }

    public Kind contentKind() {
        return this.contentKind;
    }

    public T getContent() {
        return this.content;
    }

    @Override
    public boolean isSymbolic() {
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Cell)) {
            return false;
        }
        Cell cell = (Cell)object;
        return this.label.equals(cell.label) && this.content.equals(cell.content);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 1;
            this.hashCode = this.hashCode * 47 + this.label.hashCode();
            this.hashCode = this.hashCode * 47 + this.content.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        return "<" + this.label + ">" + this.content + "</" + this.label + ">";
    }

    @Override
    public void accept(Unifier unifier, Term pattern) {
        unifier.unify(this, pattern);
    }

    @Override
    public void accept(Matcher matcher, Term pattern) {
        matcher.match(this, pattern);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ASTNode accept(Transformer transformer) {
        return transformer.transform(this);
    }
}

