/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.kil;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Set;
import org.kframework.backend.java.kil.Cell;
import org.kframework.backend.java.kil.Collection;
import org.kframework.backend.java.kil.Kind;
import org.kframework.backend.java.kil.Sorted;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.kil.Variable;
import org.kframework.backend.java.symbolic.Matcher;
import org.kframework.backend.java.symbolic.Transformer;
import org.kframework.backend.java.symbolic.Unifier;
import org.kframework.backend.java.symbolic.Visitor;
import org.kframework.kil.ASTNode;
import org.kframework.kil.loader.Context;

public class CellCollection
extends Collection
implements Sorted {
    private final Multimap<String, Cell> cells;
    private final boolean hasStar;

    public CellCollection(Multimap<String, Cell> cells, Variable frame, Context context) {
        super(frame, Kind.CELL_COLLECTION);
        this.cells = ArrayListMultimap.create(cells);
        int numOfStarredCellTypes = 0;
        for (String cellLabel : cells.keySet()) {
            if (context.getConfigurationStructureMap().get(cellLabel).isStarOrPlus()) {
                ++numOfStarredCellTypes;
                continue;
            }
            assert (cells.get(cellLabel).size() == 1) : "cell label " + cellLabel + " does not have multiplicity='*', " + "but multiple cells found " + cells;
        }
        assert (numOfStarredCellTypes <= 1) : "Multiple types of starred cells in one cell collection not supported at present";
        this.hasStar = numOfStarredCellTypes > 0;
    }

    public CellCollection(Variable frame) {
        this(ArrayListMultimap.create(), frame, null);
    }

    public CellCollection(Multimap<String, Cell> cells, Context context) {
        this(cells, null, context);
    }

    public CellCollection() {
        this(ArrayListMultimap.create(), null, null);
    }

    public java.util.Collection<Cell> cells() {
        return this.cells.values();
    }

    public Multimap<String, Cell> cellMap() {
        return this.cells;
    }

    public boolean containsKey(String label) {
        return this.cells.containsKey(label);
    }

    public java.util.Collection<Cell> get(String label) {
        return this.cells.get(label);
    }

    public boolean hasStar() {
        return this.hasStar;
    }

    public Set<String> labelSet() {
        return this.cells.keySet();
    }

    @Override
    public int size() {
        return this.cells.size();
    }

    @Override
    public String sort() {
        return "Bag";
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CellCollection)) {
            return false;
        }
        CellCollection collection = (CellCollection)object;
        return (this.frame == null ? collection.frame == null : this.frame.equals(collection.frame)) && this.cells.equals(collection.cells);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 1;
            this.hashCode = this.hashCode * 47 + (this.frame == null ? 0 : this.frame.hashCode());
            this.hashCode = this.hashCode * 47 + this.cells.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Cell cell : this.cells.values()) {
            stringBuilder.append(cell);
        }
        if (super.hasFrame()) {
            stringBuilder.append(super.frame());
        }
        return stringBuilder.toString();
    }

    @Override
    public void accept(Unifier unifier, Term pattern) {
        unifier.unify(this, pattern);
    }

    @Override
    public void accept(Matcher matcher, Term pattern) {
        matcher.match(this, pattern);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ASTNode accept(Transformer transformer) {
        return transformer.transform(this);
    }

    public static Term upKind(Term term, Kind kind, Context context) {
        assert (term.kind() == Kind.CELL || term.kind() == Kind.CELL_COLLECTION);
        assert (kind == Kind.CELL || kind == Kind.CELL_COLLECTION);
        if (term.kind() == Kind.CELL && kind == Kind.CELL_COLLECTION && term instanceof Cell) {
            Cell cell = (Cell)term;
            ArrayListMultimap<String, Cell> cells = ArrayListMultimap.create();
            cells.put(cell.getLabel(), cell);
            term = new CellCollection(cells, context);
        }
        return term;
    }

    public static Term downKind(Term term) {
        assert (term.kind() == Kind.CELL || term.kind() == Kind.CELL_COLLECTION);
        if (term instanceof CellCollection && !((CellCollection)term).hasFrame() && ((CellCollection)term).size() == 1) {
            term = ((CellCollection)term).cells().iterator().next();
        }
        return term;
    }
}

