/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.kil;

import org.kframework.backend.java.kil.Collection;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.kil.Variable;

public class ConcreteCollectionVariable
extends Variable {
    private final int concreteSize;

    public ConcreteCollectionVariable(String name, String sort, boolean anonymous, int concreteSize) {
        super(name, sort, anonymous);
        this.concreteSize = concreteSize;
    }

    public ConcreteCollectionVariable(String name, String sort, int concreteSize) {
        this(name, sort, false, concreteSize);
    }

    public int concreteCollectionSize() {
        return this.concreteSize;
    }

    public boolean matchConcreteSize(Term term) {
        if (term instanceof ConcreteCollectionVariable) {
            ConcreteCollectionVariable otherVariable = (ConcreteCollectionVariable)term;
            return this.concreteCollectionSize() == otherVariable.concreteCollectionSize();
        }
        if (term instanceof Collection) {
            Collection collection = (Collection)term;
            return collection.hasFrame() || this.concreteCollectionSize() == collection.size();
        }
        return term instanceof Variable;
    }

    @Override
    public ConcreteCollectionVariable getFreshCopy() {
        return new ConcreteCollectionVariable(Variable.getFreshVariable(this.sort()).name(), this.sort(), true, this.concreteSize);
    }
}

