/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.kil;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kframework.backend.java.kil.BuiltinMap;
import org.kframework.backend.java.kil.Definition;
import org.kframework.backend.java.kil.JavaSymbolicObject;
import org.kframework.backend.java.kil.KItem;
import org.kframework.backend.java.kil.KLabelConstant;
import org.kframework.backend.java.kil.KList;
import org.kframework.backend.java.kil.MapLookup;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.kil.TermContext;
import org.kframework.backend.java.kil.Variable;
import org.kframework.backend.java.symbolic.Matcher;
import org.kframework.backend.java.symbolic.SymbolicConstraint;
import org.kframework.backend.java.symbolic.Transformer;
import org.kframework.backend.java.symbolic.Unifier;
import org.kframework.backend.java.symbolic.UninterpretedConstraint;
import org.kframework.backend.java.symbolic.Visitor;
import org.kframework.backend.java.util.Debug;
import org.kframework.backend.java.util.GroupProductionsBySort;
import org.kframework.kil.ASTNode;
import org.kframework.kil.loader.Context;
import org.kframework.krun.K;

public class ConstrainedTerm
extends Term {
    private static final Map<Definition, GroupProductionsBySort> cachedGroupProductionsBySort = new HashMap<Definition, GroupProductionsBySort>();
    private final Term term;
    private final SymbolicConstraint lookups;
    private final SymbolicConstraint constraint;
    private final TermContext context;

    public ConstrainedTerm(Term term, SymbolicConstraint lookups, SymbolicConstraint constraint, TermContext context) {
        super(term.kind);
        this.term = term;
        this.lookups = lookups;
        this.constraint = constraint;
        this.context = context;
    }

    public ConstrainedTerm(Term term, SymbolicConstraint constraint, TermContext context) {
        this(term, new SymbolicConstraint(context), constraint, context);
    }

    public ConstrainedTerm(Term term, TermContext context) {
        this(term, new SymbolicConstraint(context), new SymbolicConstraint(context), context);
    }

    public TermContext termContext() {
        return this.context;
    }

    public SymbolicConstraint constraint() {
        return this.constraint;
    }

    public boolean implies(ConstrainedTerm constrainedTerm) {
        return this.matchImplies(constrainedTerm) != null;
    }

    public SymbolicConstraint lookups() {
        return this.lookups;
    }

    public SymbolicConstraint matchImplies(ConstrainedTerm constrainedTerm) {
        SymbolicConstraint unificationConstraint = new SymbolicConstraint(constrainedTerm.termContext());
        unificationConstraint.add(this.term, constrainedTerm.term);
        unificationConstraint.simplify();
        Set<Variable> variables = constrainedTerm.variableSet();
        variables.removeAll(this.variableSet());
        unificationConstraint.orientSubstitution(variables);
        if (unificationConstraint.isFalse() || !unificationConstraint.isSubstitution()) {
            return null;
        }
        JavaSymbolicObject implicationConstraint = new SymbolicConstraint(constrainedTerm.termContext());
        implicationConstraint.addAll(unificationConstraint);
        implicationConstraint.addAll(constrainedTerm.lookups);
        implicationConstraint.addAll(constrainedTerm.constraint);
        implicationConstraint.simplify();
        implicationConstraint.orientSubstitution(variables);
        implicationConstraint = implicationConstraint.substituteWithBinders(implicationConstraint.substitution(), this.context);
        unificationConstraint.addAll(this.constraint);
        unificationConstraint.simplify();
        if (!unificationConstraint.implies((SymbolicConstraint)implicationConstraint)) {
            return null;
        }
        unificationConstraint.addAll((SymbolicConstraint)implicationConstraint);
        return unificationConstraint;
    }

    public Term term() {
        return this.term;
    }

    public List<SymbolicConstraint> unify(ConstrainedTerm constrainedTerm) {
        int numOfInvoc = Debug.incDebugMethodCounter();
        if (numOfInvoc == Integer.MAX_VALUE) {
            Debug.setBreakPointHere();
        }
        List<SymbolicConstraint> solutions = this.unifyImpl(constrainedTerm);
        Debug.printUnifyResult(numOfInvoc, this, constrainedTerm, solutions);
        return solutions;
    }

    private List<SymbolicConstraint> unifyImpl(ConstrainedTerm constrainedTerm) {
        if (!this.term.kind.equals((Object)constrainedTerm.term.kind)) {
            return Collections.emptyList();
        }
        SymbolicConstraint unificationConstraint = new SymbolicConstraint(constrainedTerm.termContext());
        unificationConstraint.add(this.term, constrainedTerm.term);
        unificationConstraint.simplify();
        if (unificationConstraint.isFalse()) {
            return Collections.emptyList();
        }
        ArrayList<SymbolicConstraint> solutions = new ArrayList<SymbolicConstraint>();
        for (SymbolicConstraint candidate : unificationConstraint.getMultiConstraints()) {
            if (SymbolicConstraint.TruthValue.FALSE == candidate.addAll(constrainedTerm.lookups) || SymbolicConstraint.TruthValue.FALSE == candidate.addAll(constrainedTerm.constraint) || SymbolicConstraint.TruthValue.FALSE == candidate.addAll(this.constraint)) continue;
            candidate.simplify();
            if (candidate.isFalse() || !K.do_kompilation && candidate.checkUnsat()) continue;
            solutions.add(candidate);
        }
        if (K.do_testgen && !solutions.isEmpty()) {
            boolean changed;
            ArrayList<SymbolicConstraint> tmpSolutions = solutions;
            HashSet<Variable> sortIntersectionVariables = new HashSet<Variable>();
            HashMap<SymbolicConstraint, HashSet<Variable>> orientedVarsOfCnstr = new HashMap<SymbolicConstraint, HashSet<Variable>>();
            do {
                changed = false;
                solutions = tmpSolutions;
                tmpSolutions = new ArrayList();
                block2: for (SymbolicConstraint cnstr : solutions) {
                    HashSet<Variable> orientedVars = (HashSet<Variable>)orientedVarsOfCnstr.get(cnstr);
                    orientedVarsOfCnstr.remove(cnstr);
                    if (orientedVars == null) {
                        orientedVars = new HashSet<Variable>();
                    }
                    for (SymbolicConstraint.Equality equality : cnstr.equalities()) {
                        SymbolicConstraint newCnstr;
                        UninterpretedConstraint uninterpretedCnstr;
                        UninterpretedConstraint templCnstr;
                        Variable arg;
                        String sortName;
                        Term mbPredicate;
                        Term lhsOfEq = equality.leftHandSide();
                        if (lhsOfEq instanceof KItem && ((KItem)lhsOfEq).kLabel().toString().equals("'_=/=K_")) {
                            mbPredicate = ((KList)((KItem)lhsOfEq).kList()).get(0);
                            if (!(mbPredicate instanceof KItem) || !((KLabelConstant)((KItem)mbPredicate).kLabel()).label().startsWith("is")) continue;
                            sortName = ((KLabelConstant)((KItem)mbPredicate).kLabel()).label().substring("is".length());
                            arg = (Variable)((KList)((KItem)mbPredicate).kList()).get(0);
                            templCnstr = new UninterpretedConstraint();
                            ArrayList<UninterpretedConstraint> arrayList = new ArrayList<UninterpretedConstraint>();
                            for (SymbolicConstraint.Equality equality2 : cnstr.equalities()) {
                                if (equality2 == equality) continue;
                                templCnstr.add(equality2.leftHandSide(), equality2.rightHandSide());
                            }
                            for (Map.Entry<Variable, Term> entry : cnstr.substitution().entrySet()) {
                                templCnstr.add(entry.getKey(), entry.getValue());
                            }
                            for (Term term : this.computeSortDifference(arg.sort(), sortName)) {
                                uninterpretedCnstr = templCnstr.deepCopy();
                                uninterpretedCnstr.add(arg, term);
                                arrayList.add(uninterpretedCnstr);
                            }
                            for (UninterpretedConstraint uninterpretedConstraint : arrayList) {
                                newCnstr = uninterpretedConstraint.getSymbolicConstraint(this.context);
                                if (newCnstr.simplify() == SymbolicConstraint.TruthValue.FALSE) continue;
                                tmpSolutions.add(newCnstr);
                                orientedVarsOfCnstr.put(newCnstr, new HashSet<Variable>(orientedVars));
                            }
                            changed = true;
                            continue block2;
                        }
                        if (!equality.toString().startsWith("isKResult(")) continue;
                        mbPredicate = (KItem)equality.leftHandSide();
                        sortName = ((KLabelConstant)((KItem)mbPredicate).kLabel()).label().substring("is".length());
                        arg = (Variable)((KList)((KItem)mbPredicate).kList()).get(0);
                        templCnstr = new UninterpretedConstraint();
                        ArrayList<UninterpretedConstraint> arrayList = new ArrayList<UninterpretedConstraint>();
                        for (SymbolicConstraint.Equality equality3 : cnstr.equalities()) {
                            if (equality3 == equality) continue;
                            templCnstr.add(equality3.leftHandSide(), equality3.rightHandSide());
                        }
                        for (Map.Entry<Variable, Term> entry : cnstr.substitution().entrySet()) {
                            templCnstr.add(entry.getKey(), entry.getValue());
                        }
                        for (Variable variable : this.computeSortIntersection(arg.sort(), sortName)) {
                            uninterpretedCnstr = templCnstr.deepCopy();
                            uninterpretedCnstr.add(arg, variable);
                            arrayList.add(uninterpretedCnstr);
                        }
                        for (UninterpretedConstraint uninterpretedConstraint : arrayList) {
                            newCnstr = uninterpretedConstraint.getSymbolicConstraint(this.context);
                            if (newCnstr.simplify() == SymbolicConstraint.TruthValue.FALSE) continue;
                            tmpSolutions.add(newCnstr);
                            orientedVarsOfCnstr.put(newCnstr, new HashSet<Variable>(orientedVars));
                        }
                        changed = true;
                        continue block2;
                    }
                    cnstr.orientSubstitution(orientedVars);
                    for (Map.Entry entry : cnstr.substitution().entrySet()) {
                        if (entry.getValue() instanceof Variable) {
                            Variable lhs = (Variable)entry.getKey();
                            Variable rhs = (Variable)entry.getValue();
                            if (!lhs.sort().equals(rhs.sort())) {
                                if (sortIntersectionVariables.contains(lhs) || sortIntersectionVariables.contains(rhs)) continue;
                                UninterpretedConstraint templCnstr = new UninterpretedConstraint();
                                ArrayList<UninterpretedConstraint> uninterpretedCnstrs = new ArrayList<UninterpretedConstraint>();
                                for (SymbolicConstraint.Equality equality : cnstr.equalities()) {
                                    templCnstr.add(equality.leftHandSide(), equality.rightHandSide());
                                }
                                for (Map.Entry entry2 : cnstr.substitution().entrySet()) {
                                    templCnstr.add((Term)entry2.getKey(), (Term)entry2.getValue());
                                }
                                for (Variable variable : this.computeSortIntersection(lhs.sort(), rhs.sort())) {
                                    sortIntersectionVariables.add(variable);
                                    UninterpretedConstraint uninterpretedConstraint = templCnstr.deepCopy();
                                    uninterpretedConstraint.add(rhs, variable);
                                    uninterpretedCnstrs.add(uninterpretedConstraint);
                                }
                                for (UninterpretedConstraint uninterpretedConstraint : uninterpretedCnstrs) {
                                    SymbolicConstraint symbolicConstraint = uninterpretedConstraint.getSymbolicConstraint(this.context);
                                    if (symbolicConstraint.simplify() == SymbolicConstraint.TruthValue.FALSE) continue;
                                    tmpSolutions.add(symbolicConstraint);
                                    orientedVarsOfCnstr.put(symbolicConstraint, new HashSet<Variable>(orientedVars));
                                    ((Set)orientedVarsOfCnstr.get(symbolicConstraint)).add(lhs);
                                    ((Set)orientedVarsOfCnstr.get(symbolicConstraint)).add(rhs);
                                }
                                changed = true;
                                continue block2;
                            }
                        }
                        if (!(entry.getValue() instanceof MapLookup)) continue;
                        MapLookup mapLookup = (MapLookup)entry.getValue();
                        BuiltinMap map = (BuiltinMap)mapLookup.map();
                        Variable key = (Variable)mapLookup.key();
                        UninterpretedConstraint templCnstr = new UninterpretedConstraint();
                        ArrayList<UninterpretedConstraint> uninterpretedCnstrs = new ArrayList<UninterpretedConstraint>();
                        for (SymbolicConstraint.Equality equality : cnstr.equalities()) {
                            templCnstr.add(equality.leftHandSide(), equality.rightHandSide());
                        }
                        for (Map.Entry<Variable, Term> entry3 : cnstr.substitution().entrySet()) {
                            templCnstr.add(entry3.getKey(), entry3.getValue());
                        }
                        for (Map.Entry<Term, Term> entry4 : map.getEntries().entrySet()) {
                            UninterpretedConstraint uninterpretedConstraint = templCnstr.deepCopy();
                            uninterpretedConstraint.add(key, entry4.getKey());
                            uninterpretedCnstrs.add(uninterpretedConstraint);
                        }
                        for (UninterpretedConstraint uninterpretedConstraint : uninterpretedCnstrs) {
                            SymbolicConstraint symbolicConstraint = uninterpretedConstraint.getSymbolicConstraint(this.context);
                            if (symbolicConstraint.simplify() == SymbolicConstraint.TruthValue.FALSE) continue;
                            tmpSolutions.add(symbolicConstraint);
                            orientedVarsOfCnstr.put(symbolicConstraint, new HashSet<Variable>(orientedVars));
                        }
                        changed = true;
                        continue block2;
                    }
                    tmpSolutions.add(cnstr);
                }
            } while (changed);
        }
        return solutions;
    }

    private Set<Variable> computeSortIntersection(String sort1, String sort2) {
        HashSet<Variable> results = new HashSet<Variable>();
        Context defContext = this.context.definition().context();
        HashSet<String> subsorts = new HashSet<String>();
        for (String sort : defContext.getAllSorts()) {
            if (!defContext.isSubsortedEq(sort1, sort) || !defContext.isSubsortedEq(sort2, sort)) continue;
            subsorts.add(sort);
        }
        HashSet<String> sortsToRemove = new HashSet<String>();
        for (String s1 : subsorts) {
            for (String s2 : subsorts) {
                if (!defContext.isSubsorted(s1, s2)) continue;
                sortsToRemove.add(s2);
            }
        }
        subsorts.removeAll(sortsToRemove);
        for (String sort : subsorts) {
            results.add(Variable.getFreshVariable(sort));
        }
        return results;
    }

    private Set<Term> computeSortDifference(String sort1, String sort2) {
        HashSet<Term> results = new HashSet<Term>();
        Context defContext = this.context.definition().context();
        HashSet<String> whiteSorts = new HashSet<String>();
        for (String sort : defContext.getAllSorts()) {
            if (!defContext.isSubsortedEq(sort1, sort)) continue;
            whiteSorts.add(sort);
        }
        HashSet<String> blackSorts = new HashSet<String>();
        for (String sort : whiteSorts) {
            if (!defContext.isSubsortedEq(sort1, sort) || !defContext.isSubsortedEq(sort2, sort)) continue;
            blackSorts.add(sort);
        }
        whiteSorts.removeAll(blackSorts);
        HashSet<String> greySorts = new HashSet<String>();
        for (String sort : whiteSorts) {
            if (!defContext.isSubsortedEq(sort1, sort)) continue;
            for (String blackSort : blackSorts) {
                if (!defContext.isSubsorted(sort, blackSort)) continue;
                greySorts.add(sort);
            }
        }
        whiteSorts.removeAll(greySorts);
        HashSet<String> sortsToRemove = new HashSet<String>();
        for (String s1 : whiteSorts) {
            for (String s2 : whiteSorts) {
                if (!defContext.isSubsorted(s1, s2)) continue;
                sortsToRemove.add(s2);
            }
        }
        whiteSorts.removeAll(sortsToRemove);
        for (String whiteSort : whiteSorts) {
            results.add(Variable.getFreshVariable(whiteSort));
        }
        for (String greySort : greySorts) {
            results.addAll(this.getProductionsAsTerms(greySort));
        }
        return results;
    }

    private List<KItem> getProductionsAsTerms(String sort) {
        Definition def = this.context.definition();
        GroupProductionsBySort gpbs = cachedGroupProductionsBySort.get(def);
        if (gpbs == null) {
            gpbs = new GroupProductionsBySort(def);
            cachedGroupProductionsBySort.put(def, gpbs);
        }
        return gpbs.getProductionsAsTerms(sort, this.context);
    }

    @Override
    public boolean isSymbolic() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ConstrainedTerm)) {
            return false;
        }
        ConstrainedTerm constrainedTerm = (ConstrainedTerm)object;
        return this.term.equals(constrainedTerm.term) && this.lookups.equals(constrainedTerm.lookups) && this.constraint.equals(constrainedTerm.constraint);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 1;
            this.hashCode = this.hashCode * 47 + this.term.hashCode();
            this.hashCode = this.hashCode * 47 + this.lookups.hashCode();
            this.hashCode = this.hashCode * 47 + this.constraint.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        return this.term + " /\\ " + this.constraint + " /\\ " + this.lookups;
    }

    @Override
    public ASTNode accept(Transformer transformer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void accept(Unifier unifier, Term patten) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void accept(Matcher matcher, Term pattern) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

