/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.kil;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.kframework.backend.java.indexing.RuleIndex;
import org.kframework.backend.java.kil.JavaSymbolicObject;
import org.kframework.backend.java.kil.KLabelConstant;
import org.kframework.backend.java.kil.Rule;
import org.kframework.backend.java.symbolic.Transformer;
import org.kframework.backend.java.symbolic.Visitor;
import org.kframework.kil.ASTNode;
import org.kframework.kil.loader.Context;

public class Definition
extends JavaSymbolicObject {
    public static final Set<String> TOKEN_SORTS = ImmutableSet.of("Bool", "Int", "Float", "String", "List", "Set", new String[]{"Map"});
    private final List<Rule> rules;
    private final List<Rule> macros;
    private final Multimap<KLabelConstant, Rule> functionRules = ArrayListMultimap.create();
    private final Set<KLabelConstant> kLabels;
    private final Set<KLabelConstant> frozenKLabels;
    private final Set<KLabelConstant> sortPredLabels;
    private final Context context;
    private RuleIndex index;

    public Definition(Context context) {
        this.context = context;
        this.rules = new ArrayList<Rule>();
        this.macros = new ArrayList<Rule>();
        this.kLabels = new HashSet<KLabelConstant>();
        this.frozenKLabels = new HashSet<KLabelConstant>();
        this.sortPredLabels = new HashSet<KLabelConstant>();
    }

    public void addFrozenKLabel(KLabelConstant frozenKLabel) {
        this.frozenKLabels.add(frozenKLabel);
    }

    public void addFrozenKLabelCollection(Collection<KLabelConstant> frozenKLabels) {
        for (KLabelConstant frozenKLabel : frozenKLabels) {
            this.frozenKLabels.add(frozenKLabel);
        }
    }

    public void addKLabel(KLabelConstant kLabel) {
        this.kLabels.add(kLabel);
    }

    public void addKLabelCollection(Collection<KLabelConstant> kLabels) {
        for (KLabelConstant kLabel : kLabels) {
            this.kLabels.add(kLabel);
        }
    }

    public void addRule(Rule rule) {
        if (rule.containsAttribute("function")) {
            this.functionRules.put(rule.functionKLabel(), rule);
            if (rule.isSortPredicate()) {
                this.sortPredLabels.add(rule.functionKLabel());
            }
        } else if (rule.containsAttribute("macro")) {
            this.macros.add(rule);
        } else {
            this.rules.add(rule);
        }
    }

    public void addRuleCollection(Collection<Rule> rules) {
        for (Rule rule : rules) {
            this.addRule(rule);
        }
    }

    public Set<String> builtinSorts() {
        return Sets.union(this.tokenSorts(), TOKEN_SORTS);
    }

    public Context context() {
        return this.context;
    }

    public Multimap<KLabelConstant, Rule> functionRules() {
        return this.functionRules;
    }

    public Set<KLabelConstant> frozenKLabels() {
        return this.frozenKLabels;
    }

    public Set<KLabelConstant> kLabels() {
        return Collections.unmodifiableSet(this.kLabels);
    }

    public Set<KLabelConstant> sortPredLabels() {
        return this.sortPredLabels;
    }

    public List<Rule> macros() {
        return this.macros;
    }

    public List<Rule> rules() {
        return this.rules;
    }

    public Set<String> tokenSorts() {
        return this.context.getTokenSorts();
    }

    @Override
    public ASTNode accept(Transformer transformer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void accept(Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    public void setIndex(RuleIndex index) {
        this.index = index;
    }

    public RuleIndex getIndex() {
        return this.index;
    }
}

