/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.kil;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import org.kframework.backend.java.kil.Collection;
import org.kframework.backend.java.kil.KItemProjection;
import org.kframework.backend.java.kil.KList;
import org.kframework.backend.java.kil.KSequence;
import org.kframework.backend.java.kil.Kind;
import org.kframework.backend.java.kil.Sorted;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.kil.Variable;
import org.kframework.backend.java.symbolic.Transformer;
import org.kframework.backend.java.symbolic.Visitor;
import org.kframework.kil.ASTNode;

public abstract class KCollection
extends Collection
implements Iterable<Term>,
Sorted {
    protected final ImmutableList<Term> contents;

    protected KCollection(ImmutableList<Term> items, Variable frame, Kind kind) {
        super(frame, kind);
        ArrayList<Term> normalizedItems = new ArrayList<Term>();
        for (Term term : items) {
            if (!(term instanceof Variable) && !(term instanceof KItemProjection) && term.kind() == kind) {
                assert (term instanceof KCollection) : "associative use of KCollection(" + items + ", " + frame + ")";
                KCollection kCollection = (KCollection)term;
                assert (!kCollection.hasFrame()) : "associative use of KCollection";
                normalizedItems.addAll(kCollection.getContents());
                continue;
            }
            normalizedItems.add(term);
        }
        this.contents = ImmutableList.copyOf(normalizedItems);
    }

    protected KCollection(Variable frame, Kind kind) {
        super(frame, kind);
        this.contents = ImmutableList.of();
    }

    public abstract KCollection fragment(int var1);

    public Term get(int index) {
        return (Term)this.contents.get(index);
    }

    public abstract String getSeparatorName();

    public abstract String getIdentityName();

    public ImmutableList<Term> getContents() {
        return this.contents;
    }

    @Override
    public Iterator<Term> iterator() {
        return this.contents.iterator();
    }

    @Override
    public int size() {
        return this.contents.size();
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 1;
            this.hashCode = this.hashCode * 47 + (this.frame == null ? 0 : this.frame.hashCode());
            this.hashCode = this.hashCode * 47 + this.contents.hashCode();
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof KCollection)) {
            return false;
        }
        KCollection kCollection = (KCollection)object;
        return (this.frame == null ? kCollection.frame == null : this.frame.equals(kCollection.frame)) && this.contents.equals(kCollection.contents);
    }

    public String toString() {
        Joiner joiner = Joiner.on(this.getSeparatorName());
        StringBuilder stringBuilder = new StringBuilder();
        joiner.appendTo(stringBuilder, (Iterable<?>)this.contents);
        if (this.frame != null) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(this.getSeparatorName());
            }
            stringBuilder.append(this.frame);
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append(this.getIdentityName());
        }
        return stringBuilder.toString();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ASTNode accept(Transformer transformer) {
        return transformer.transform(this);
    }

    public static Term upKind(Term term, Kind kind) {
        assert (term.kind() == Kind.KITEM || term.kind() == Kind.K || term.kind() == Kind.KLIST);
        assert (kind == Kind.KITEM || kind == Kind.K || kind == Kind.KLIST);
        if (term.kind() == Kind.KITEM && (kind == Kind.K || kind == Kind.KLIST)) {
            term = new KSequence(ImmutableList.of(term));
        }
        if (term.kind() == Kind.K && kind == Kind.KLIST) {
            term = new KList(ImmutableList.of(term));
        }
        return term;
    }

    public static Term downKind(Term term) {
        assert (term.kind() == Kind.KITEM || term.kind() == Kind.K || term.kind() == Kind.KLIST);
        if (term instanceof KList && !((KList)term).hasFrame() && ((KList)term).size() == 1) {
            term = ((KList)term).get(0);
        }
        if (term instanceof KSequence && !((KSequence)term).hasFrame() && ((KSequence)term).size() == 1) {
            term = ((KSequence)term).get(0);
        }
        return term;
    }
}

