/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.kil;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import org.kframework.backend.java.kil.KCollection;
import org.kframework.backend.java.kil.Sorted;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.symbolic.Matcher;
import org.kframework.backend.java.symbolic.Transformer;
import org.kframework.backend.java.symbolic.Unifier;
import org.kframework.backend.java.symbolic.Visitor;
import org.kframework.kil.ASTNode;

public class KCollectionFragment
extends KCollection {
    private final int startIndex;
    private final KCollection kCollection;
    private String sort;

    public KCollectionFragment(KCollection kCollection, int startIndex) {
        super(kCollection.getContents(), kCollection.hasFrame() ? kCollection.frame() : null, kCollection.kind());
        assert (0 <= startIndex && startIndex <= kCollection.size());
        this.kCollection = kCollection;
        this.startIndex = startIndex;
    }

    @Override
    public KCollection fragment(int fromIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String sort() {
        Term term;
        if (this.sort != null) {
            return this.sort;
        }
        this.sort = this.size() == 1 && !this.hasFrame() ? ((term = (Term)this.contents.get(this.startIndex)) instanceof Sorted ? ((Sorted)((Object)term)).sort() : term.kind().toString()) : this.kCollection.sort();
        return this.sort;
    }

    @Override
    public Term get(int index) {
        assert (index >= this.startIndex);
        return (Term)this.contents.get(index);
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public KCollection getKCollection() {
        return this.kCollection;
    }

    @Override
    public String getSeparatorName() {
        return this.kCollection.getSeparatorName();
    }

    @Override
    public String getIdentityName() {
        return this.kCollection.getIdentityName();
    }

    @Override
    public ImmutableList<Term> getContents() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Term> iterator() {
        return this.contents.listIterator(this.startIndex);
    }

    @Override
    public int size() {
        return this.contents.size() - this.startIndex;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = super.hashCode();
            this.hashCode = this.hashCode * 47 + this.startIndex;
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof KCollectionFragment)) {
            return false;
        }
        KCollectionFragment kCollectionFragment = (KCollectionFragment)object;
        return this.startIndex == kCollectionFragment.startIndex && this.kCollection.equals(kCollectionFragment.kCollection);
    }

    @Override
    public String toString() {
        Joiner joiner = Joiner.on(this.getSeparatorName());
        StringBuilder stringBuilder = new StringBuilder();
        joiner.appendTo(stringBuilder, (Iterable<?>)this.contents.subList(this.startIndex, this.contents.size()));
        if (super.hasFrame()) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(this.getSeparatorName());
            }
            stringBuilder.append(super.frame());
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append(this.getIdentityName());
        }
        return stringBuilder.toString();
    }

    @Override
    public ASTNode shallowCopy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void accept(Unifier unifier, Term pattern) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void accept(Matcher matcher, Term pattern) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ASTNode accept(Transformer transformer) {
        return transformer.transform(this);
    }
}

