/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.kil;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kframework.backend.java.builtins.BoolToken;
import org.kframework.backend.java.builtins.IntToken;
import org.kframework.backend.java.builtins.MetaK;
import org.kframework.backend.java.builtins.SortMembership;
import org.kframework.backend.java.kil.ConstrainedTerm;
import org.kframework.backend.java.kil.Definition;
import org.kframework.backend.java.kil.JavaSymbolicObject;
import org.kframework.backend.java.kil.KLabel;
import org.kframework.backend.java.kil.KLabelConstant;
import org.kframework.backend.java.kil.KLabelInjection;
import org.kframework.backend.java.kil.KList;
import org.kframework.backend.java.kil.Kind;
import org.kframework.backend.java.kil.Rule;
import org.kframework.backend.java.kil.Sorted;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.kil.TermContext;
import org.kframework.backend.java.kil.Variable;
import org.kframework.backend.java.symbolic.BuiltinFunction;
import org.kframework.backend.java.symbolic.Matcher;
import org.kframework.backend.java.symbolic.SymbolicConstraint;
import org.kframework.backend.java.symbolic.Transformer;
import org.kframework.backend.java.symbolic.Unifier;
import org.kframework.backend.java.symbolic.Visitor;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Production;
import org.kframework.kil.loader.Context;
import org.kframework.krun.K;
import org.kframework.utils.general.GlobalSettings;

public class KItem
extends Term
implements Sorted {
    private final Term kLabel;
    private final Term kList;
    private final String sort;
    private Boolean evaluable = null;
    private final Set<String> possibleMinimalSorts;

    public KItem(Term kLabel, Term kList, TermContext termContext) {
        super(Kind.KITEM);
        this.kLabel = kLabel;
        this.kList = kList;
        Definition definition = termContext.definition();
        Context context = definition.context();
        HashSet<String> possibleMinimalSorts = null;
        if (kLabel instanceof KLabelConstant && ((KLabelConstant)kLabel).isConstructor()) {
            possibleMinimalSorts = new HashSet<String>();
        }
        if (kLabel instanceof KLabelConstant && kList instanceof KList && !((KList)kList).hasFrame()) {
            KLabelConstant kLabelConstant = (KLabelConstant)kLabel;
            List<Production> productions = kLabelConstant.productions();
            if (productions.size() != 0) {
                HashSet<String> sorts = new HashSet<String>();
                if (!K.do_kompilation) {
                    for (KLabelConstant sortPredLabel : definition.sortPredLabels()) {
                        Collection<Rule> rules = definition.functionRules().get(sortPredLabel);
                        for (Rule rule : rules) {
                            KItem predArg = rule.getSortPredArgument();
                            if (!MetaK.matchable(kLabel, predArg.kLabel(), termContext).equals(BoolToken.TRUE) || !MetaK.matchable(kList, predArg.kList(), termContext).equals(BoolToken.TRUE)) continue;
                            sorts.add(rule.getPredSort());
                        }
                    }
                }
                for (Production production : productions) {
                    boolean mustMatch = true;
                    boolean mayMatch = true;
                    if (((KList)kList).size() == production.getArity()) {
                        for (int i = 0; i < ((KList)kList).size(); ++i) {
                            KItem kItem;
                            Term childTerm = ((KList)kList).get(i);
                            if (childTerm instanceof KItem && KItem.isInjectionWrapper(kItem = (KItem)childTerm)) {
                                childTerm = KItem.extractInjectedTerm(kItem);
                            }
                            String childSort = childTerm instanceof Sorted ? ((Sorted)((Object)childTerm)).sort() : this.kind.toString();
                            if (context.isSubsortedEq(production.getChildSort(i), childSort)) continue;
                            mustMatch = false;
                            if (!kLabelConstant.isConstructor()) continue;
                            if (childTerm instanceof Variable) {
                                HashSet<String> set = Sets.newHashSet(production.getChildSort(i), ((Variable)childTerm).sort());
                                if (context.getCommonSubsorts(set).isEmpty()) {
                                    mayMatch = false;
                                }
                            } else if (childTerm instanceof KItem) {
                                mayMatch = false;
                                if (((KItem)childTerm).kLabel instanceof KLabel && ((KLabel)((KItem)childTerm).kLabel).isConstructor()) {
                                    for (String pms : ((KItem)childTerm).possibleMinimalSorts()) {
                                        if (!context.isSubsortedEq(production.getChildSort(i), pms)) continue;
                                        mayMatch = true;
                                        break;
                                    }
                                }
                            } else {
                                mayMatch = false;
                            }
                            if (!mayMatch) break;
                        }
                    }
                    if (mustMatch) {
                        sorts.add(production.getSort());
                    }
                    if (!mayMatch || !kLabelConstant.isConstructor()) continue;
                    possibleMinimalSorts.add(production.getSort());
                }
                if (!sorts.isEmpty()) {
                    if (sorts.size() == 1) {
                        this.sort = (String)sorts.iterator().next();
                    } else {
                        this.sort = context.getGLBSort(sorts);
                        assert (this.sort != null && !this.sort.equals("null")) : "The greatest lower bound (GLB) of sorts " + sorts + "doesn't exist!";
                    }
                } else {
                    this.sort = this.kind.toString();
                }
            } else {
                Set<String> listSorts = context.listLabels.get(kLabelConstant.label());
                this.sort = listSorts != null && ((KList)kList).size() == 0 ? (listSorts.size() == 1 ? listSorts.iterator().next() : context.getGLBSort(listSorts)) : this.kind.toString();
            }
        } else {
            this.sort = this.kind.toString();
        }
        if (possibleMinimalSorts != null) {
            possibleMinimalSorts.add(this.sort);
            HashSet<String> nonMinimalSorts = new HashSet<String>();
            for (String s1 : possibleMinimalSorts) {
                for (String s2 : possibleMinimalSorts) {
                    if (!context.isSubsorted(s1, s2)) continue;
                    nonMinimalSorts.add(s1);
                }
            }
            possibleMinimalSorts.removeAll(nonMinimalSorts);
            this.possibleMinimalSorts = possibleMinimalSorts;
        } else {
            this.possibleMinimalSorts = null;
        }
    }

    public boolean isEvaluable(TermContext context) {
        if (this.evaluable != null) {
            return this.evaluable;
        }
        this.evaluable = false;
        if (!(this.kLabel instanceof KLabelConstant)) {
            return false;
        }
        KLabelConstant kLabelConstant = (KLabelConstant)this.kLabel;
        if (!(this.kList instanceof KList)) {
            return false;
        }
        if (kLabelConstant.label().startsWith("is") || !context.definition().functionRules().get(kLabelConstant).isEmpty() || BuiltinFunction.isBuiltinKLabel(kLabelConstant)) {
            this.evaluable = true;
        }
        return this.evaluable;
    }

    public Term evaluateFunction(SymbolicConstraint constraint, TermContext context) {
        block33: {
            JavaSymbolicObject result;
            Term checkResult;
            if (!this.isEvaluable(context)) {
                return this;
            }
            Definition definition = context.definition();
            if (!(this.kLabel instanceof KLabelConstant)) {
                return this;
            }
            KLabelConstant kLabelConstant = (KLabelConstant)this.kLabel;
            if (!(this.kList instanceof KList)) {
                return this;
            }
            KList kList = (KList)this.kList;
            if (kLabelConstant.label().startsWith("is") && kList.getContents().size() == 1 && kList.getContents().get(0) instanceof Sorted && (checkResult = SortMembership.check(this, context.definition().context())) != this) {
                return checkResult;
            }
            if (!definition.functionRules().get(kLabelConstant).isEmpty()) {
                ConstrainedTerm constrainedTerm = new ConstrainedTerm(kList, context);
                result = null;
                boolean mayUseOwiseRule = true;
                LinkedHashSet<Term> owiseResults = new LinkedHashSet<Term>();
                for (Rule rule : definition.functionRules().get(kLabelConstant)) {
                    SymbolicConstraint leftHandSideConstraint = new SymbolicConstraint(context);
                    leftHandSideConstraint.addAll(rule.requires());
                    for (Variable variable : rule.freshVariables()) {
                        leftHandSideConstraint.add(variable, IntToken.fresh());
                    }
                    ConstrainedTerm leftHandSide = new ConstrainedTerm(((KItem)rule.leftHandSide()).kList, rule.lookups().getSymbolicConstraint(context), leftHandSideConstraint, context);
                    List<SymbolicConstraint> solutions = constrainedTerm.unify(leftHandSide);
                    if (solutions.isEmpty()) continue;
                    SymbolicConstraint solution = (SymbolicConstraint)solutions.iterator().next();
                    if (K.do_kompilation) {
                        assert (solutions.size() <= 1) : "function definition is not deterministic";
                        if (!solution.isMatching(leftHandSide)) {
                            mayUseOwiseRule = false;
                            continue;
                        }
                    } else if (K.do_concrete_exec) {
                        assert (solutions.size() <= 1) : "function definition is not deterministic";
                        assert (solution.isMatching(leftHandSide)) : "Pattern matching expected in concrete execution mode";
                    }
                    solution.orientSubstitution(rule.leftHandSide().variableSet());
                    Term rightHandSide = rule.rightHandSide();
                    if (rule.hasUnboundedVariables()) {
                        Map<Variable, Variable> freshSubstitution = solution.rename(rule.variableSet());
                        result = ((Term)result).substituteWithBinders(freshSubstitution, context);
                    }
                    rightHandSide = rightHandSide.substituteAndEvaluate(solution.substitution(), context);
                    if (!K.do_kompilation && !K.do_concrete_exec) {
                        if (constraint != null) {
                            throw new RuntimeException("Fix it; need to find a proper way to update the constraint without interferring with the potential ongoing normalization process");
                        }
                        if (solution.isUnknown() || solution.isFalse()) {
                            throw new RuntimeException("Fix it; no reference to the symbolic constraint that needs to be updated");
                        }
                    }
                    if (rule.containsAttribute("owise")) {
                        owiseResults.add(rightHandSide);
                    } else {
                        if (K.do_concrete_exec) assert (result == null || result.equals(rightHandSide)) : "function definition is not deterministic";
                        result = rightHandSide;
                    }
                    if (K.deterministic_functions || result == null) continue;
                    return result;
                }
                if (result != null) {
                    return result;
                }
                if (mayUseOwiseRule && !owiseResults.isEmpty()) {
                    assert (owiseResults.size() == 1) : "function definition is not deterministic";
                    return (Term)owiseResults.iterator().next();
                }
            }
            if (!BuiltinFunction.isBuiltinKLabel(kLabelConstant)) {
                return this;
            }
            try {
                Term[] arguments = kList.getContents().toArray(new Term[kList.getContents().size()]);
                result = BuiltinFunction.invoke(context, kLabelConstant, arguments);
                if (result == null) {
                    result = this;
                } else if (result instanceof KLabel) {
                    result = new KItem(new KLabelInjection((Term)result), new KList(), context);
                } else if (result instanceof KList) assert (false) : "YilongL: Fix it; handle the case where the return value is a KList";
                return result;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
            }
            catch (RuntimeException e) {
                if (!GlobalSettings.verbose) break block33;
                System.err.println("Ignored exception thrown by hook " + kLabelConstant + " : ");
                e.printStackTrace();
            }
        }
        return this;
    }

    public Term kLabel() {
        return this.kLabel;
    }

    public Term kList() {
        return this.kList;
    }

    @Override
    public boolean isSymbolic() {
        return this.kLabel instanceof KLabel && ((KLabel)this.kLabel).isFunction();
    }

    @Override
    public String sort() {
        return this.sort;
    }

    public Set<String> possibleMinimalSorts() {
        if (this.possibleMinimalSorts != null) {
            return Collections.unmodifiableSet(this.possibleMinimalSorts);
        }
        return null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof KItem)) {
            return false;
        }
        KItem kItem = (KItem)object;
        return this.kLabel.equals(kItem.kLabel) && this.kList.equals(kItem.kList);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 1;
            this.hashCode = this.hashCode * 47 + this.kLabel.hashCode();
            this.hashCode = this.hashCode * 47 + this.kList.hashCode();
            this.hashCode = this.hashCode * 47 + this.sort.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        return this.kLabel + "(" + this.kList.toString() + ")";
    }

    @Override
    public void accept(Unifier unifier, Term pattern) {
        unifier.unify(this, pattern);
    }

    @Override
    public void accept(Matcher matcher, Term pattern) {
        matcher.match(this, pattern);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ASTNode accept(Transformer transformer) {
        return transformer.transform(this);
    }

    public static boolean isInjectionWrapper(KItem kItem) {
        return kItem.kLabel.getClass() == KLabelInjection.class && kItem.kList instanceof KList && ((KList)kItem.kList).contents.isEmpty();
    }

    public static Term extractInjectedTerm(KItem kItem) {
        assert (KItem.isInjectionWrapper(kItem));
        return ((KLabelInjection)kItem.kLabel).term();
    }
}

