/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.kil;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.kframework.backend.java.kil.KLabel;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.kil.TermContext;
import org.kframework.backend.java.symbolic.Matcher;
import org.kframework.backend.java.symbolic.Transformer;
import org.kframework.backend.java.symbolic.Unifier;
import org.kframework.backend.java.symbolic.Visitor;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Attribute;
import org.kframework.kil.Production;

public class KLabelConstant
extends KLabel {
    private static final HashMap<String, KLabelConstant> cache = new HashMap();
    private final String label;
    private final ImmutableList<Production> productions;
    private final boolean isFunction;
    private final TermContext termContext;

    private KLabelConstant(String label, TermContext termContext) {
        this.label = label;
        this.productions = ImmutableList.copyOf(termContext.definition().context().productionsOf(label));
        boolean isFunction = false;
        if (!label.startsWith("is")) {
            Iterator iterator = this.productions.iterator();
            if (iterator.hasNext()) {
                Production fstProd = (Production)iterator.next();
                boolean bl = isFunction = fstProd.containsAttribute(Attribute.FUNCTION.getKey()) || fstProd.containsAttribute(Attribute.PREDICATE.getKey());
            }
            while (iterator.hasNext()) {
                Production production = (Production)iterator.next();
                assert (isFunction == (production.containsAttribute(Attribute.FUNCTION.getKey()) || production.containsAttribute(Attribute.PREDICATE.getKey()))) : "Cannot determine if the KLabel " + label + " is a function symbol because there are multiple productions associated with this KLabel: " + this.productions;
            }
        } else {
            isFunction = true;
        }
        this.isFunction = isFunction;
        this.termContext = termContext;
    }

    public static KLabelConstant of(String label, TermContext termContext) {
        assert (label != null);
        KLabelConstant kLabelConstant = cache.get(label);
        if (kLabelConstant == null) {
            kLabelConstant = new KLabelConstant(label, termContext);
            cache.put(label, kLabelConstant);
        }
        return kLabelConstant;
    }

    @Override
    public boolean isConstructor() {
        return !this.isFunction;
    }

    @Override
    public boolean isFunction() {
        return this.isFunction;
    }

    public String label() {
        return this.label;
    }

    public List<Production> productions() {
        return this.productions;
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.label.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        return this.label;
    }

    @Override
    public void accept(Unifier unifier, Term pattern) {
        unifier.unify(this, pattern);
    }

    @Override
    public void accept(Matcher matcher, Term pattern) {
        matcher.match(this, pattern);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ASTNode accept(Transformer transformer) {
        return transformer.transform(this);
    }

    private Object readResolve() {
        KLabelConstant kLabelConstant = cache.get(this.label);
        if (kLabelConstant == null) {
            kLabelConstant = this;
            cache.put(this.label, kLabelConstant);
        }
        return kLabelConstant;
    }

    public TermContext termContext() {
        return this.termContext;
    }

    public boolean isBinder() {
        for (Production production : this.productions) {
            if (!production.containsAttribute("binder")) continue;
            return true;
        }
        return false;
    }

    public Multimap<Integer, Integer> getBinderMap() {
        for (Production production : this.productions) {
            if (!production.containsAttribute("binder")) continue;
            return production.getBinderMap();
        }
        return null;
    }
}

