/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.kil;

import com.google.common.collect.ImmutableList;
import org.kframework.backend.java.kil.KCollection;
import org.kframework.backend.java.kil.Kind;
import org.kframework.backend.java.kil.Sorted;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.kil.Variable;
import org.kframework.backend.java.symbolic.Matcher;
import org.kframework.backend.java.symbolic.Transformer;
import org.kframework.backend.java.symbolic.Unifier;
import org.kframework.backend.java.symbolic.Visitor;
import org.kframework.kil.ASTNode;

public class KList
extends KCollection {
    private static final String SEPARATOR_NAME = ",, ";
    private static final String IDENTITY_NAME = "." + (Object)((Object)Kind.KLIST);
    private String sort;

    public KList(ImmutableList<Term> items, Variable frame) {
        super(items, frame, Kind.KLIST);
    }

    public KList(Variable frame) {
        super(frame, Kind.KLIST);
    }

    public KList(ImmutableList<Term> items) {
        super(items, null, Kind.KLIST);
    }

    public KList() {
        super(null, Kind.KLIST);
    }

    @Override
    public KCollection fragment(int fromIndex) {
        return new KList((ImmutableList<Term>)this.contents.subList(fromIndex, this.contents.size()), this.frame);
    }

    @Override
    public String sort() {
        Term term;
        if (this.sort != null) {
            return this.sort;
        }
        this.sort = this.size() == 1 && !this.hasFrame() ? ((term = (Term)this.contents.get(0)) instanceof Sorted ? ((Sorted)((Object)term)).sort() : term.kind().toString()) : "KList";
        return this.sort;
    }

    @Override
    public String getSeparatorName() {
        return SEPARATOR_NAME;
    }

    @Override
    public String getIdentityName() {
        return IDENTITY_NAME;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof KList)) {
            return false;
        }
        KList kList = (KList)object;
        return (this.frame == null ? kList.frame == null : this.frame.equals(kList.frame)) && this.contents.equals(kList.contents);
    }

    @Override
    public void accept(Unifier unifier, Term pattern) {
        unifier.unify(this, pattern);
    }

    @Override
    public void accept(Matcher matcher, Term pattern) {
        matcher.match(this, pattern);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ASTNode accept(Transformer transformer) {
        return transformer.transform(this);
    }
}

