/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.kil;

import com.google.common.collect.EnumHashBiMap;

public enum Kind {
    BOTTOM,
    CELL,
    CELL_COLLECTION,
    K,
    KITEM,
    KLABEL,
    KLIST;

    private static final EnumHashBiMap<Kind, String> names;

    public static Kind of(String sort) {
        Kind kind = (Kind)((Object)names.inverse().get(sort));
        if (kind != null) {
            return kind;
        }
        return KITEM;
    }

    public boolean isComputational() {
        return this == KITEM || this == K || this == KLIST;
    }

    public boolean isStructural() {
        return this == CELL || this == CELL_COLLECTION;
    }

    public String toString() {
        return (String)names.get((Object)this);
    }

    static {
        names = EnumHashBiMap.create(Kind.class);
        names.put(BOTTOM, "Bottom");
        names.put(CELL, "BagItem");
        names.put(CELL_COLLECTION, "Bag");
        names.put(K, "K");
        names.put(KITEM, "KItem");
        names.put(KLABEL, "KLabel");
        names.put(KLIST, "KList");
    }
}

